/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.rpc.ServiceException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.imageplatform.common.ImageOperaionEnum;
import kd.bos.imageplatform.helper.NoticeImageSysHelper;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSys2getScanHomeInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysCancelRescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysStartWorkFlow;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.ksql.util.StringUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class NoticeImageSysHelper_IMC
extends NoticeImageSysHelper {
    private static final String ERRORDESCNO_SUCCESS = "0000";
    private static final String APP_IMAGE_URL = "/imgsys/bill/h5/getH5ViewPageUrl?access_token=";
    private static final Log log = LogFactory.getLog(NoticeImageSysHelper_IMC.class);
    private static final int DEFAULT_MAX_RETYR = 3;
    private static final int DEFAULT_BASE_DELAY = 1000;
    public final String symbol = "IMC";

    @Override
    public String getScanHomeUrl(NoticeImageSys2getScanHomeInfo scanHomeInfo) throws Exception, ServiceException {
        JSONObject params = new JSONObject();
        params.put("language", (Object)Lang.get().name());
        log.info("\u83b7\u53d6\u91c7\u96c6\u9996\u9875\u53c2\u6570:" + params.toJSONString());
        JSONObject resultJSON = this.request("getScanHomeUrl", (Map<String, Object>)params);
        log.info("\u83b7\u53d6\u91c7\u96c6\u9996\u9875\u7ed3\u679c:" + resultJSON.toJSONString());
        if (ERRORDESCNO_SUCCESS.equals(resultJSON.get((Object)"errcode"))) {
            JSONObject data = resultJSON.getJSONObject("data");
            return data.getString("url");
        }
        throw new Exception(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u91c7\u96c6\u9996\u9875\u5931\u8d25\uff0c\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_2", (String)"bos-image-formplugin", (Object[])new Object[0]), resultJSON.toJSONString()));
    }

    @Override
    public String rescan(NoticeImageSys2RescanInfo rescanInfo) throws Exception {
        JSONObject params = new JSONObject();
        params.put("scanBillNo", (Object)rescanInfo.getBarCode());
        params.put("rejectReason", (Object)rescanInfo.getRescanMessage());
        log.info("\u5f71\u50cf\u9000\u626b\u53c2\u6570:" + params.toJSONString());
        JSONObject resultJSON = this.request("rescan", (Map<String, Object>)params);
        log.info("\u5f71\u50cf\u9000\u626b\u7ed3\u679c:" + resultJSON.toJSONString());
        if (ERRORDESCNO_SUCCESS.equals(resultJSON.getString("errcode"))) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_3", (String)"bos-image-formplugin", (Object[])new Object[0]), resultJSON.toJSONString()));
    }

    @Override
    public String cancelRescan(NoticeImageSysCancelRescanInfo cancelRescanInfo) throws Exception {
        JSONObject params = new JSONObject();
        params.put("scanBillNo", (Object)cancelRescanInfo.getBarCode());
        params.put("cancelRejectReason", (Object)cancelRescanInfo.getCancelMessage());
        log.info("\u53d6\u6d88\u9000\u626b\u53c2\u6570:" + params.toJSONString());
        JSONObject resultJSON = this.request("cancelRescan", (Map<String, Object>)params);
        log.info("\u53d6\u6d88\u9000\u626b\u7ed3\u679c:" + resultJSON.toJSONString());
        if (ERRORDESCNO_SUCCESS.equals(resultJSON.getString("errcode"))) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_3", (String)"bos-image-formplugin", (Object[])new Object[0]), resultJSON.toJSONString()));
    }

    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws Exception {
        JSONObject resultJSON;
        boolean isApp = viewPhotoInfo.getisApp();
        JSONObject params = new JSONObject();
        params.put("scanBillNo", (Object)viewPhotoInfo.getBarCode());
        params.put("isRemark", (Object)Boolean.FALSE);
        params.put("isRescan", (Object)Boolean.FALSE);
        params.put("isEdit", (Object)Boolean.FALSE);
        log.info("\u67e5\u770b\u5f71\u50cf\u53c2\u6570:" + params.toJSONString());
        if (isApp) {
            params.put("language", (Object)Lang.get().name());
            resultJSON = this.request("getH5ViewPageUrl", (Map<String, Object>)params);
        } else {
            resultJSON = this.request("viewPhoto", (Map<String, Object>)params);
        }
        log.info("\u67e5\u770b\u5f71\u50cf\u53c2\u6570\u7ed3\u679c:" + resultJSON.toJSONString());
        if (ERRORDESCNO_SUCCESS.equals(resultJSON.getString("errcode"))) {
            JSONObject data = resultJSON.getJSONObject("data");
            return data.getString("url");
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u661f\u701a\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_IMC_3", (String)"bos-image-formplugin", (Object[])new Object[0]), resultJSON.toJSONString()));
    }

    @Override
    public String viewPhotoOnPhone() throws Exception {
        return null;
    }

    @Override
    public String viewPhotos() throws Exception {
        return null;
    }

    @Override
    public String viewPhotosOnPhone() throws Exception {
        return null;
    }

    @Override
    public String imageUpload() throws Exception {
        return null;
    }

    @Override
    public String synVoucherInfo() throws Exception {
        return null;
    }

    @Override
    public String deleteImage() throws Exception {
        return null;
    }

    @Override
    public String destroyImage(NoticeImageSysDestroyInfo destroyInfo) throws Exception {
        JSONObject params = new JSONObject();
        params.put("scanBillNo", (Object)destroyInfo.getImageNo());
        params.put("deleteReason", (Object)destroyInfo.getMessage());
        log.info("\u5220\u9664\u5f71\u50cf\u53c2\u6570:" + params.toJSONString());
        JSONObject resultJSON = this.request("destroyImage", (Map<String, Object>)params);
        log.info("\u5220\u9664\u5f71\u50cf\u7ed3\u679c:" + resultJSON.toJSONString());
        if (ERRORDESCNO_SUCCESS.equals(resultJSON.getString("errcode"))) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_3", (String)"bos-image-formplugin", (Object[])new Object[0]), resultJSON.toJSONString()));
    }

    @Override
    public String submit2ImageSys() throws Exception {
        return null;
    }

    @Override
    public String startWorkFlow(NoticeImageSysStartWorkFlow startWorkFlow) throws Exception {
        return "1";
    }

    @Override
    public ImageInfo auditImage(ImageInfo imageInfo) {
        try {
            JSONObject params = new JSONObject();
            params.put("scanBillNo", (Object)imageInfo.getImageNo());
            log.info("\u5f71\u50cf\u5ba1\u6838\u53c2\u6570:" + params.toJSONString());
            JSONObject resultJSON = this.request("auditImage", (Map<String, Object>)params);
            log.info("\u5f71\u50cf\u5ba1\u6838\u7ed3\u679c:" + resultJSON.toJSONString());
            if (!ERRORDESCNO_SUCCESS.equals(resultJSON.getString("errcode"))) {
                throw new KDBizException(resultJSON.toJSONString());
            }
            log.info("\u5f71\u50cf\u5ba1\u6838\u901a\u8fc7" + imageInfo.getImageNo());
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u5ba1\u6838\u62a5\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
        return imageInfo;
    }

    @Override
    public ImageInfo enableArchive(ImageInfo imageInfo) {
        try {
            String respResult = this.pushImageEnableArchive(imageInfo);
            if (StringUtil.equals((String)"1", (String)respResult)) {
                return imageInfo;
            }
            String tryAaginPushResult = this.tryAaginPushEnabeleArchive(imageInfo);
            if (StringUtil.equals((String)"1", (String)tryAaginPushResult)) {
                return imageInfo;
            }
            log.error("\u5f71\u50cf\u662f\u5426\u53ef\u4ee5\u5f52\u6863\u63a8\u9001\u5931\u8d25\uff1a" + tryAaginPushResult);
            imageInfo.setBillData(tryAaginPushResult);
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.ARCHIVE);
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u662f\u5426\u53ef\u4ee5\u5f52\u6863\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            imageInfo.setBillData(e.getMessage());
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.ARCHIVE);
        }
        return null;
    }

    private String tryAaginPushEnabeleArchive(ImageInfo imageInfo) throws InterruptedException {
        AtomicInteger retryCounter = new AtomicInteger(0);
        String respResult = "-2";
        while (retryCounter.intValue() < 3) {
            int i = retryCounter.incrementAndGet();
            Thread.sleep(1000 * i);
            log.info("\u53d1\u7968\u4e91\u5355\u636e\u662f\u5426\u53ef\u4ee5\u5f52\u6863\u63a8\u9001\u5931\u8d25\uff0c\u5f00\u59cb\u7b2c" + i + "\u6b21\u91cd\u8bd5");
            respResult = this.pushImageEnableArchive(imageInfo);
            if (!StringUtil.equals((String)"1", (String)respResult)) continue;
            return "1";
        }
        return respResult;
    }

    private String pushImageEnableArchive(ImageInfo imageInfo) {
        try {
            JSONObject params = new JSONObject();
            params.put("fscanBillNo", (Object)imageInfo.getImageNo());
            JSONObject resultJSON = this.request("erpBillEnablePost", (Map<String, Object>)params);
            log.info("enableArchive responseJSON:" + resultJSON.toJSONString());
            if (ERRORDESCNO_SUCCESS.equals(resultJSON.getString("errcode"))) {
                return "1";
            }
            return resultJSON.toJSONString();
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u4e91\u5355\u636e\u662f\u5426\u53ef\u4ee5\u5f52\u6863\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return "-2";
        }
    }

    @Override
    public void pushImageInfo(ImageInfo imageInfo) {
        try {
            JSONObject requestParams = this.buildPushImageInfoRequestParams(imageInfo);
            this.pushImageInfoToFPY(requestParams);
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u4e91\u5355\u636e\u4fe1\u606f\u63a8\u9001\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + e.getMessage(), (Throwable)e);
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.PUSH);
        }
    }

    private String pushImageInfoToFPY(JSONObject requestParams) {
        try {
            JSONObject resultJSON = this.request("pushImageInfo", (Map<String, Object>)requestParams);
            log.info("pushImageInfo responseJSON:" + resultJSON.toJSONString());
            if (ERRORDESCNO_SUCCESS.equals(resultJSON.getString("errcode"))) {
                return "1";
            }
            return resultJSON.toJSONString();
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u4e91\u5355\u636e\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return "-2";
        }
    }

    private JSONObject buildPushImageInfoRequestParams(ImageInfo imageInfo) {
        DynamicObject orgDynObj = BusinessDataServiceHelper.loadSingle((Object)imageInfo.getOrgId(), (String)"bos_org", (String)"number");
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)imageInfo.getCreator(), (String)"bos_user", (String)"username,name,phone");
        QFilter filter = new QFilter("number", "=", (Object)imageInfo.getBilltype());
        DynamicObject billTypeObj = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{filter});
        String orgName = Optional.ofNullable(orgDynObj).map(obj -> obj.getString("name")).orElseGet(() -> StringUtils.getEmpty());
        String erpUserName = Optional.ofNullable(userObj).map(obj -> obj.getString("username")).orElseGet(() -> StringUtils.getEmpty());
        String billTypeDesc = Optional.ofNullable(billTypeObj).map(obj -> obj.getString("name")).orElseGet(() -> StringUtils.getEmpty());
        JSONObject param = new JSONObject();
        param.put("fscanBillNo", (Object)imageInfo.getImageNo());
        param.put("fbillId", (Object)imageInfo.getBillId());
        param.put("fapplyUserName", (Object)userObj.getString("name"));
        param.put("fapplyUserPhone", (Object)userObj.getString("phone"));
        param.put("fapplyErpUserName", (Object)imageInfo.getCreator());
        param.put("fapplyOrganizationCode", (Object)imageInfo.getOrgId());
        param.put("fapplyOrganizationName", (Object)orgName);
        param.put("fbillTypeCode", (Object)imageInfo.getBilltype());
        param.put("fbillTypeDes", (Object)billTypeDesc);
        return param;
    }

    @Override
    public void pushImageInfoBatch(Map<String, ImageInfo> billImageInfoMap) {
        for (ImageInfo imageInfo : billImageInfoMap.values()) {
            try {
                JSONObject requestParams = this.createPushImageInfoRequestParams(imageInfo);
                this.pushImageInfoBatchToFPY(requestParams);
            }
            catch (Exception e) {
                log.error("\u53d1\u7968\u4e91\u5355\u636e\u4fe1\u606f\u63a8\u9001\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + e.getMessage(), (Throwable)e);
                imageInfo.setBillData(e.getMessage());
                SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.PUSH);
            }
        }
    }

    private void pushImageInfoBatchToFPY(JSONObject requestParams) throws Exception {
        JSONObject resultJSON = this.request("pushImageInfo", (Map<String, Object>)requestParams);
        log.info("pushImageInfoBatch responseJSON:" + resultJSON);
        if (!ERRORDESCNO_SUCCESS.equals(resultJSON.getString("errcode"))) {
            String desc = resultJSON.getString("description");
            log.error("\u5f71\u50cf\u63a8\u9001\u8bf7\u6c42\u5931\u8d25imageNo\uff1a" + requestParams.getString("fscanBillNo") + ", desc\uff1a" + desc);
            throw new KDBizException(ResManager.loadKDString((String)"\u5f71\u50cf\u63a8\u9001\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5931\u8d25", (String)"NoticeImageSysHelper_FPY_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        log.info("\u5f71\u50cf\u63a8\u9001\u8bf7\u6c42\u6210\u529fimageNo\uff1a" + requestParams.getString("fscanBillNo"));
    }

    private JSONObject createPushImageInfoRequestParams(ImageInfo imageInfo) {
        JSONObject param = new JSONObject();
        param.put("fscanBillNo", (Object)imageInfo.getImageNo());
        param.put("fbillId", (Object)imageInfo.getBillId());
        param.put("fapplyUserName", (Object)imageInfo.getCreatorName());
        param.put("fapplyUserPhone", (Object)imageInfo.getCreatorPhone());
        param.put("fapplyErpUserName", (Object)imageInfo.getCreator());
        param.put("fapplyOrganizationCode", (Object)imageInfo.getOrgId());
        param.put("fapplyOrganizationName", (Object)imageInfo.getOrgName());
        param.put("fbillTypeCode", (Object)imageInfo.getBilltype());
        param.put("fbillTypeDes", (Object)imageInfo.getBilltypeName());
        return param;
    }

    private JSONObject request(String method, Map<String, Object> param) {
        Object o = DispatchServiceHelper.invokeBizService((String)"imc", (String)"bds", (String)"ImageReceiveService", (String)method, (Object[])new Object[]{param});
        String json = SerializationUtils.toJsonString((Object)o);
        return JSONObject.parseObject((String)json);
    }
}

