/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.service;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.imageplatform.helper.NoticeImageSysFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CreateImageinfoBatchAsyn
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(CreateImageinfoBatchAsyn.class);
    private static final String MQ_REGION = "bos";
    private static final String MQ_QUEUE = "kd.bos.imageplatform.service.createImageAsyn";

    public void onMessage(Object param, String messageId, boolean b, MessageAcker messageAcker) {
        String paramStr = JSONObject.toJSONString((Object)param);
        log.info("\u6210\u529f\u8fdb\u5165\u5f71\u50cf\u7f16\u7801\u751f\u6210\u6d88\u8d39\u8005\u5b9e\u73b0\u7c7b:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u53c2\u6570: " + paramStr + ", " + messageId);
        if (param == null || StringUtils.isBlank((CharSequence)paramStr)) {
            log.error("\u5f71\u50cf\u7f16\u7801\u751f\u6210\u6d88\u606f\u961f\u5217\u4e2d message \u4e3a\u7a7a\uff08\u6216\u4e3anull\uff09,\u4e0d\u7528\u6d88\u8d39");
            messageAcker.ack(messageId);
            return;
        }
        if (param instanceof Map) {
            try {
                Map<String, ImageInfo> billImageInfoMap = this.getParamMap(paramStr);
                log.info("\u5f02\u6b65\u63a8\u9001\u5f71\u50cf\u7f16\u7801\uff0c\u6d88\u8d39\u5f71\u50cf\u6761\u6570\uff1a" + billImageInfoMap.size());
                this.consumer(billImageInfoMap);
                log.info("\u5f71\u50cf\u7f16\u7801\u751f\u6210\u6210\u529f\u6d88\u8d39:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u53c2\u6570: " + paramStr + ", " + messageId);
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u63a8\u9001\u5f71\u50cf\u7f16\u7801\u6d88\u606f\u6d88\u8d39\u5931\u8d25", (Throwable)e);
                this.insertMqError(param, e);
            }
        }
        messageAcker.ack(messageId);
    }

    private Map<String, ImageInfo> getParamMap(String paramStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)paramStr);
        HashMap<String, ImageInfo> imageInfoMap = new HashMap<String, ImageInfo>(16);
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ImageInfo imageInfo = (ImageInfo)JSONObject.parseObject((String)JSONObject.toJSONString(value), ImageInfo.class);
            imageInfoMap.put(key, imageInfo);
        }
        return imageInfoMap;
    }

    private void consumer(Map<String, ImageInfo> billImageInfoMap) {
        NoticeImageSysFactory.getInstance().pushImageInfoBatch(billImageInfoMap);
    }

    private void insertMqError(Object message, Exception e) {
        DynamicObject mqErrDyObj = BusinessDataServiceHelper.newDynamicObject((String)"task_mq_faile");
        mqErrDyObj.set("mqregion", (Object)MQ_REGION);
        mqErrDyObj.set("mqqueue", (Object)MQ_QUEUE);
        mqErrDyObj.set("mqexceptionmsg", (Object)this.MQ_ERROR_MSG());
        mqErrDyObj.set("mqexceptionstack_tag", (Object)this.getStackTrace(e));
        mqErrDyObj.set("mqexceptionhptime", (Object)new Date());
        mqErrDyObj.set("mqparam_tag", (Object)JSONObject.toJSONString((Object)message));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mqErrDyObj});
    }

    private String getStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder("Exception:");
        if (throwable != null) {
            StackTraceElement[] elements;
            stringBuilder.append(throwable.getMessage()).append('\n');
            for (StackTraceElement e : elements = throwable.getStackTrace()) {
                stringBuilder.append('\t').append(e).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private String MQ_ERROR_MSG() {
        return ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u7801\u751f\u6210\u6d88\u8d39\u5931\u8d25", (String)"CreateImageinfoBatchAsyn_0", (String)"bos-image-formplugin", (Object[])new Object[0]);
    }
}

