/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.service;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import kd.bos.image.util.ImageParamsUtils;
import kd.bos.imageplatform.axis.EASLoginProxyServiceStub;
import kd.bos.imageplatform.service.EASConfig;
import kd.bos.imageplatform.util.HttpClientUtils;
import kd.bos.imageplatform.util.XmlParseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class EasWebServiceClient {
    private static final Log log = LogFactory.getLog(EasWebServiceClient.class);
    public static final String symbol = "EAS";
    private static final String SESSION_ID = "SessionId";
    private static final Integer TIME_OUT = 50000;
    private static final int CONNECTIONTIMEOUT = 5000;
    private static final int READTIMEOUT = 30000;

    public static EasWebServiceClient getInstance() {
        return new EasWebServiceClient();
    }

    public <T> T callMethodForEasService(Object[] params, String namespaceURI, String methodName, String sessionId) throws Exception {
        log.info("\u8bf7\u6c42\u65b9\u6cd5:" + methodName + ";\u8bf7\u6c42\u53c2\u6570params:" + Arrays.toString(params));
        Class<?> clazzService = Class.forName("org.apache.axis.client.Service");
        Class<?> clazz = Class.forName("org.apache.axis.client.Call");
        Object obj = clazz.getConstructor(clazzService).newInstance(clazzService.newInstance());
        Class<?> element = Class.forName("org.apache.axis.message.SOAPHeaderElement");
        Constructor<?> constructor = element.getConstructor(String.class, String.class, Object.class);
        Object soapHeaderElement = constructor.newInstance(ImageParamsUtils.getValue("EASWLOGIN"), SESSION_ID, sessionId);
        Method setOperationName = clazz.getMethod("setOperationName", String.class);
        setOperationName.invoke(obj, methodName);
        Method setTargetEndpointAddress = clazz.getMethod("setTargetEndpointAddress", String.class);
        setTargetEndpointAddress.invoke(obj, namespaceURI);
        Method addHeader = clazz.getMethod("addHeader", element);
        addHeader.invoke(obj, soapHeaderElement);
        Method setMaintainSession = clazz.getMethod("setMaintainSession", Boolean.TYPE);
        setMaintainSession.invoke(obj, Boolean.TRUE);
        Method setTimeout = clazz.getMethod("setTimeout", Integer.class);
        setTimeout.invoke(obj, TIME_OUT);
        Method invoke = clazz.getMethod("invoke", Object[].class);
        Object result = invoke.invoke(obj, new Object[]{params});
        log.info("\u8c03\u7528EAS\u63a5\u53e3" + methodName + "\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        return (T)result;
    }

    public EASLoginProxyServiceStub.WSContext callMethodForEASLogin() throws Exception {
        String json;
        EASConfig eas = EASConfig.getConfig();
        String userName = eas.getUserName();
        String password = eas.getPassword();
        String slnName = eas.getSolution();
        String dcName = eas.getDataCenter();
        String language = eas.getLanguage();
        int dbType = eas.getDbType();
        EASLoginProxyServiceStub.WSContext result = null;
        String url = "http://" + eas.getIP() + ":" + eas.getPort() + "/ormrpc/services/EASLogin?wsdl";
        String rspXml = this.sendHttpsRequestByPost(url, json = "<soapenv:Envelope xmlns:xsi=\"" + ImageParamsUtils.getValue("EASXMLSI") + "\" xmlns:xsd=\"" + ImageParamsUtils.getValue("EASXMLSA") + "\" xmlns:soapenv=\"" + ImageParamsUtils.getValue("EASSCEN") + "/\" xmlns:log=\"" + ImageParamsUtils.getValue("EASWLOGIN") + "\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <log:login soapenv:encodingStyle=\"" + ImageParamsUtils.getValue("EASXEND") + "/\">\n         <userName xsi:type=\"xsd:string\">" + userName + "</userName>\n         <password xsi:type=\"xsd:string\">" + password + "</password>\n         <slnName xsi:type=\"xsd:string\">" + slnName + "</slnName>\n         <dcName xsi:type=\"xsd:string\">" + dcName + "</dcName>\n         <language xsi:type=\"xsd:string\">" + language + "</language>\n         <dbType xsi:type=\"xsd:int\">" + dbType + "</dbType>\n         <authPattern xsi:type=\"xsd:string\">BaseDB</authPattern>\n      </log:login>\n   </soapenv:Body>\n</soapenv:Envelope>");
        if (rspXml != null && !rspXml.isEmpty()) {
            result = XmlParseUtil.getWSContext(rspXml);
        }
        return result;
    }

    public final String sendHttpsRequestByPost(String url, String json) throws Exception {
        String responseContent = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientUtils.createHttpClient(5000, 30000);
            HttpPost httpPost = new HttpPost(url);
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_SOAP_XML);
            httpPost.addHeader("SOAPAction", "");
            httpPost.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001HTTP POST\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u8fde\u63a5\u62a5\u9519" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return responseContent;
    }

    public final String sendHttpsRequestByPost2(String url, String json, String sessionId) throws Exception {
        String responseContent = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientUtils.createHttpClient(5000, 30000);
            HttpPost httpPost = new HttpPost(url);
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_SOAP_XML);
            httpPost.addHeader("SOAPAction", "");
            httpPost.addHeader("Cookie", "JSESSIONID=" + sessionId);
            httpPost.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001HTTP POST\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u8fde\u63a5\u62a5\u9519" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return responseContent;
    }

    public String ImageReady(Object[] body, String url, String sessionId) throws Exception {
        String result = "";
        String xml = "<soapenv:Envelope xmlns:soapenv=\"" + ImageParamsUtils.getValue("EASSCEN") + "/\" xmlns:xsd=\"" + ImageParamsUtils.getValue("EASXMLSA") + "\" xmlns:xsi=\"" + ImageParamsUtils.getValue("EASXMLSI") + "\"><soapenv:Body><imageReady soapenv:encodingStyle=\"" + ImageParamsUtils.getValue("EASXEND") + "/\"><arg0 xsi:type=\"xsd:string\">{&quot;creator&quot;:1158671281185388544,&quot;createtime&quot;:1626681122586,&quot;imagenumber&quot;:&quot;KDAS-PV1-210719-00001413&quot;,&quot;billtype&quot;:&quot;cas_paybill&quot;,&quot;modifytime&quot;:1631499315000,&quot;billid&quot;:&quot;1203606802604883968&quot;,&quot;billnumber&quot;:&quot;PV1-210719-00001413&quot;,&quot;modifier&quot;:13466739,&quot;creatororgid&quot;:&quot;100000&quot;,&quot;imagestate&quot;:&quot;2&quot;,&quot;SynEasImageMap&quot;:&quot;SynEasImageMap&quot;}</arg0></imageReady></soapenv:Body></soapenv:Envelope>";
        String s = this.sendHttpsRequestByPost2(url, xml, sessionId);
        log.info("\u767b\u5f55EAS\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        return result;
    }
}

