/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.service;

import com.alibaba.fastjson.JSONArray;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.imageplatform.common.ImageOperaionEnum;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ImageAsyncDeleteQueue
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(ImageAsyncDeleteQueue.class);
    private static final int RPTIMES = 5;
    private static final String MQPARAM_TAG = "mqparam_tag";
    private static final String TASK_MQ_FAILE = "task_mq_faile";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        log.error("\u5f02\u6b65\u5220\u9664\u5f71\u50cf\uff0cmq\u4f20\u5165\u53c2\u6570: " + message);
        if (message == null || StringUtils.isEmpty((CharSequence)message.toString())) {
            log.error("message \u4e3anull,\u5220\u9664\u5f02\u5e38");
            messageAcker.ack(messageId);
            return;
        }
        List mqImageMap = null;
        mqImageMap = JSONArray.parseArray((String)((String)message), ImageInfo.class);
        log.info("\u5f02\u6b65\u5220\u9664\u961f\u5217\u4fe1\u606f" + mqImageMap);
        boolean tag = true;
        if (mqImageMap != null) {
            try (TXHandle h = TX.requiresNew();){
                for (ImageInfo info : mqImageMap) {
                    if (info == null) continue;
                    try {
                        String result = ImageServiceHelper.deleteImage((String)info.getImageNo(), (String)info.getOperation(), null);
                        if ("success".equals(result)) continue;
                        tag = false;
                        SSCImageUtils.recordErrorInfo(info, ImageOperaionEnum.DELETE);
                    }
                    catch (Exception e1) {
                        this.saveErrorMQ(message, e1, info.getImageNo());
                        SSCImageUtils.recordErrorInfo(info, ImageOperaionEnum.DELETE);
                        log.error(e1.getMessage(), (Throwable)e1);
                        h.markRollback();
                    }
                }
            }
            if (tag) {
                this.deleteErrorMQ(message);
            }
        }
        messageAcker.ack(messageId);
    }

    public void deleteErrorMQ(Object arg0) {
        QFilter mqParamFilter = new QFilter(MQPARAM_TAG, "=", (Object)SerializationUtils.toJsonString((Object)arg0));
        DeleteServiceHelper.delete((String)TASK_MQ_FAILE, (QFilter[])new QFilter[]{mqParamFilter});
    }

    public void saveErrorMQ(Object arg0, Exception e, String imagenumber) {
        QFilter mqParamFilter = new QFilter(MQPARAM_TAG, "=", (Object)SerializationUtils.toJsonString((Object)arg0));
        if (!QueryServiceHelper.exists((String)TASK_MQ_FAILE, (QFilter[])new QFilter[]{mqParamFilter})) {
            DynamicObject mqErrDyObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_MQ_FAILE);
            mqErrDyObj.set("mqregion", (Object)"bos");
            mqErrDyObj.set("mqqueue", (Object)"kd.bos.imageplatform.service.asynDeleteImage");
            mqErrDyObj.set("mqexceptionmsg", (Object)this.getExcetionMsg(e, imagenumber));
            mqErrDyObj.set("mqexceptionstack_tag", (Object)this.getStackTrace(e));
            mqErrDyObj.set("mqexceptionhptime", (Object)new Date());
            mqErrDyObj.set(MQPARAM_TAG, (Object)SerializationUtils.toJsonString((Object)arg0));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mqErrDyObj});
        }
    }

    public String getStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder("Exception:");
        if (throwable != null) {
            StackTraceElement[] elements;
            stringBuilder.append(throwable.getMessage()).append('\n');
            for (StackTraceElement e : elements = throwable.getStackTrace()) {
                stringBuilder.append('\t').append(e).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public String getExcetionMsg(Throwable throwable, String imagenumber) {
        String exceptionMsg = throwable.getMessage();
        return String.format(ResManager.loadKDString((String)"%1$s\u5f71\u50cf\u7f16\u7801\uff1a%2$s", (String)"ImageAsyncDeleteQueue_0", (String)"bos-image-formplugin", (Object[])new Object[0]), exceptionMsg, imagenumber);
    }
}

