/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.service;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.imageplatform.axis.EASLoginProxyServiceStub;
import kd.bos.imageplatform.service.EASConfig;
import kd.bos.imageplatform.service.EasWebServiceClient;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ImageSynchronizationQueue
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(ImageSynchronizationQueue.class);
    private static final int RPTIMES = 5;
    private static final String MQPARAM_TAG = "mqparam_tag";
    private static final String TASK_MQ_FAILE = "task_mq_faile";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        log.error("\u5f71\u50cf\u540c\u6b65eas\uff0cmq\u4f20\u5165\u53c2\u6570: " + message);
        if (message == null || StringUtils.isEmpty((CharSequence)message.toString())) {
            log.error("message \u4e3anull,\u4e0d\u7528\u8bc6\u522b");
            messageAcker.ack(messageId);
            return;
        }
        EasWebServiceClient call = EasWebServiceClient.getInstance();
        EASLoginProxyServiceStub.WSContext svcCtx = null;
        try {
            svcCtx = call.callMethodForEASLogin();
            if (svcCtx == null) {
                throw new KDException(ResManager.loadKDString((String)"\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25\uff01", (String)"ImageSynchronizationQueue_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
            }
            String sessionId = svcCtx.getSessionId();
            if (sessionId == null || sessionId.isEmpty()) {
                throw new KDException(ResManager.loadKDString((String)"\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25\uff01", (String)"ImageSynchronizationQueue_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
            }
            Map mqImageMap = (Map)message;
            String massage = (String)mqImageMap.get("massage");
            String imagenumber = (String)mqImageMap.get("imagenumber");
            log.info("massage:" + massage + ",imagenumber:" + imagenumber);
            EASConfig eas = EASConfig.getConfig();
            for (int i = 0; i < 5; ++i) {
                try {
                    log.error("loginEAS -result : " + eas.getIP() + ":" + eas.getPort());
                    Object[] params = new Object[]{massage};
                    String methodName = "imageReady";
                    String namespaceURI = "http://" + eas.getIP() + ":" + eas.getPort() + "/ormrpc/services/WSSSCImageBaseServiceFacade?wsdl";
                    String result = (String)call.callMethodForEasService(params, namespaceURI, methodName, sessionId);
                    log.error("postEAS -result : " + result);
                    messageAcker.ack(messageId);
                    this.deleteErrorMQ(message);
                    return;
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65EAS\u901a\u77e5\u5931\u8d25 : " + e.getMessage() + "\u62a5\u9519\u5806\u6808:", (Throwable)e);
                    if (i < 4) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e1) {
                            log.error("\u7ebf\u7a0b\u8bf7\u6c42\u5f02\u5e38", (Throwable)e1);
                        }
                        continue;
                    }
                    this.saveErrorMQ(message, e, imagenumber);
                    continue;
                }
            }
        }
        catch (Exception e) {
            log.info("\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25:" + e);
        }
        messageAcker.ack(messageId);
        log.error("\u5df2\u8bf7\u6c425\u6b21\uff0c\u8bf7\u6c42\u5b8c\u6bd5");
    }

    public void deleteErrorMQ(Object arg0) {
        QFilter mqParamFilter = new QFilter(MQPARAM_TAG, "=", (Object)SerializationUtils.toJsonString((Object)arg0));
        DeleteServiceHelper.delete((String)TASK_MQ_FAILE, (QFilter[])new QFilter[]{mqParamFilter});
    }

    public void saveErrorMQ(Object arg0, Exception e, String imagenumber) {
        QFilter mqParamFilter = new QFilter(MQPARAM_TAG, "=", (Object)SerializationUtils.toJsonString((Object)arg0));
        if (!QueryServiceHelper.exists((String)TASK_MQ_FAILE, (QFilter[])new QFilter[]{mqParamFilter})) {
            DynamicObject mqErrDyObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_MQ_FAILE);
            mqErrDyObj.set("mqregion", (Object)"bos");
            mqErrDyObj.set("mqqueue", (Object)"kd.bos.imageplatform.service.image");
            mqErrDyObj.set("mqexceptionmsg", (Object)this.getExcetionMsg(e, imagenumber));
            mqErrDyObj.set("mqexceptionstack_tag", (Object)this.getStackTrace(e));
            mqErrDyObj.set("mqexceptionhptime", (Object)new Date());
            mqErrDyObj.set(MQPARAM_TAG, (Object)SerializationUtils.toJsonString((Object)arg0));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mqErrDyObj});
        }
    }

    public String getStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder("Exception:");
        if (throwable != null) {
            StackTraceElement[] elements;
            stringBuilder.append(throwable.getMessage()).append('\n');
            for (StackTraceElement e : elements = throwable.getStackTrace()) {
                stringBuilder.append('\t').append(e).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public String getExcetionMsg(Throwable throwable, String imagenumber) {
        String exceptionMsg = throwable.getMessage();
        String result = String.format(ResManager.loadKDString((String)"%1$s\u5f71\u50cf\u7f16\u7801\uff1a%2$s", (String)"ImageSynchronizationQueue_1", (String)"bos-image-formplugin", (Object[])new Object[0]), exceptionMsg, imagenumber);
        return result;
    }
}

