/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.imageplatform.pojo.TimeIgnoretDate;
import kd.bos.imageplatform.pojo.WorkTime;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class WorkDateUtil {
    private static final String SSC_TASK_FORMPLUGIN = "ssc-task-formplugin";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Log log = LogFactory.getLog(WorkDateUtil.class);
    private List<String> morning_workDateList = null;
    private List<String> afternoon_workDateList = null;
    private List<String> workDateList = null;
    private WorkTime workTimeInfo;

    public WorkTime getWorkTimeInfo() {
        return this.workTimeInfo;
    }

    public static synchronized WorkDateUtil getInstance(long shareCenterId, Date startDate, Date endDate) {
        return new WorkDateUtil(shareCenterId, startDate, endDate);
    }

    public WorkDateUtil(long shareCenterId, Date startDate, Date endDate) {
        this.iniCanledar(shareCenterId, startDate, endDate);
    }

    private void iniCanledar(long centerId, Date startDate, Date endDate) {
        BaseDataServiceHelper dbService = new BaseDataServiceHelper();
        DynamicObject calendar = dbService.getWorkCalendar(Long.valueOf(centerId), startDate, endDate);
        this.workTimeInfo = new WorkTime();
        if (calendar != null) {
            this.workTimeInfo.setId(calendar.getLong("id"));
            this.workTimeInfo.setHourofbegintimeam(calendar.getInt("hourofbegintimeam"));
            this.workTimeInfo.setMinofbegintimeam(calendar.getInt("minofbegintimeam"));
            this.workTimeInfo.setHourofendtimeam(calendar.getInt("hourofendtimeam"));
            this.workTimeInfo.setMinofendtimeam(calendar.getInt("minofendtimeam"));
            this.workTimeInfo.setHourofbegintimepm(calendar.getInt("hourofbegintimepm"));
            this.workTimeInfo.setMinofbegintimepm(calendar.getInt("minofbegintimepm"));
            this.workTimeInfo.setHourofendtimepm(calendar.getInt("hourofendtimepm"));
            this.workTimeInfo.setMinofendtimepm(calendar.getInt("minofendtimepm"));
            DynamicObjectCollection calendarEntry = calendar.getDynamicObjectCollection("dateentry");
            int days = calendarEntry.size();
            this.morning_workDateList = new ArrayList<String>(days);
            this.afternoon_workDateList = new ArrayList<String>(days);
            this.workDateList = new ArrayList<String>(days);
            for (DynamicObject obj : calendarEntry) {
                String datetype = obj.getString("datetype");
                String date_str = this.dateFormat.format(obj.getDate("workdate"));
                if ("1".equals(datetype)) {
                    this.morning_workDateList.add(date_str);
                    this.afternoon_workDateList.add(date_str);
                    this.workDateList.add(date_str);
                    continue;
                }
                if (!"2".equals(datetype)) continue;
                this.morning_workDateList.add(date_str);
                this.workDateList.add(date_str);
            }
            this.morning_workDateList = this.morning_workDateList.stream().sorted(String::compareTo).collect(Collectors.toList());
            this.afternoon_workDateList = this.afternoon_workDateList.stream().sorted(String::compareTo).collect(Collectors.toList());
            this.workDateList = this.workDateList.stream().sorted(String::compareTo).collect(Collectors.toList());
            String logStr = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5171\u4eab\u4e2d\u5fc3\uff1a%1$s\u7684\u5de5\u4f5c\u65e5\u5386\uff08%2$s, %3$s\uff09\uff0c\u4e0a\u5348\u5de5\u4f5c\u6570\u91cf\uff1a%4$s\uff0c\u4e0b\u5348\u5de5\u4f5c\u6570\u91cf\uff1a%5$s\uff0c\u5de5\u4f5c\u65e5\u5386\u5206\u5f55dateentry\uff1a%6$s", (String)"WorkDateUtil_0", (String)"bos-image-formplugin", (Object[])new Object[0]), centerId, startDate, endDate, this.morning_workDateList.size(), this.afternoon_workDateList.size(), days);
            this.log.info(logStr);
        } else {
            this.workTimeInfo.setHourofbegintimeam(9);
            this.workTimeInfo.setMinofbegintimeam(0);
            this.workTimeInfo.setHourofendtimeam(12);
            this.workTimeInfo.setMinofendtimeam(0);
            this.workTimeInfo.setHourofbegintimepm(12);
            this.workTimeInfo.setMinofbegintimepm(0);
            this.workTimeInfo.setHourofendtimepm(17);
            this.workTimeInfo.setMinofendtimepm(0);
            if (this.morning_workDateList == null) {
                int days = 0;
                Date start_date = null;
                Date end_date = null;
                try {
                    start_date = this.dateFormat.parse(this.dateFormat.format(startDate));
                    end_date = this.dateFormat.parse(this.dateFormat.format(endDate));
                    days = (int)((end_date.getTime() - start_date.getTime()) / 1000L / 3600L / 24L);
                }
                catch (ParseException e) {
                    this.log.error("format date error!!" + e.getMessage(), (Throwable)e);
                    throw new KDException("format date error!!" + e.getMessage());
                }
                this.morning_workDateList = new ArrayList<String>(days);
                this.afternoon_workDateList = new ArrayList<String>(days);
                Date temp = start_date;
                String date_str = this.dateFormat.format(temp);
                for (int i = 0; i <= days; ++i) {
                    if (this.isNotWeekend(temp)) {
                        this.morning_workDateList.add(date_str);
                        this.afternoon_workDateList.add(date_str);
                        this.workDateList.add(date_str);
                    }
                    temp = new Date(temp.getTime() + 86400000L);
                    date_str = this.dateFormat.format(temp);
                }
                this.morning_workDateList = this.morning_workDateList.stream().sorted(String::compareTo).collect(Collectors.toList());
                this.afternoon_workDateList = this.afternoon_workDateList.stream().sorted(String::compareTo).collect(Collectors.toList());
                this.workDateList = this.workDateList.stream().sorted(String::compareTo).collect(Collectors.toList());
            }
        }
    }

    public long calWorkTime(Date receiveTime, Date now, int type) {
        if (receiveTime == null || now == null) {
            return 0L;
        }
        if (receiveTime.after(now)) {
            return 0L;
        }
        BigDecimal b1000 = new BigDecimal(1000);
        BigDecimal b60 = new BigDecimal(60);
        long workTimes = this.calWorkTimeBetweenDay(receiveTime, now);
        BigDecimal temp = null;
        switch (type) {
            case 0: {
                temp = new BigDecimal(workTimes).setScale(2);
                break;
            }
            case 1: {
                temp = new BigDecimal(workTimes).divide(b1000, 2, RoundingMode.HALF_UP);
                break;
            }
            case 2: {
                temp = new BigDecimal(workTimes).divide(b1000.multiply(b60), 2, RoundingMode.HALF_UP);
                break;
            }
            case 3: {
                temp = new BigDecimal(workTimes).divide(b1000.multiply(b60).multiply(b60), 2, RoundingMode.HALF_UP);
                break;
            }
        }
        if (temp != null) {
            return temp.longValue();
        }
        return 0L;
    }

    private long calWorkTimeBetweenDay(Date receiveTime, Date now) {
        long result = 0L;
        String d1 = this.dateFormat.format(receiveTime);
        String d2 = this.dateFormat.format(now);
        long oneDayMorningWorkTime = this.workTimeInfo.getMorningWorkTimeMilSec();
        if (d1.equals(d2)) {
            long beginWorkTime = this.calWorkedTimeInDay(receiveTime);
            long endWorkTime = this.calWorkedTimeInDay(now);
            return endWorkTime - beginWorkTime;
        }
        int morningDays = this.calWorkDayBetweenDay(receiveTime, now, this.morning_workDateList);
        int afternoonDays = this.calWorkDayBetweenDay(receiveTime, now, this.afternoon_workDateList);
        long morningWorkTime = (long)morningDays * oneDayMorningWorkTime;
        long afternoonWorkTime = (long)afternoonDays * (this.workTimeInfo.getOneDayWorkTimeMilSec() - oneDayMorningWorkTime);
        result = morningWorkTime + afternoonWorkTime;
        long beginDaySurplusWorkTime = this.calSurplusTimeInDay(receiveTime);
        long endDayWorkTime = this.calWorkedTimeInDay(now);
        result = result + endDayWorkTime + beginDaySurplusWorkTime;
        return result;
    }

    public int calWorkDayBetweenDay(Date startDate, Date endDate) {
        return this.calWorkDayBetweenDay(startDate, endDate, this.workDateList);
    }

    private int calWorkDayBetweenDay(Date startDate, Date endDate, List<String> dateList) {
        String end;
        String start = this.dateFormat.format(startDate);
        if (start.compareTo(end = this.dateFormat.format(endDate)) >= 0) {
            return 0;
        }
        Object startIndex = this.getCalIndex(start, dateList);
        Object endIndex = this.getCalIndex(end, dateList);
        int calStart = startIndex instanceof String ? Integer.parseInt((String)startIndex) : (Integer)startIndex;
        int calEnd = endIndex instanceof String ? Integer.parseInt((String)endIndex) : (Integer)endIndex;
        int expireDay = calEnd - calStart - 1;
        boolean specialDay = startIndex instanceof String;
        if (specialDay) {
            ++expireDay;
        }
        return Math.max(expireDay, 0);
    }

    private Object getCalIndex(String date, List<String> dateList) {
        if (dateList.isEmpty()) {
            return 0;
        }
        int index = dateList.indexOf(date);
        if (index == -1) {
            String start = dateList.get(0);
            String end = dateList.get(dateList.size() - 1);
            if (start.compareTo(date) > 0) {
                return -1;
            }
            if (date.compareTo(end) > 0) {
                return dateList.size();
            }
            return this.binarySearch(date, dateList) + "";
        }
        return index;
    }

    private int binarySearch(String target, List<String> workCalendarList) {
        int minIndex = 0;
        int maxIndex = workCalendarList.size() - 1;
        while (minIndex != maxIndex - 1) {
            int middleIndex = (maxIndex + minIndex) / 2;
            String middleValue = workCalendarList.get(middleIndex);
            if (middleValue.compareTo(target) > 0) {
                maxIndex = middleIndex;
                continue;
            }
            minIndex = middleIndex;
        }
        return maxIndex;
    }

    public Date calWorkEndDate(Date startTime, long durationTime) {
        if (durationTime == 0L) {
            return startTime;
        }
        Date wordEndDate = null;
        Date shortStartTime = this.formatShortStartDate(startTime);
        Map<String, Long> daysMap = this.getValidDaysMap(durationTime);
        long days = daysMap.get("days");
        long extraTime = daysMap.get("extratime");
        Date onDayWorkEndDate = this.getOnDayWorkEndDate(shortStartTime, true);
        Date invalidEndDate = this.getValidDate(onDayWorkEndDate, days);
        long makeUpDays = this.calNeedMakeUpdays(shortStartTime, days);
        if (makeUpDays == 0L) {
            wordEndDate = invalidEndDate;
        }
        while (makeUpDays > 0L) {
            wordEndDate = this.getValidDate(invalidEndDate, makeUpDays);
            shortStartTime = invalidEndDate;
            makeUpDays = this.calNeedMakeUpdays(shortStartTime, makeUpDays);
            invalidEndDate = wordEndDate;
        }
        long hadWorkedTime = this.workTimeInfo.getOneDayWorkTimeMilSec() - this.calWorkedTimeInDay(startTime);
        long needSubtractTime = hadWorkedTime + extraTime;
        Date planFinishTime = this.calLeftWorkedTimeInDay(wordEndDate, needSubtractTime);
        return planFinishTime;
    }

    private Date calLeftWorkedTimeInDay(Date date, long needSubtractTime) {
        long leftWorkTime = 0L;
        leftWorkTime = needSubtractTime <= this.workTimeInfo.getOneDayWorkTimeMilSec() ? this.workTimeInfo.getOneDayWorkTimeMilSec() - needSubtractTime : needSubtractTime;
        long morningWorkTime = this.workTimeInfo.getMorningWorkTimeMilSec();
        BigDecimal bdLeftWorkTime = new BigDecimal(leftWorkTime);
        BigDecimal b1000 = new BigDecimal(1000);
        BigDecimal b60 = new BigDecimal(60);
        if (leftWorkTime <= morningWorkTime) {
            BigDecimal bdMinutes = bdLeftWorkTime.divide(b1000.multiply(b60), 2, RoundingMode.HALF_UP);
            BigDecimal bdHours = bdLeftWorkTime.divide(b1000.multiply(b60).multiply(b60), 2, RoundingMode.HALF_UP);
            int hours = bdHours.intValue();
            BigDecimal bdValidMinutes = bdMinutes.subtract(new BigDecimal(hours).multiply(b60));
            int minutes = bdValidMinutes.intValue();
            Date endWorkTime = this.initOnyDayWorkTime(date, this.workTimeInfo.getHourofbegintimeam() + hours, this.workTimeInfo.getMinofbegintimeam() + minutes);
            return endWorkTime;
        }
        if (leftWorkTime > morningWorkTime && leftWorkTime <= this.workTimeInfo.getOneDayWorkTimeMilSec()) {
            bdLeftWorkTime = bdLeftWorkTime.subtract(new BigDecimal(morningWorkTime));
            BigDecimal bdMinutes = bdLeftWorkTime.divide(b1000.multiply(b60), 2, RoundingMode.HALF_UP);
            BigDecimal bdHours = bdLeftWorkTime.divide(b1000.multiply(b60).multiply(b60), 2, RoundingMode.HALF_UP);
            int hours = bdHours.intValue();
            BigDecimal bdValidMinutes = bdMinutes.subtract(new BigDecimal(hours).multiply(b60));
            int minutes = bdValidMinutes.intValue();
            Date endWorkTime = this.initOnyDayWorkTime(date, this.workTimeInfo.getHourofbegintimepm() + hours, this.workTimeInfo.getMinofbegintimepm() + minutes);
            return endWorkTime;
        }
        Date preDate = this.getValidDate(date, -1L);
        return this.calLeftWorkedTimeInDay(preDate, needSubtractTime -= this.workTimeInfo.getOneDayWorkTimeMilSec());
    }

    private Date initOnyDayWorkTime(Date date, int hour, int minute) {
        Date shortStartTime = this.formatShortStartDate(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(shortStartTime);
        cal.add(10, hour);
        cal.add(12, minute);
        Date oneDayWorkStart = cal.getTime();
        return oneDayWorkStart;
    }

    private Date formatShortStartDate(Date startTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String shortStartTimeStr = format.format(startTime);
        try {
            Date shortStartTime = format.parse(shortStartTimeStr);
            return shortStartTime;
        }
        catch (ParseException e) {
            this.log.error("WorkDateUtil.formatShortStartDate\u89e3\u6790\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Date getOnDayWorkEndDate(Date startTime, boolean isShort) {
        if (!isShort) {
            startTime = this.formatShortStartDate(startTime);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        int hourofendtimepm = this.workTimeInfo.getHourofendtimepm();
        int minofendtimepm = this.workTimeInfo.getMinofendtimepm();
        cal.add(10, hourofendtimepm);
        cal.add(12, minofendtimepm);
        return cal.getTime();
    }

    private Map<String, Long> getValidDaysMap(long durationTime) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        BigDecimal oneDayTime = new BigDecimal(this.workTimeInfo.getOneDayWorkTimeMilSec());
        BigDecimal days = BigDecimal.valueOf(durationTime).divide(oneDayTime, RoundingMode.UP);
        BigDecimal daysTime = days.multiply(new BigDecimal(this.workTimeInfo.getOneDayWorkTimeMilSec()));
        BigDecimal extraTime = daysTime.subtract(BigDecimal.valueOf(durationTime));
        map.put("days", days.longValue());
        map.put("extratime", extraTime.longValue());
        return map;
    }

    public long calDaysBetweenDates(Date startTime, Date endTime) {
        long days = 0L;
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        long startTimeLong = cal.getTimeInMillis();
        cal.setTime(endTime);
        long endTimeLong = cal.getTimeInMillis();
        long spanTime = endTimeLong - startTimeLong;
        BigDecimal b1000 = new BigDecimal(1000);
        BigDecimal b60 = new BigDecimal(60);
        BigDecimal b24 = new BigDecimal(24);
        BigDecimal daysBg = new BigDecimal(spanTime).divide(b1000.multiply(b60).multiply(b60).multiply(b24), 2, RoundingMode.HALF_UP);
        days = daysBg.longValue();
        return days;
    }

    private long calNeedMakeUpdays(Date startTime, long days) {
        long makeUpDays = 0L;
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        int i = 0;
        while ((long)i < days) {
            cal.add(6, 1);
            Date curDate = cal.getTime();
            if (this.isNotWorkDay(curDate)) {
                ++makeUpDays;
            }
            ++i;
        }
        return makeUpDays;
    }

    private Date getValidDate(Date date, long makeUpdays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, (int)makeUpdays);
        return cal.getTime();
    }

    public boolean isNotWeekend(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) != 1 && cal.get(7) != 7;
    }

    private boolean isNotWorkDay(Date date) {
        String date_str = this.dateFormat.format(date);
        return !this.morning_workDateList.contains(date_str) && !this.afternoon_workDateList.contains(date_str);
    }

    private boolean isHalfDay_AfternoonRest(Date date) {
        String date_str = this.dateFormat.format(date);
        return this.morning_workDateList.contains(date_str) && !this.afternoon_workDateList.contains(date_str);
    }

    private long calWorkedTimeInDay(Date date) {
        long workTime = 0L;
        String date_str = this.dateFormat.format(date);
        TimeIgnoretDate dateTime = new TimeIgnoretDate(date);
        if (this.isNotWorkDay(date)) {
            return 0L;
        }
        workTime = this.isHalfDay_AfternoonRest(date) ? (dateTime.before(this.workTimeInfo.getStartTimestampAM()) ? 0L : (dateTime.before(this.workTimeInfo.getEndTimestampAM()) ? (long)dateTime.compareTo(this.workTimeInfo.getEndTimestampAM()) : this.workTimeInfo.getMorningWorkTimeMilSec())) : (dateTime.before(this.workTimeInfo.getStartTimestampAM()) ? 0L : (dateTime.before(this.workTimeInfo.getEndTimestampAM()) ? (long)dateTime.compareTo(this.workTimeInfo.getStartTimestampAM()) : (dateTime.before(this.workTimeInfo.getStartTimestampPM()) ? this.workTimeInfo.getMorningWorkTimeMilSec() : (dateTime.before(this.workTimeInfo.getEndTimestampPM()) ? (long)dateTime.compareTo(this.workTimeInfo.getStartTimestampPM()) + this.workTimeInfo.getMorningWorkTimeMilSec() : this.workTimeInfo.getOneDayWorkTimeMilSec()))));
        return workTime;
    }

    private long calSurplusTimeInDay(Date date) {
        long surplusTime = 0L;
        TimeIgnoretDate dateTime = new TimeIgnoretDate(date);
        if (this.isNotWorkDay(date)) {
            return 0L;
        }
        if (this.isHalfDay_AfternoonRest(date)) {
            if (dateTime.before(this.workTimeInfo.getStartTimestampAM())) {
                surplusTime = this.workTimeInfo.getMorningWorkTimeMilSec();
            } else if (dateTime.before(this.workTimeInfo.getEndTimestampAM())) {
                surplusTime = this.workTimeInfo.getEndTimestampAM().compareTo(dateTime);
            }
        } else if (dateTime.before(this.workTimeInfo.getStartTimestampAM())) {
            surplusTime = this.workTimeInfo.getOneDayWorkTimeMilSec();
        } else if (dateTime.before(this.workTimeInfo.getEndTimestampAM())) {
            surplusTime = (long)this.workTimeInfo.getEndTimestampAM().compareTo(dateTime) + this.workTimeInfo.getOneDayWorkTimeMilSec() - this.workTimeInfo.getMorningWorkTimeMilSec();
        } else if (dateTime.before(this.workTimeInfo.getStartTimestampPM())) {
            surplusTime = this.workTimeInfo.getOneDayWorkTimeMilSec() - this.workTimeInfo.getMorningWorkTimeMilSec();
        } else if (dateTime.before(this.workTimeInfo.getEndTimestampPM())) {
            surplusTime = this.workTimeInfo.getEndTimestampPM().compareTo(dateTime);
        }
        return surplusTime;
    }

    public float getIndexFromList_morning(String date) {
        float result;
        block7: {
            result = -1.0f;
            int index = this.morning_workDateList.indexOf(date);
            if (index == -1) {
                try {
                    Calendar now = this.strToCalendar(date);
                    Calendar startDate = this.strToCalendar(this.morning_workDateList.get(0));
                    Calendar endDate = this.strToCalendar(this.morning_workDateList.get(this.morning_workDateList.size() - 1));
                    if (now.before(startDate)) {
                        result = -0.5f;
                        break block7;
                    }
                    if (now.after(endDate)) {
                        result = (float)this.morning_workDateList.size() - 0.5f;
                        break block7;
                    }
                    now.add(5, 1);
                    String temp = this.dateFormat.format(now.getTime());
                    index = this.morning_workDateList.indexOf(temp);
                    while (index == -1) {
                        now.add(5, 1);
                        temp = this.dateFormat.format(now.getTime());
                        index = this.morning_workDateList.indexOf(temp);
                        if (!now.after(endDate)) continue;
                        this.log.info("\u5bfb\u627e\u65e5\u671f\u4e0b\u6807\u5931\u8d25\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + now.getTime() + ",endDate:" + endDate.getTime());
                        return -1.0f;
                    }
                    result = (float)index - 0.5f;
                }
                catch (Exception e) {
                    this.log.error("WorkDateUtil.getIndexFromList_morning\u89e3\u6790\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                    result = -1.0f;
                }
            } else {
                result = index;
            }
        }
        return result;
    }

    public float getIndexFromList_afternoon(String date) {
        float result;
        block7: {
            result = -1.0f;
            int index = this.afternoon_workDateList.indexOf(date);
            if (index == -1) {
                try {
                    Calendar now = this.strToCalendar(date);
                    Calendar startDate = this.strToCalendar(this.afternoon_workDateList.get(0));
                    Calendar endDate = this.strToCalendar(this.afternoon_workDateList.get(this.afternoon_workDateList.size() - 1));
                    if (now.before(startDate)) {
                        result = -0.5f;
                        break block7;
                    }
                    if (now.after(endDate)) {
                        result = (float)this.afternoon_workDateList.size() - 0.5f;
                        break block7;
                    }
                    now.add(5, 1);
                    String temp = this.dateFormat.format(now.getTime());
                    index = this.afternoon_workDateList.indexOf(temp);
                    while (index == -1) {
                        now.add(5, 1);
                        temp = this.dateFormat.format(now.getTime());
                        index = this.afternoon_workDateList.indexOf(temp);
                        if (!now.after(endDate)) continue;
                        this.log.info("\u5bfb\u627e\u65e5\u671f\u4e0b\u6807\u5931\u8d25\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + now.getTime() + ",endDate:" + endDate.getTime());
                        return -1.0f;
                    }
                    result = (float)index - 0.5f;
                }
                catch (Exception e) {
                    this.log.error("WorkDateUtil.getIndexFromList_afternoon\u89e3\u6790\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                    result = -1.0f;
                }
            } else {
                result = index;
            }
        }
        return result;
    }

    public Date strToDate(String date) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(date.substring(0, 4)));
        cal.set(2, Integer.parseInt(date.substring(5, 7)) - 1);
        cal.set(5, Integer.parseInt(date.substring(8)));
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public Calendar strToCalendar(String date) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(date.substring(0, 4)));
        cal.set(2, Integer.parseInt(date.substring(5, 7)) - 1);
        cal.set(5, Integer.parseInt(date.substring(8)));
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal;
    }
}

