/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.invoice.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.invoice.util.InvoiceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;

public class InvoiceService {
    private static final String BILLID = "billid";
    private static final String INVOICEDATE = "invoicedate";
    private static final String IMAGENUMBER = "imagenumber";
    private static final String IMAGE_PAGE = "imagepage";
    private static final String INVOICE_CODE = "invoicecode";
    private static final String INVOICE_NUMBER = "invoicenumber";
    private static final String INVOICE_TYPE = "invoicetype";
    private static final String COMPANY_SALE = "companysale";
    private static final String TAX_NUMBER_SALE = "taxnumbersale";
    private static final String CONTACT_SALE = "contactsale";
    private static final String BANK_INFORMATIONSALE = "bankinformationsale";
    private static final String COMPANY_BUY = "companybuy";
    private static final String TAXNUMBER_BUY = "taxnumberbuy";
    private static final String CONTACTBUY = "contactbuy";
    private static final String BANK_INFORMATIONBUY = "bankinformationbuy";
    private static final String AMOUNT = "amount";
    private static final String TAX = "tax";
    private static final String AMOUNTTAX = "amounttax";
    private static final String TRANSFEROUT = "transferout";
    private static final String DEDUCTIBLE = "deductible";
    private static final String AUTHENTICATE_DATE = "authenticatedate";
    private static final String DUEDATE = "duedate";
    private static final String AUTHENTICATE_STATUS = "authenticatestatus";
    private static final String AUTHENTICATE_WAY = "authenticateway";
    private static final String AUTHENTICATORID = "authenticatorid";
    private static final String AUTHWORD = "password";
    private static final String ISCREDITNOTE = "iscreditnote";
    private static final String HASSTAMP = "hasstamp";
    private static final String IS_TRUE = "istrue";
    private static final String ENTRY = "entryentity";
    private static final String PRODUCT_NAME = "productname";
    private static final String TAX_EXCLUDED = "taxexcluded";
    private static final String TAX_PRICE = "taxprice";
    private static final String QUANTITY = "quantity";
    private static final String MONEY = "money";
    private static final String TAXAMT = "taxamt";
    private static final String TAX_TOTAL = "taxtotal";
    private static final String TAX_RATE = "taxrate";
    private static final String SPECS = "specs";
    private static final String MEASUREUNITID = "measureunitid";
    private static final String MATERIALID = "materialid";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String url = null;
    private static final Log logger = LogFactory.getLog(InvoiceService.class);
    private static ORM orm = ORM.create();

    public void recognitionAndSaveInvoice(String imageUrl, String billId, String imageNumber) throws IOException, ParseException, Exception {
        this.changeRecStatus(billId, imageNumber, "recognizing");
        logger.info("\u8c03\u7528\u7814\u7a76\u9662\u8bc6\u522b\u63a5\u53e3,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
        String result = this.getImageResult(imageUrl);
        logger.info("\u8c03\u7528\u7814\u7a76\u9662\u8bc6\u522b\u63a5\u53e3\u5b8c\u6bd5,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
        if (result.equals("")) {
            logger.info("\u8fde\u63a5\u53d1\u7968\u8bc6\u522b\u63a5\u53e3\u8d85\u65f6,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
            this.changeRecStatus(billId, imageNumber, "overtime");
            return;
        }
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>();
        this.parseJson(billId, imageNumber, result, invoiceList);
        logger.info("\u8f6c\u6362json\u5b8c\u6bd5,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
        if (invoiceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
        }
        this.changeRecStatus(billId, imageNumber, "recognized");
        this.deleteRegData(billId, imageNumber);
    }

    private void deleteRegData(String billId, String imageNumber) {
        QFilter fbillId = new QFilter(BILLID, "=", (Object)billId);
        QFilter fimageNumber = new QFilter(IMAGENUMBER, "=", (Object)imageNumber);
        QFilter freced = new QFilter("state", "=", (Object)"recognized");
        QFilter[] filter = new QFilter[]{fbillId, fimageNumber, freced};
        DeleteServiceHelper.delete((String)"task_imagequeue", (QFilter[])filter);
    }

    private void changeRecStatus(String billId, String imageNumber, String status) {
        QFilter fbillId = new QFilter(BILLID, "=", (Object)billId);
        QFilter fimageNumber = new QFilter(IMAGENUMBER, "=", (Object)imageNumber);
        QFilter[] filters = new QFilter[]{fbillId, fimageNumber};
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"task_imagequeue", (String)"id,state", (QFilter[])filters);
        if (dynObjs != null && dynObjs.length > 0) {
            for (DynamicObject dynObj : dynObjs) {
                dynObj.set("state", (Object)status);
            }
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        }
    }

    public void parseJson(String billId, String imageNumber, String result, List<DynamicObject> invoiceList) throws ParseException {
        logger.info("\u7814\u7a76\u9662\u8fd4\u56dejson-result :" + result);
        JSONObject json = JSONObject.parseObject((String)result);
        int errorCode = json.getInteger("errcode");
        if (errorCode == 0) {
            JSONObject data = json.getJSONObject("data");
            int invoiceNum = data.getInteger("resultNum");
            if (invoiceNum > 0) {
                JSONArray resultArray = data.getJSONArray("resultList");
                JSONObject obj = null;
                DynamicObject invoiceObj = null;
                int size = resultArray.size();
                for (int i = 0; i < size; ++i) {
                    block9: {
                        obj = resultArray.getJSONObject(i);
                        invoiceObj = orm.newDynamicObject("task_invoice");
                        String fphm = obj.getString("fphm");
                        String fprq = obj.getString("kprq");
                        if (fphm == null || fphm.trim().equals("")) {
                            logger.info("the invoice infomation is incomplete,next\uff01");
                            continue;
                        }
                        try {
                            invoiceObj.set(BILLID, (Object)billId);
                            invoiceObj.set(IMAGENUMBER, (Object)imageNumber);
                            invoiceObj.set(IMAGE_PAGE, (Object)obj.getInteger("pageOrder"));
                            if (fprq != null && !"".equals(fprq.trim())) {
                                invoiceObj.set(INVOICEDATE, (Object)this.dateFormat.parse(fprq));
                            }
                            invoiceObj.set(INVOICE_CODE, (Object)obj.getString("fpdm"));
                            invoiceObj.set(INVOICE_TYPE, (Object)obj.getString("invoiceType"));
                            invoiceObj.set(INVOICE_NUMBER, (Object)fphm);
                            invoiceObj.set(HASSTAMP, (Object)obj.getBooleanValue("hasSeal"));
                            invoiceObj.set(IS_TRUE, (Object)(obj.getInteger("verifyStatus") == 1 ? 1 : 0));
                            JSONObject otherInfo = obj.getJSONObject("otherInfo");
                            JSONObject sale = otherInfo.getJSONObject("sale");
                            invoiceObj.set(COMPANY_SALE, (Object)sale.getString("name"));
                            invoiceObj.set(TAX_NUMBER_SALE, (Object)sale.getString("taxpayerId"));
                            invoiceObj.set(CONTACT_SALE, (Object)sale.getString("address_PhoneNumber"));
                            invoiceObj.set(BANK_INFORMATIONSALE, (Object)sale.getString("bank_AccountNumber"));
                            JSONObject purchaser = otherInfo.getJSONObject("purchaser");
                            invoiceObj.set(COMPANY_BUY, (Object)purchaser.getString("name"));
                            invoiceObj.set(TAXNUMBER_BUY, (Object)purchaser.getString("taxpayerId"));
                            invoiceObj.set(CONTACTBUY, (Object)purchaser.getString("address_PhoneNumber"));
                            invoiceObj.set(BANK_INFORMATIONBUY, (Object)purchaser.getString("bank_AccountNumber"));
                            invoiceObj.set(AMOUNT, (Object)purchaser.getString("sum_money"));
                            invoiceObj.set(TAX, (Object)purchaser.getString("sum_tax"));
                            invoiceObj.set(AMOUNTTAX, (Object)purchaser.getString("sum"));
                            JSONArray service = purchaser.getJSONArray("service");
                            DynamicObjectCollection col = invoiceObj.getDynamicObjectCollection(ENTRY);
                            DynamicObject entry = null;
                            if (service == null) break block9;
                            int k = service.size();
                            for (int j = 0; j < k; ++j) {
                                JSONObject ser = service.getJSONObject(j);
                                entry = new DynamicObject(col.getDynamicObjectType());
                                entry.set(PRODUCT_NAME, (Object)ser.getString("service"));
                                entry.set(TAX_EXCLUDED, (Object)ser.getString("unitPrice"));
                                entry.set(QUANTITY, (Object)ser.getString("number"));
                                entry.set(MONEY, (Object)ser.getString(AMOUNT));
                                entry.set(TAXAMT, (Object)ser.getString(TAX));
                                entry.set(TAX_RATE, (Object)ser.getString("taxRate").substring(0, ser.getString("taxRate").length() - 1));
                                entry.set(SPECS, (Object)ser.getString("specification_model"));
                                col.add((Object)entry);
                            }
                        }
                        catch (Exception e) {
                            logger.info("\u89e3\u6790\u53d1\u7968JSON\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
                            logger.error("\u89e3\u6790\u53d1\u7968JSON\u6570\u636e\u51fa\u9519\uff0c", (Throwable)e);
                            continue;
                        }
                    }
                    invoiceList.add(invoiceObj);
                }
            }
        } else {
            logger.info("The image:" + imageNumber + " recognizate fail.ErrorCode is" + errorCode);
        }
    }

    public String getImageResult(String imageUrl) throws IOException {
        if (this.url == null) {
            this.url = this.getURL();
        }
        String result = "";
        if (!this.url.equals("")) {
            HashMap header = new HashMap();
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("client_id", 200679);
            body.put("client_secret", InvoiceUtil.getParam("invoiceSecretClient"));
            body.put("accessKeyId", InvoiceUtil.getParam("accessKeyId"));
            body.put("uid", 10489402);
            body.put("url", imageUrl);
            result = HttpClientUtils.post((String)this.url, header, body, (int)5000, (int)10000);
        }
        return result;
    }

    private String getURL() {
        QFilter filter = new QFilter("paramname", "=", (Object)"invoiceurl");
        DynamicObjectCollection dy = orm.query("task_paramcontrol", filter.toArray());
        if (dy.size() > 0) {
            return ((DynamicObject)dy.get(0)).getString("paramvalue");
        }
        return "";
    }

    public boolean isRecognizaInvoice() {
        QFilter filter = new QFilter("paramname", "=", (Object)"isrecognization");
        DynamicObjectCollection dy = orm.query("task_paramcontrol", filter.toArray());
        if (dy.size() == 0) {
            return true;
        }
        return ((DynamicObject)dy.get(0)).getString("paramvalue").equals("1");
    }
}

