/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.api;

import kd.bos.formula.platform.api.VarInfo;
import kd.bos.formula.platform.engine.AliasTransformer;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public interface IVarInfo {
    public static final String FORMULA_RESULT_STR = "formula_result";
    public static final String VAR_SCOPE_RETURN = "return";
    public static final String VAR_SCOPE_IN = "in";
    public static final String VAR_SCOPE_LOCAL = "local";
    public static final String VAR_TYPE_INT = "INT";
    public static final String VAR_TYPE_LONG = "LONG";
    public static final String VAR_TYPE_DOUBLE = "DOUBLE";
    public static final String VAR_TYPE_STRING = "STRING";
    public static final String VAR_TYPE_DATE = "DATE";
    public static final String VAR_TYPE_BOOLEAN = "BOOLEAN";
    public static final String VAR_TYPE_BIGDECIMAL = "BIGDECIMAL";

    public String getVarName();

    public String getVarType();

    public String getVarAlias();

    public String getVarScope();

    public String getVarInitval();

    public String getVarDesc();

    public static IVarInfo get(String line) {
        int pos = line.indexOf("//{bos_formula_comments_var");
        if (pos < 0) {
            return null;
        }
        String newLine = line.substring(pos);
        VarInfo varInfo = new VarInfo("", "", "", "", "", "");
        String varName = IVarInfo.innerDealVarComments("var_name", newLine);
        if (varName != null && varName.length() > 0) {
            varInfo.setVarName(varName);
            varInfo.setVarScope(IVarInfo.innerDealVarComments("var_scope", newLine));
            if (varName.equals(FORMULA_RESULT_STR)) {
                varInfo.setVarScope(VAR_SCOPE_RETURN);
            }
            varInfo.setVarDesc(IVarInfo.innerDealVarComments("var_desc", newLine));
            String varType = IVarInfo.innerDealVarComments("var_type", newLine);
            String varAlias = IVarInfo.innerDealVarComments("var_alias", newLine);
            varInfo.setVarType(varType);
            varInfo.setVarAlias(varAlias);
        }
        return varInfo;
    }

    public static String genVarStr(IVarInfo varInfo) {
        String retStr = "var " + varInfo.getVarName();
        if (varInfo.getVarInitval() != null) {
            retStr = retStr + "=" + varInfo.getVarInitval();
        }
        retStr = retStr + "; ";
        retStr = retStr + "//{bos_formula_comments_var:var_name=" + varInfo.getVarName() + "|var_type=" + varInfo.getVarType() + "|var_scope=" + varInfo.getVarScope() + "|var_alias=" + AliasTransformer.propTransform(varInfo.getVarAlias()) + "|var_desc=" + varInfo.getVarDesc() + "}";
        return retStr;
    }

    public static String innerDealVarComments(String commentLeft, String commentLine) {
        int pos1 = commentLine.indexOf(commentLeft + "=");
        if (pos1 < 0) {
            return "";
        }
        int pos2 = commentLine.indexOf("|", pos1);
        if (pos2 < 0 && (pos2 = commentLine.indexOf("}", pos1)) < 0) {
            return "";
        }
        String retStr = commentLine.substring(pos1 + (commentLeft + "=").length(), pos2);
        return retStr.trim();
    }
}

