/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.formula.platform.api.BizEnumInfo;
import kd.bos.formula.platform.api.IFormulaVarInfos;
import kd.bos.formula.platform.builder.FormulaDesignerParameter;
import kd.bos.formula.platform.builder.TableModelVar;
import kd.bos.formula.platform.engine.FormulaTransformer;
import kd.bos.kscript.ParserException;

class DesignerFormUtils {
    DesignerFormUtils() {
    }

    public static String transform(String formulaAliasStr, FormulaDesignerParameter parameter, TableModelVar modelVars, Vector<BizEnumInfo> enumInfos) throws ParserException {
        String varsBlock = modelVars.getVarsDefBlock();
        String expsBlock = formulaAliasStr;
        String script = "";
        if (parameter.getRunMode() == 0 || parameter.getRunMode() == 1) {
            FormulaTransformer tran = new FormulaTransformer(modelVars.getVars(), enumInfos);
            DesignerFormUtils.addEntityTypes(tran, parameter);
            script = tran.transforme(expsBlock);
            return varsBlock + script + "\n\rreturn " + "formula_result" + ";";
        }
        if (parameter.getRunMode() == 2) {
            FormulaTransformer tran = new FormulaTransformer(modelVars.getVars(), enumInfos);
            DesignerFormUtils.addEntityTypes(tran, parameter);
            script = tran.transforme(expsBlock);
            return script;
        }
        FormulaTransformer tran = new FormulaTransformer(modelVars.getVars(), enumInfos);
        return tran.transforme(expsBlock);
    }

    private static void addEntityTypes(FormulaTransformer tran, FormulaDesignerParameter parameter) {
        if (parameter == null || parameter.getEntities().isEmpty()) {
            return;
        }
        MainEntityType[] entityTypes = new MainEntityType[parameter.getEntities().size()];
        int i = 0;
        for (String entityNumber : parameter.getEntities().keySet()) {
            MainEntityType mainType;
            entityTypes[i] = mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ++i;
        }
        tran.addEntityTypes(entityTypes);
    }

    public static String reverseTransform(String formulaStr, FormulaDesignerParameter parameter, TableModelVar modelVars, Vector<BizEnumInfo> enumInfos) throws ParserException {
        String displayStr = IFormulaVarInfos.get().getDisplayString(formulaStr);
        FormulaTransformer tran = new FormulaTransformer(modelVars.getVars(), enumInfos);
        DesignerFormUtils.addEntityTypes(tran, parameter);
        return tran.reverseTransform(displayStr);
    }

    public static void insertExpression(IFormView view, String buttonKey, String textFieldKey, String str) {
        int pos = DesignerFormUtils.getCursorIndex(view, buttonKey, textFieldKey);
        String expression = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = pos;
        if (StringUtils.isBlank((CharSequence)expression)) {
            expression = str;
            cursorIndex = expression.length();
        } else {
            String insertStr = " " + str + " ";
            expression = DesignerFormUtils.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        view.getModel().setValue(textFieldKey, (Object)expression);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>();
        cursorMap.put("cursorIndex", cursorIndex);
        cursorMap.put("ctrlKey", textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", cursorMap);
    }

    public static String insertCharacter(String pStr, String str, int pos) {
        int i;
        if (pStr.length() < pos) {
            pos = pStr.length();
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pos; ++i) {
            sb.append(pStr.charAt(i));
        }
        sb.append(str);
        for (i = pos; i < pStr.length(); ++i) {
            sb.append(pStr.charAt(i));
        }
        return sb.toString();
    }

    public static int getCursorIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get("focus") != null) {
                Map focus = (Map)map.get("focus");
                if (focus.get(textFieldKey) != null) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    public static void setCursorIndex(IFormView view, String textFieldKey, int focusIndex) {
        HashMap<String, Object> cursorMap = new HashMap<String, Object>();
        cursorMap.put("ctrlKey", textFieldKey);
        cursorMap.put("cursorIndex", focusIndex);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", cursorMap);
    }
}

