/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.bos.formula.platform.builder.EntityPropInfo;

class EntityCategory {
    private Map<String, EntityPropInfo> props = new LinkedHashMap<String, EntityPropInfo>();
    private String categoryName;
    private String categoryCaption;

    public EntityCategory() {
    }

    public EntityCategory(String name, String caption) {
        this.categoryName = name;
        this.categoryCaption = caption;
    }

    public void setName(String category) {
        this.categoryName = category;
    }

    public String getName() {
        return this.categoryName;
    }

    public void setCaption(String caption) {
        this.categoryCaption = caption;
    }

    public String getCaption() {
        return this.categoryCaption;
    }

    public Map<String, EntityPropInfo> getProps() {
        return this.props;
    }

    public void getProps(Map<String, EntityPropInfo> props) {
        this.props = props;
    }

    public EntityPropInfo findEntityProp(String fullPropName) {
        if (this.props.containsKey(fullPropName)) {
            return this.props.get(fullPropName);
        }
        for (EntityPropInfo item : this.props.values()) {
            EntityPropInfo prop = item.findEntityProp(fullPropName);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    public void add(EntityPropInfo propInfo) {
        this.props.put(propInfo.getFullPropName(), propInfo);
    }

    public TreeNode buildEntityTree(TreeNode parent) {
        TreeNode selfNode = new TreeNode();
        selfNode.setParentid(parent == null ? "" : parent.getId());
        selfNode.setId(this.getName());
        selfNode.setIsOpened(true);
        selfNode.setText(this.getCaption());
        for (Map.Entry<String, EntityPropInfo> item : this.props.entrySet()) {
            TreeNode childNode = item.getValue().buildEntityTree(selfNode);
            selfNode.addChild(childNode);
        }
        return selfNode;
    }

    public String toString() {
        return this.categoryCaption;
    }
}

