/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.platform.builder.FormulaDesignerParameter;
import kd.bos.formula.platform.builder.FormulaDesignerResult;
import kd.bos.formula.platform.builder.FormulaPlatDesignPlugin;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormulaDesigner {
    public static String showInContainer(IFormView parentView, String targetPanel, FormulaDesignerParameter parameter) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_formulaplatdesign");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetPanel);
        String parameterStr = SerializationUtils.toJsonString((Object)parameter);
        showParameter.getCustomParams().put("formuladisignerparameter", parameterStr);
        parentView.showForm(showParameter);
        return showParameter.getPageId();
    }

    public static String showModal(IFormView parentView, CloseCallBack closeCallBack, FormulaDesignerParameter parameter) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_formulaplatdesign");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String parameterStr = SerializationUtils.toJsonString((Object)parameter);
        showParameter.getCustomParams().put("formuladisignerparameter", parameterStr);
        showParameter.setCloseCallBack(closeCallBack);
        parentView.showForm(showParameter);
        return showParameter.getPageId();
    }

    public static FormulaDesignerResult getFormulaStr(IFormView parentView, String pageId) {
        IFormView designView = parentView.getView(pageId);
        if (designView == null) {
            return null;
        }
        FormulaPlatDesignPlugin designPlugIn = null;
        FormViewPluginProxy proxy = (FormViewPluginProxy)designView.getService(FormViewPluginProxy.class);
        if (proxy != null) {
            for (IFormPlugin plugin : proxy.getPlugIns()) {
                if (!(plugin instanceof FormulaPlatDesignPlugin)) continue;
                designPlugIn = (FormulaPlatDesignPlugin)plugin;
                break;
            }
        }
        if (designPlugIn == null) {
            return null;
        }
        if (!designPlugIn.returnDesignResult()) {
            parentView.sendFormAction(designView);
            return null;
        }
        String str = (String)designView.getReturnData();
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (FormulaDesignerResult)SerializationUtils.fromJsonString((String)str, FormulaDesignerResult.class);
    }
}

