/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.platform.api.BizEnumInfo;
import kd.bos.formula.platform.api.FuncInfo;
import kd.bos.formula.platform.api.IFormulaVarInfos;
import kd.bos.formula.platform.api.VarInfo;
import kd.bos.formula.platform.builder.DesignerFormUtils;
import kd.bos.formula.platform.builder.EntityPropInfo;
import kd.bos.formula.platform.builder.FormulaDesignerParameter;
import kd.bos.formula.platform.builder.FormulaDesignerResult;
import kd.bos.formula.platform.builder.TableModelVar;
import kd.bos.formula.platform.builder.TableVarInfo;
import kd.bos.formula.platform.builder.TreeModelBOSEntities;
import kd.bos.formula.platform.builder.TreeModelFuncs;
import kd.bos.kscript.ParserException;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class FormulaPlatDesignPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
TabSelectListener {
    public static final String FormId_FormulaPlatDesign = "bos_formulaplatdesign";
    public static final String FormId_FormulaPlatFuncParam = "bos_formulaplatfuncparam";
    public static final String CustParam_FormulaDesignerParameter = "formuladisignerparameter";
    private static final String CACHEKEY_TABLEMODELVAR = "tablemodelvar";
    private static final String CACHEKEY_TREEMODELENTITY = "treemodelentity";
    private static final String CACHEKEY_TREEMODELFUNC = "treemodelfunc";
    private static final String CACHEKEY_TABLEMODELENUM = "tablemodelenum";
    private static final String CLOSECALLBACKACTIONID_FUNC = "funccallback";
    private static final String KEY_TAB_SCRIPT = "tabscript";
    private static final String Key_TabPage_Alias = "tabpage_alias";
    private static final String KEY_TABPAGE_SCRIPT = "tabpage_script";
    private static final String KEY_FLD_FORMULAALIAS = "aliastext";
    private static final String KEY_FLD_FORMULASCRIPT = "scripttext";
    private static final String KEY_TAB_TREE = "tabtree";
    private static final String KEY_TABPAGE_ENTITY = "tabpage_entity";
    private static final String KEY_TABPAGE_FUNC = "tabpage_func";
    private static final String KEY_TREE_ENTITY = "entitytree";
    private static final String KEY_TREE_FUNC = "functree";
    private static final String KEY_FLD_ELENENTDESC = "elementdesc";
    private static final String KEY_ENTITY_VAR = "varentity";
    private static final String KEY_TOOLBAR_VARENTRY = "varentrytoolbar";
    private static final String KEY_BARITEM_ADDVAR = "bar_addvar";
    private static final String KEY_BARITEM_DELVAR = "bar_delvar";
    private static final String KEY_BARITEM_INSERTVAR = "bar_insertvar";
    private static final String KEY_FLD_VARNAME = "varname";
    private static final String KEY_FLD_VARALIAS = "varalias";
    private static final String KEY_FLD_VARTYPE = "vartype";
    private static final String KEY_FLD_VARINITVALUE = "varinitvalue";
    private static final String KEY_FLD_VARSCOPE = "varscope";
    private static final String KEY_FLD_VARDESC = "vardesc";
    private static final String KEY_BUTTON_IF = "btn_if";
    private static final String KEY_BUTTON_IFELSE = "btn_ifelse";
    private static final String KEY_BUTTON_IFELSEIF = "btn_ifelseif";
    private static final String KEY_BUTTON_DAYU = "btn_dayu";
    private static final String KEY_BUTTON_DENGYU = "btn_dengyu";
    private static final String KEY_BUTTON_SHUANGSHUXIAN = "btn_shuangshuxian";
    private static final String KEY_BUTTON_XIAOYU = "btn_xiaoyu";
    private static final String KEY_BUTTON_BUDENGYU = "btn_budengyu";
    private static final String KEY_BUTTON_DAYUDENGYU = "btn_dayudengyu";
    private static final String KEY_BUTTON_XIAODENGYU = "btn_xiaoyudengyu";
    private static final String KEY_BUTTON_AND = "btn_and";
    private static final String KEY_BUTTON_OR = "btn_or";
    private static final String KEY_BUTTON_IS = "btn_is";
    private static final String KEY_BUTTON_NOT = "btn_not";
    private static final String KEY_BUTTON_JIA = "btn_jia";
    private static final String KEY_BUTTON_JIAN = "btn_jian";
    private static final String KEY_BUTTON_CHENG = "btn_cheng";
    private static final String KEY_BUTTON_CHU = "btn_chu";
    private static final String KEY_BUTTON_FUZHI = "btn_fuzhi";
    private static final String KEY_BUTTON_XIAOKUOHAO = "btn_xiaokuohao";
    private static final String KEY_BUTTON_ZHONGKUOHAO = "btn_zhongkuohao";
    private static final String KEY_BUTTON_DAKUOHAO = "btn_dakuohao";
    private static final String KEY_BUTTON_FX = "btn_fx";
    private static final String KEY_BUTTON_FIND = "btn_find";
    private static final String KEY_BUTTON_TRANS = "btn_trans";
    private static final String KEY_BUTTON_OK = "btn_ok";
    private static final String KEY_BUTTON_CANCEL = "btn_cancel";
    private static final String BOS_FORMULA_PLATFORM = "bos-formula-platform";
    private static Map<String, String> opExpValues = new HashMap<String, String>();
    private FormulaDesignerParameter parameter;
    private TableModelVar modelVars;
    private TreeModelBOSEntities modelEntities;
    private TreeModelFuncs modelFuncs;
    private Vector enumInfos;

    public void afterCreateNewData(EventObject e) {
        FormulaDesignerParameter parameter = this.getParameter();
        this.initVarEntry(parameter);
        this.initEnumInfos(parameter);
        String formulaAliasStr = parameter.getFormulaStr();
        String formulaStr = parameter.getFormulaStr();
        try {
            formulaAliasStr = DesignerFormUtils.reverseTransform(parameter.getFormulaStr(), parameter, this.getModelVars(), this.getEnumInfos());
            formulaStr = DesignerFormUtils.transform(formulaAliasStr, parameter, this.getModelVars(), this.getEnumInfos());
            formulaStr = IFormulaVarInfos.get().getDisplayString(formulaStr);
        }
        catch (ParserException exp) {
            String msg = String.format(ResManager.loadKDString((String)"\u6e90\u811a\u672c\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaPlatDesignPlugin_7", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), exp.getMessage());
            this.getView().showErrMessage(msg, ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u51fa\u9519", (String)"FormulaPlatDesignPlugin_8", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
            formulaAliasStr = formulaStr;
        }
        this.getModel().setValue(KEY_FLD_FORMULAALIAS, (Object)formulaAliasStr);
        this.getModel().setValue(KEY_FLD_FORMULASCRIPT, (Object)formulaStr);
    }

    public void afterBindData(EventObject e) {
        FormulaDesignerParameter parameter = this.getParameter();
        if (!parameter.isEditable()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.initEntityTree(parameter);
        this.initFuncTree(parameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BUTTON_IF, KEY_BUTTON_IFELSE, KEY_BUTTON_IFELSEIF, KEY_BUTTON_DAYU, KEY_BUTTON_DENGYU, KEY_BUTTON_SHUANGSHUXIAN, KEY_BUTTON_XIAOYU, KEY_BUTTON_BUDENGYU, KEY_BUTTON_DAYUDENGYU, KEY_BUTTON_XIAODENGYU, KEY_BUTTON_AND, KEY_BUTTON_OR, KEY_BUTTON_IS, KEY_BUTTON_NOT, KEY_BUTTON_JIA, KEY_BUTTON_JIAN, KEY_BUTTON_CHENG, KEY_BUTTON_CHU, KEY_BUTTON_FUZHI, KEY_BUTTON_XIAOKUOHAO, KEY_BUTTON_ZHONGKUOHAO, KEY_BUTTON_DAKUOHAO});
        this.addClickListeners(new String[]{KEY_BUTTON_FX, KEY_BUTTON_FIND, KEY_BUTTON_TRANS, KEY_BUTTON_OK, KEY_BUTTON_CANCEL});
        this.addItemClickListeners(new String[]{KEY_TOOLBAR_VARENTRY});
        TreeView entityTree = (TreeView)this.getView().getControl(KEY_TREE_ENTITY);
        entityTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        entityTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView funcTree = (TreeView)this.getView().getControl(KEY_TREE_FUNC);
        funcTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        funcTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tabScript = (Tab)this.getView().getControl(KEY_TAB_SCRIPT);
        tabScript.addTabSelectListener((TabSelectListener)this);
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (opExpValues.containsKey(source.getKey())) {
            String opExpValue = opExpValues.get(source.getKey());
            DesignerFormUtils.insertExpression(this.getView(), source.getKey(), KEY_FLD_FORMULAALIAS, opExpValue);
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTON_OK)) {
            if (this.returnDesignResult()) {
                this.getView().close();
            }
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTON_CANCEL)) {
            this.getView().close();
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        if (StringUtils.equals((CharSequence)KEY_BARITEM_ADDVAR, (CharSequence)e.getItemKey())) {
            this.onAddVarClick();
        } else if (StringUtils.equals((CharSequence)KEY_BARITEM_DELVAR, (CharSequence)e.getItemKey())) {
            this.onDelVarClick();
        } else if (StringUtils.equals((CharSequence)KEY_BARITEM_INSERTVAR, (CharSequence)e.getItemKey())) {
            this.onInsertVarClick();
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
    }

    public void treeNodeClick(TreeNodeEvent e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_TREE_FUNC)) {
            String funcName = (String)e.getNodeId();
            FuncInfo funcInfo = this.getModelFuncs().findFunc(funcName);
            if (funcInfo == null) {
                this.getModel().setValue(KEY_FLD_ELENENTDESC, (Object)"");
            } else {
                this.getModel().setValue(KEY_FLD_ELENENTDESC, (Object)funcInfo.getFuncDesc());
            }
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_TREE_FUNC)) {
            String funcName = (String)e.getNodeId();
            this.onDoubleClickFuncNode(funcName);
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_TREE_ENTITY)) {
            String fullPropName = (String)e.getNodeId();
            this.onDoubleClickEntityNode(fullPropName);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        if (StringUtils.equals((CharSequence)e.getTabKey(), (CharSequence)KEY_TABPAGE_SCRIPT)) {
            String formulaAliasStr = (String)this.getModel().getValue(KEY_FLD_FORMULAALIAS);
            try {
                String formulaStr = DesignerFormUtils.transform(formulaAliasStr, this.getParameter(), this.getModelVars(), this.getEnumInfos());
                formulaStr = IFormulaVarInfos.get().getDisplayString(formulaStr);
                this.getModel().setValue(KEY_FLD_FORMULASCRIPT, (Object)formulaStr);
            }
            catch (ParserException exp) {
                String msg = String.format(ResManager.loadKDString((String)"\u6e90\u811a\u672c\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaPlatDesignPlugin_7", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), exp.getMessage());
                this.getView().showErrMessage(msg, ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u51fa\u9519", (String)"FormulaPlatDesignPlugin_8", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        TableVarInfo varInfo;
        int rowIndex;
        TableModelVar modelVars;
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_FLD_VARNAME)) {
            modelVars = this.getModelVars();
            for (ChangeData data : e.getChangeSet()) {
                rowIndex = data.getRowIndex();
                varInfo = modelVars.getRow(rowIndex);
                varInfo.setVarName((String)this.getModel().getValue(KEY_FLD_VARNAME, rowIndex));
            }
            this.cacheModelVars();
        } else if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_FLD_VARALIAS)) {
            modelVars = this.getModelVars();
            for (ChangeData data : e.getChangeSet()) {
                rowIndex = data.getRowIndex();
                varInfo = modelVars.getRow(rowIndex);
                varInfo.setVarAlias((String)this.getModel().getValue(KEY_FLD_VARALIAS, rowIndex));
            }
            this.cacheModelVars();
        }
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_FLD_VARTYPE)) {
            modelVars = this.getModelVars();
            for (ChangeData data : e.getChangeSet()) {
                rowIndex = data.getRowIndex();
                varInfo = modelVars.getRow(rowIndex);
                varInfo.setVarType((String)this.getModel().getValue(KEY_FLD_VARTYPE, rowIndex));
            }
            this.cacheModelVars();
        }
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_FLD_VARINITVALUE)) {
            modelVars = this.getModelVars();
            for (ChangeData data : e.getChangeSet()) {
                rowIndex = data.getRowIndex();
                varInfo = modelVars.getRow(rowIndex);
                varInfo.setVarInitval((String)this.getModel().getValue(KEY_FLD_VARINITVALUE, rowIndex));
            }
            this.cacheModelVars();
        }
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_FLD_VARDESC)) {
            modelVars = this.getModelVars();
            for (ChangeData data : e.getChangeSet()) {
                rowIndex = data.getRowIndex();
                varInfo = modelVars.getRow(rowIndex);
                varInfo.setVarDesc((String)this.getModel().getValue(KEY_FLD_VARDESC, rowIndex));
            }
            this.cacheModelVars();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)CLOSECALLBACKACTIONID_FUNC) && StringUtils.isNotBlank((Object)e.getReturnData())) {
            DesignerFormUtils.insertExpression(this.getView(), KEY_TREE_FUNC, KEY_FLD_FORMULAALIAS, (String)e.getReturnData());
        }
    }

    private FormulaDesignerParameter getParameter() {
        if (this.parameter == null) {
            String parameterStr = (String)this.getView().getFormShowParameter().getCustomParams().get(CustParam_FormulaDesignerParameter);
            this.parameter = StringUtils.isBlank((CharSequence)parameterStr) ? new FormulaDesignerParameter() : (FormulaDesignerParameter)SerializationUtils.fromJsonString((String)parameterStr, FormulaDesignerParameter.class);
        }
        return this.parameter;
    }

    private TableModelVar getModelVars() {
        String str;
        if (this.modelVars == null && StringUtils.isNotBlank((CharSequence)(str = this.getPageCache().get(CACHEKEY_TABLEMODELVAR)))) {
            this.modelVars = (TableModelVar)SerializationUtils.fromJsonString((String)str, TableModelVar.class);
        }
        return this.modelVars;
    }

    private void cacheModelVars() {
        if (this.modelVars != null) {
            String str = SerializationUtils.toJsonString((Object)this.modelVars);
            this.getPageCache().put(CACHEKEY_TABLEMODELVAR, str);
        }
    }

    private void initVarEntry(FormulaDesignerParameter parameter) {
        this.modelVars = new TableModelVar();
        this.modelVars.init();
        if (parameter.getVarInfos() != null && !parameter.getVarInfos().isEmpty()) {
            for (VarInfo varInfo : parameter.getVarInfos()) {
                if (varInfo instanceof TableVarInfo) {
                    this.modelVars.addVar((TableVarInfo)varInfo);
                    continue;
                }
                TableVarInfo tableVarInfo = new TableVarInfo(varInfo);
                tableVarInfo.setCreatedWay(3);
                this.modelVars.addVar(tableVarInfo);
            }
        }
        this.modelVars.dealVarDefs(parameter.getFormulaStr(), parameter);
        this.getModel().batchCreateNewEntryRow(KEY_ENTITY_VAR, this.modelVars.getRowCount());
        int rowIndex = 0;
        for (TableVarInfo varInfo : this.modelVars.getVars()) {
            this.setVarRow(varInfo, rowIndex);
            ++rowIndex;
        }
        this.cacheModelVars();
    }

    private void onAddVarClick() {
        TableVarInfo varInfo1;
        TableModelVar modelVars = this.getModelVars();
        TableVarInfo varInfo = new TableVarInfo("varName", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d8\u91cf", (String)"FormulaPlatDesignPlugin_9", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), "", "", "local", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d8\u91cf", (String)"FormulaPlatDesignPlugin_9", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), 5);
        if (varInfo.equals(varInfo1 = modelVars.addVar(varInfo))) {
            int rowIndex = this.getModel().createNewEntryRow(KEY_ENTITY_VAR);
            this.setVarRow(varInfo1, rowIndex);
            this.cacheModelVars();
        }
    }

    private void onDelVarClick() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTITY_VAR);
        int rowIndex = entryGrid.getEntryState().getFocusRow();
        TableModelVar modelVars = this.getModelVars();
        if (modelVars.removeVar(rowIndex)) {
            this.getModel().deleteEntryRow(KEY_ENTITY_VAR, rowIndex);
            this.cacheModelVars();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5220\u9664\u672c\u5730\u53d8\u91cf", (String)"FormulaPlatDesignPlugin_10", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        }
    }

    private void onInsertVarClick() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTITY_VAR);
        int rowIndex = entryGrid.getEntryState().getFocusRow();
        if (rowIndex < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u63d2\u5165\u7684\u53d8\u91cf", (String)"FormulaPlatDesignPlugin_11", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
            return;
        }
        TableModelVar modelVars = this.getModelVars();
        TableVarInfo varInfo = modelVars.getRow(rowIndex);
        if (varInfo != null) {
            DesignerFormUtils.insertExpression(this.getView(), KEY_TOOLBAR_VARENTRY, KEY_FLD_FORMULAALIAS, varInfo.getVarAlias());
        }
    }

    private void setVarRow(TableVarInfo varInfo, int rowIndex) {
        this.getModel().setValue(KEY_FLD_VARNAME, (Object)varInfo.getVarName(), rowIndex);
        this.getModel().setValue(KEY_FLD_VARALIAS, (Object)varInfo.getVarAlias(), rowIndex);
        this.getModel().setValue(KEY_FLD_VARTYPE, (Object)varInfo.getVarType(), rowIndex);
        this.getModel().setValue(KEY_FLD_VARINITVALUE, (Object)varInfo.getVarInitval(), rowIndex);
        this.getModel().setValue(KEY_FLD_VARSCOPE, (Object)varInfo.getVarScope(), rowIndex);
        this.getModel().setValue(KEY_FLD_VARDESC, (Object)varInfo.getVarDesc(), rowIndex);
    }

    private Vector<BizEnumInfo> getEnumInfos() {
        String str;
        if (this.enumInfos == null && StringUtils.isNotBlank((CharSequence)(str = this.getPageCache().get(CACHEKEY_TABLEMODELENUM)))) {
            this.enumInfos = (Vector)SerializationUtils.fromJsonString((String)str, Vector.class);
        }
        return this.enumInfos;
    }

    private void cacheEnumInfos() {
        if (this.enumInfos != null) {
            String str = SerializationUtils.toJsonString((Object)this.enumInfos);
            this.getPageCache().put(CACHEKEY_TABLEMODELENUM, str);
        }
    }

    private void initEnumInfos(FormulaDesignerParameter parameter) {
    }

    public TreeModelFuncs getModelFuncs() {
        String str;
        if (this.modelFuncs == null && StringUtils.isNotBlank((CharSequence)(str = this.getPageCache().get(CACHEKEY_TREEMODELFUNC)))) {
            this.modelFuncs = (TreeModelFuncs)SerializationUtils.fromJsonString((String)str, TreeModelFuncs.class);
        }
        return this.modelFuncs;
    }

    private void cacheModelFuncs() {
        if (this.modelFuncs != null) {
            String str = SerializationUtils.toJsonString((Object)this.modelFuncs);
            this.getPageCache().put(CACHEKEY_TREEMODELFUNC, str);
        }
    }

    private void initFuncTree(FormulaDesignerParameter parameter) {
        this.modelFuncs = new TreeModelFuncs();
        this.modelFuncs.initFormulaFuncs(parameter.getFuncInfos());
        TreeNode rootNode = this.modelFuncs.buildFuncTree();
        TreeView treeFuncs = (TreeView)this.getView().getControl(KEY_TREE_FUNC);
        treeFuncs.addNode(rootNode);
        this.cacheModelFuncs();
    }

    private void onDoubleClickFuncNode(String funcName) {
        TreeModelFuncs modelFuncs = this.getModelFuncs();
        FuncInfo funcInfo = modelFuncs.findFunc(funcName);
        if (funcInfo == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)funcInfo.getParaFormId())) {
            String funcFormula = funcInfo.getFuncFormula();
            if (StringUtils.isBlank((CharSequence)funcFormula)) {
                funcFormula = funcInfo.getFuncName() + "( )";
            }
            DesignerFormUtils.insertExpression(this.getView(), KEY_TREE_FUNC, KEY_FLD_FORMULAALIAS, funcFormula);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FormId_FormulaPlatFuncParam);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSECALLBACKACTIONID_FUNC);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.getCustomParams().put("funcinfo", SerializationUtils.toJsonString((Object)funcInfo));
            this.getView().showForm(showParameter);
        }
    }

    private TreeModelBOSEntities getModelEntities() {
        String str;
        if (this.modelEntities == null && StringUtils.isNotBlank((CharSequence)(str = this.getPageCache().get(CACHEKEY_TREEMODELENTITY)))) {
            this.modelEntities = (TreeModelBOSEntities)SerializationUtils.fromJsonString((String)str, TreeModelBOSEntities.class);
        }
        return this.modelEntities;
    }

    private void cacheModelEntities() {
        if (this.modelEntities != null) {
            String str = SerializationUtils.toJsonString((Object)this.modelEntities);
            this.getPageCache().put(CACHEKEY_TREEMODELENTITY, str);
        }
    }

    private void initEntityTree(FormulaDesignerParameter parameter) {
        if (parameter.getEntities().isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_TABPAGE_ENTITY});
            Tab tab = (Tab)this.getView().getControl(KEY_TAB_TREE);
            tab.activeTab(KEY_TABPAGE_FUNC);
            return;
        }
        this.modelEntities = new TreeModelBOSEntities();
        for (Map.Entry<String, PropTreeBuildOption> entry : parameter.getEntities().entrySet()) {
            this.modelEntities.addEntity(entry.getKey(), entry.getValue());
        }
        TreeNode rootNode = this.modelEntities.build();
        TreeView treeEntity = (TreeView)this.getView().getControl(KEY_TREE_ENTITY);
        treeEntity.addNode(rootNode);
        this.cacheModelEntities();
    }

    private void onDoubleClickEntityNode(String fullPropName) {
        TreeModelBOSEntities modelEntities = this.getModelEntities();
        EntityPropInfo propInfo = modelEntities.findEntityProp(fullPropName);
        if (propInfo == null || propInfo.isVirtualProp()) {
            return;
        }
        DesignerFormUtils.insertExpression(this.getView(), KEY_TREE_ENTITY, KEY_FLD_FORMULAALIAS, propInfo.getFullPropCaption());
    }

    public boolean returnDesignResult() {
        String formulaAliasStr = (String)this.getModel().getValue(KEY_FLD_FORMULAALIAS);
        String formulaStr = null;
        try {
            formulaStr = DesignerFormUtils.transform(formulaAliasStr, this.getParameter(), this.getModelVars(), this.getEnumInfos());
        }
        catch (ParserException exp) {
            String msg = ResManager.loadKDString((String)"\u6e90\u811a\u672c\u6709\u8bed\u6cd5\u9519\u8bef\uff1a", (String)"FormulaPlatDesignPlugin_12", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
            msg = msg + "\r\n" + exp.getMessage();
            this.getView().showErrMessage(msg, "");
            return false;
        }
        FormulaDesignerResult designerResult = new FormulaDesignerResult();
        designerResult.setFormulaStr(formulaStr);
        designerResult.setFormulaAliasStr(formulaAliasStr);
        String returnStr = SerializationUtils.toJsonString((Object)designerResult);
        this.getView().returnDataToParent((Object)returnStr);
        return true;
    }

    static {
        opExpValues.put(KEY_BUTTON_IF, String.format(ResManager.loadKDString((String)"\u5982\u679c%s", (String)"FormulaPlatDesignPlugin_0", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), "(...) { \n \n } \n"));
        opExpValues.put(KEY_BUTTON_IFELSE, String.format(ResManager.loadKDString((String)"\u5982\u679c%1$s\u5426\u5219%2$s", (String)"FormulaPlatDesignPlugin_1", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), "(...) { \n \n } \n ", " { \n \n } \n"));
        opExpValues.put(KEY_BUTTON_IFELSEIF, String.format(ResManager.loadKDString((String)"\u5982\u679c%1$s\u5426\u5219\u5982\u679c%2$s\u5426\u5219%3$s", (String)"FormulaPlatDesignPlugin_2", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), "(...) { \n \n } \n ", "(...) { \n \n } \n ", " { \n \n } \n"));
        opExpValues.put(KEY_BUTTON_DAYU, ">");
        opExpValues.put(KEY_BUTTON_XIAOYU, "<");
        opExpValues.put(KEY_BUTTON_DENGYU, "==");
        opExpValues.put(KEY_BUTTON_BUDENGYU, "!=");
        opExpValues.put(KEY_BUTTON_DAYUDENGYU, ">=");
        opExpValues.put(KEY_BUTTON_XIAODENGYU, "<=");
        opExpValues.put(KEY_BUTTON_SHUANGSHUXIAN, "||");
        opExpValues.put(KEY_BUTTON_AND, ResManager.loadKDString((String)"\u4e14", (String)"FormulaPlatDesignPlugin_3", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        opExpValues.put(KEY_BUTTON_OR, ResManager.loadKDString((String)"\u6216", (String)"FormulaPlatDesignPlugin_4", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        opExpValues.put(KEY_BUTTON_IS, ResManager.loadKDString((String)"\u662f", (String)"FormulaPlatDesignPlugin_5", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        opExpValues.put(KEY_BUTTON_NOT, ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"FormulaPlatDesignPlugin_6", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        opExpValues.put(KEY_BUTTON_JIA, "+");
        opExpValues.put(KEY_BUTTON_JIAN, "-");
        opExpValues.put(KEY_BUTTON_CHENG, "*");
        opExpValues.put(KEY_BUTTON_CHU, "/");
        opExpValues.put(KEY_BUTTON_FUZHI, "=");
        opExpValues.put(KEY_BUTTON_XIAOKUOHAO, "(......)");
        opExpValues.put(KEY_BUTTON_ZHONGKUOHAO, "[......]");
        opExpValues.put(KEY_BUTTON_DAKUOHAO, "{......}");
    }
}

