/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.formula.platform.api.FuncInfo;
import kd.bos.formula.platform.builder.FuncCategory;

class FuncCategories {
    private Map<String, FuncCategory> categories = new LinkedHashMap<String, FuncCategory>();

    FuncCategories() {
    }

    public Map<String, FuncCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(Map<String, FuncCategory> categories) {
        this.categories = categories;
    }

    public String toString() {
        return ResManager.loadKDString((String)"\u51fd\u6570", (String)"FuncCategories_0", (String)"bos-formula-platform", (Object[])new Object[0]);
    }

    public FuncCategory findCategory(String category) {
        return this.categories.get(category);
    }

    public FuncInfo findFunc(String funcName) {
        for (Map.Entry<String, FuncCategory> item : this.categories.entrySet()) {
            FuncInfo funcInfo = item.getValue().findFunc(funcName);
            if (funcInfo == null) continue;
            return funcInfo;
        }
        return null;
    }

    public void add(FuncCategory category) {
        this.categories.put(category.getName(), category);
    }

    public void addFunc(FuncInfo func) {
        String catetoryName = func.getFuncCatetory();
        if (StringUtils.isBlank((CharSequence)catetoryName)) {
            catetoryName = "unknown";
        }
        if (this.categories.containsKey(catetoryName)) {
            FuncCategory category = this.categories.get(catetoryName);
            category.add(func);
        } else {
            FuncCategory newCategory = new FuncCategory(catetoryName);
            newCategory.add(func);
            this.categories.put(catetoryName, newCategory);
        }
    }

    public TreeNode buildFuncTree(TreeNode parent) {
        TreeNode selfNode = new TreeNode();
        selfNode.setParentid(parent == null ? "" : parent.getId());
        selfNode.setId("functreenode");
        selfNode.setIsOpened(true);
        selfNode.setText(this.toString());
        for (Map.Entry<String, FuncCategory> item : this.categories.entrySet()) {
            TreeNode node = item.getValue().buildFuncTree(selfNode);
            selfNode.addChild(node);
        }
        return selfNode;
    }
}

