/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.formula.platform.api.IFormulaVarInfos;
import kd.bos.formula.platform.api.IVarInfo;
import kd.bos.formula.platform.builder.FormulaDesignerParameter;
import kd.bos.formula.platform.builder.TableVarInfo;

class TableModelVar {
    private Vector<TableVarInfo> vars = new Vector();

    TableModelVar() {
    }

    public void init() {
        this.addVar(new TableVarInfo("formula_result", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c", (String)"TableModelVar_0", (String)"bos-formula-platform", (Object[])new Object[0]), "", "", "return", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c", (String)"TableModelVar_0", (String)"bos-formula-platform", (Object[])new Object[0]), 3));
    }

    public int getRowCount() {
        return this.vars.size();
    }

    public Vector<TableVarInfo> getVars() {
        return this.vars;
    }

    public TableVarInfo getRow(int idx) {
        return this.vars.get(idx);
    }

    public boolean removeVar(int idx) {
        if (idx < 0 || idx > this.vars.size() - 1) {
            return false;
        }
        TableVarInfo var = this.vars.get(idx);
        if (var.getCreatedWay() == 3) {
            return false;
        }
        this.vars.remove(idx);
        return true;
    }

    public void removeAllVars() {
        this.vars.removeAllElements();
    }

    public TableVarInfo getVarInfoByName(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.vars.size(); ++i) {
            if (!name.equals(this.vars.get(i).getVarName())) continue;
            return this.vars.get(i);
        }
        return null;
    }

    public TableVarInfo getVarInfoByType(String type) {
        if (type == null) {
            return null;
        }
        for (int i = 0; i < this.vars.size(); ++i) {
            if (this.vars.get(i).getVarType().trim().equals("") || !this.vars.get(i).getVarType().equals(type)) continue;
            return this.vars.get(i);
        }
        return null;
    }

    public TableVarInfo[] getVarInfosByType(String type) {
        if (type == null) {
            return null;
        }
        ArrayList<TableVarInfo> varInfos = new ArrayList<TableVarInfo>(10);
        for (TableVarInfo var : this.vars) {
            if ("".equals(var.getVarType().trim()) || !var.getVarType().equals(type)) continue;
            varInfos.add(var);
        }
        TableVarInfo[] varInfoArr = new TableVarInfo[varInfos.size()];
        for (int k = 0; k < varInfoArr.length; ++k) {
            varInfoArr[k] = (TableVarInfo)varInfos.get(k);
        }
        return varInfoArr;
    }

    public TableVarInfo addVar(TableVarInfo varInfo) {
        TableVarInfo oldVarInfo1;
        if (varInfo.getCreatedWay() == 1) {
            return this.getVarInfoByName(varInfo.getVarName());
        }
        if (varInfo.getCreatedWay() == 5) {
            HashSet<String> varNames = new HashSet<String>();
            for (TableVarInfo row : this.vars) {
                varNames.add(row.getVarName());
            }
            String theName = varInfo.getVarName();
            for (int idx = 1; idx <= varNames.size() + 1; ++idx) {
                theName = varInfo.getVarName() + String.valueOf(idx);
                if (varNames.contains(theName)) continue;
                varInfo.setVarName(theName);
                varInfo.setVarAlias(varInfo.getVarAlias() + String.valueOf(idx));
                break;
            }
            this.vars.add(varInfo);
            return varInfo;
        }
        if (varInfo.getCreatedWay() == 2 || varInfo.getCreatedWay() == 3) {
            TableVarInfo oldVarInfo = this.getVarInfoByName(varInfo.getVarName());
            if (oldVarInfo != null) {
                return oldVarInfo;
            }
            this.vars.add(varInfo);
            return varInfo;
        }
        if (!this.isBasicVarType(varInfo.getVarType()) && (oldVarInfo1 = this.getVarInfoByType(varInfo.getVarType())) != null) {
            return oldVarInfo1;
        }
        this.vars.add(varInfo);
        return varInfo;
    }

    private boolean isBasicVarType(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("in") || type.equals("local");
    }

    public void dealVarDefs(String formulaStr, FormulaDesignerParameter parameter) {
        if (parameter.getRunMode() == 2) {
            return;
        }
        IVarInfo[] varInfos = IFormulaVarInfos.get().getFormulaVars(formulaStr);
        if (varInfos == null || varInfos.length <= 0) {
            return;
        }
        for (int i = 0; i < varInfos.length; ++i) {
            TableVarInfo varInfo = new TableVarInfo(varInfos[i].getVarName(), varInfos[i].getVarAlias(), varInfos[i].getVarType(), varInfos[i].getVarInitval(), varInfos[i].getVarScope(), varInfos[i].getVarDesc(), 2);
            this.addVar(varInfo);
        }
    }

    public String getVarsDefBlock() {
        return IFormulaVarInfos.get().genVarsDefBlock(this.vars);
    }
}

