/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.formula.platform.builder.EntityCategories;
import kd.bos.formula.platform.builder.EntityCategory;
import kd.bos.formula.platform.builder.EntityPropInfo;
import kd.bos.formula.platform.engine.AliasTransformer;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

class TreeModelBOSEntities {
    private EntityCategories root = new EntityCategories();

    public EntityCategories getRoot() {
        return this.root;
    }

    public void setRoot(EntityCategories root) {
        this.root = root;
    }

    public void addEntity(String entityNumber, PropTreeBuildOption option) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            throw new IllegalArgumentException();
        }
        PropTreeBuildOption buildOption = option;
        if (buildOption == null) {
            buildOption = new PropTreeBuildOption();
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        TreeNode entityNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)buildOption);
        String billCaption = AliasTransformer.propTransform(mainType.getDisplayName().toString());
        EntityCategory category = new EntityCategory();
        category.setName(entityNumber);
        category.setCaption(billCaption);
        List<EntityPropInfo> propInfos = this.buildPropInfos(mainType, billCaption, entityNode.getChildren());
        for (EntityPropInfo propInfo : propInfos) {
            category.add(propInfo);
        }
        this.root.add(category);
    }

    public EntityPropInfo findEntityProp(String fullPropName) {
        return this.root.findEntityProp(fullPropName);
    }

    public TreeNode build() {
        return this.root.buildEntityTree(null);
    }

    private List<EntityPropInfo> buildPropInfos(MainEntityType mainType, String billCaption, List<TreeNode> nodes) {
        ArrayList<EntityPropInfo> propInfos = new ArrayList<EntityPropInfo>(32);
        if (nodes == null || nodes.isEmpty()) {
            return propInfos;
        }
        for (TreeNode node : nodes) {
            String propName = node.getId();
            EntityPropInfo propInfo = new EntityPropInfo();
            propInfo.setPropName(propName);
            propInfo.setPropCaption(node.getText());
            this.buildPropFullName(mainType, billCaption, propInfo);
            List<EntityPropInfo> childProps = this.buildPropInfos(mainType, billCaption, node.getChildren());
            for (EntityPropInfo childProp : childProps) {
                propInfo.add(childProp);
            }
            propInfos.add(propInfo);
        }
        return propInfos;
    }

    private void buildPropFullName(MainEntityType mainType, String billCaption, EntityPropInfo propInfo) {
        String propName = propInfo.getPropName();
        String[] keyItems = StringUtils.split((String)propName, (String)"\\.");
        IDataEntityProperty property = mainType.findProperty(keyItems[0]);
        if (property == null && mainType.getProperties().containsKey((Object)keyItems[0])) {
            property = (IDataEntityProperty)mainType.getProperties().get((Object)keyItems[0]);
        }
        if (property == null) {
            propInfo.setFullPropName(mainType.getName() + "." + propName);
            propInfo.setVirtualProp(true);
            return;
        }
        ArrayList<String> propNames = new ArrayList<String>(Arrays.asList(keyItems));
        String fullPropName = propName;
        String fullPropCaption = "";
        Object[] propCaptions = StringUtils.split((String)propInfo.getPropCaption(), (String)"\\.");
        for (int i = 0; i < propCaptions.length; ++i) {
            propCaptions[i] = AliasTransformer.propTransform((String)propCaptions[i]);
        }
        String propCaption = StringUtils.join((Object[])propCaptions, (String)".");
        if (property.getParent() instanceof SubEntryType) {
            SubEntryType subEntryType = (SubEntryType)property.getParent();
            fullPropName = mainType.getName() + "." + subEntryType.getParent().getName() + "." + subEntryType.getName() + "." + StringUtils.join((Object[])propNames.toArray(), (String)".");
            fullPropCaption = billCaption + "." + AliasTransformer.propTransform(subEntryType.getParent().getDisplayName().toString()) + "." + AliasTransformer.propTransform(subEntryType.getDisplayName().toString()) + "." + propCaption;
        } else if (property.getParent() instanceof EntryType) {
            fullPropName = mainType.getName() + "." + property.getParent().getName() + "." + StringUtils.join((Object[])propNames.toArray(), (String)".");
            fullPropCaption = billCaption + "." + AliasTransformer.propTransform(property.getParent().getDisplayName().toString()) + "." + propCaption;
        } else {
            fullPropName = mainType.getName() + "." + propName;
            fullPropCaption = billCaption + "." + propCaption;
        }
        propInfo.setFullPropName(fullPropName);
        propInfo.setFullPropCaption(fullPropCaption);
    }
}

