/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.kscript.IObjectLoaderProvider;
import kd.bos.kscript.dom.expr.PropertyExpr;
import kd.bos.kscript.runtime.InterpreterException;

class DynamicObjectLoaderProvider
implements IObjectLoaderProvider {
    private Map paramCtx;
    private Object context;

    DynamicObjectLoaderProvider() {
    }

    public Map getParamCtx() {
        return this.paramCtx;
    }

    public void setParamCtx(Map paramCtx) {
        this.paramCtx = paramCtx;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public Object getContext() {
        return this.context;
    }

    public boolean isBOSContext(Object context) {
        return false;
    }

    public boolean isObjectCollection(Object value) {
        return value instanceof Collection;
    }

    public boolean isObjectValue(Object value) {
        if (value instanceof DynamicObject) {
            return true;
        }
        if (value instanceof Collection) {
            Collection rows = (Collection)value;
            if (rows.isEmpty()) {
                return false;
            }
            return rows.iterator().next() instanceof DynamicObject;
        }
        return false;
    }

    public boolean isObjectPK(Object value) {
        return false;
    }

    public Object getObjectCollectionChildByIndex(Object objs, int idx) {
        if (this.getObjectCollectionSize(objs) > idx) {
            DynamicObjectCollection rows = (DynamicObjectCollection)objs;
            return rows.get(idx);
        }
        return null;
    }

    public Iterator getObjectCollectionIterator(Object objs) {
        if (this.isObjectCollection(objs)) {
            Collection rows = (Collection)objs;
            return rows.iterator();
        }
        return null;
    }

    public int getObjectCollectionSize(Object obj) {
        if (this.isObjectCollection(obj)) {
            Collection rows = (Collection)obj;
            return rows.size();
        }
        return 0;
    }

    public String getObjectValuePKField(Object obj) {
        if (obj instanceof DynamicObject) {
            DynamicObject activeRow = (DynamicObject)obj;
            Object pkValue = activeRow.getPkValue();
            if (pkValue == null) {
                return null;
            }
            return pkValue.toString();
        }
        return null;
    }

    public boolean isObjectValueContainPropName(Object obj, String propName) {
        Collection rows;
        Object item;
        DynamicObject activeRow = null;
        if (obj instanceof DynamicObject) {
            activeRow = (DynamicObject)obj;
        } else if (obj instanceof Collection && (item = (rows = (Collection)obj).iterator().next()) instanceof DynamicObject) {
            activeRow = (DynamicObject)item;
        }
        if (activeRow == null) {
            return false;
        }
        if (activeRow.getDataEntityType().getProperties().containsKey((Object)propName)) {
            return true;
        }
        DynamicObject parentRow = (DynamicObject)activeRow.getParent();
        for (int count = 0; parentRow != null && count < 10; parentRow = (DynamicObject)parentRow.getParent(), ++count) {
            if (!parentRow.getDataEntityType().getProperties().containsKey((Object)propName)) continue;
            return true;
        }
        return false;
    }

    public Object getObjectValuePropValueByName(Object obj, String propName) {
        Object item;
        DynamicObject activeRow = null;
        Collection rows = null;
        if (obj instanceof DynamicObject) {
            activeRow = (DynamicObject)obj;
        } else if (obj instanceof Collection && (item = (rows = (Collection)obj).iterator().next()) instanceof DynamicObject) {
            activeRow = (DynamicObject)item;
        }
        if (activeRow == null) {
            return null;
        }
        if (!activeRow.getDataEntityType().getProperties().containsKey((Object)propName)) {
            String activeEntityName = activeRow.getDataEntityType().getName();
            DynamicObject parentRow = (DynamicObject)activeRow.getParent();
            for (int count = 0; parentRow != null && count < 10; parentRow = (DynamicObject)parentRow.getParent(), ++count) {
                if (StringUtils.equals((CharSequence)activeEntityName, (CharSequence)propName)) {
                    return activeRow;
                }
                if (parentRow.getDataEntityType().getProperties().containsKey((Object)propName)) {
                    return parentRow.get(propName);
                }
                activeEntityName = parentRow.getDataEntityType().getName();
                activeRow = parentRow;
            }
            return null;
        }
        if (rows == null) {
            return this.getPropValue(activeRow, propName);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object row : rows) {
            if (!(row instanceof DynamicObject)) continue;
            Object value = ((DynamicObject)row).get(propName);
            if (value instanceof DynamicObjectCollection) {
                values.addAll((Collection<Object>)((DynamicObjectCollection)value));
                continue;
            }
            values.add(value);
        }
        return values;
    }

    private Object getPropValue(DynamicObject activeRow, String propName) {
        if (this.getParamCtx() == null) {
            return activeRow.get(propName);
        }
        String varName = propName;
        for (IDataEntityType dt = activeRow.getDataEntityType(); dt != null; dt = dt.getParent()) {
            varName = dt.getName() + "." + varName;
        }
        if (this.getParamCtx().containsKey(varName)) {
            return this.getParamCtx().get(varName);
        }
        return activeRow.get(propName);
    }

    public void setObjectValuePropValue(Object obj, String propName, Object value) {
        if (this.isObjectValueContainPropName(obj, propName)) {
            DynamicObject activeRow = (DynamicObject)obj;
            activeRow.set(propName, value);
        }
    }

    public boolean lazyLoadFillValue(Object obj) throws InterpreterException {
        return false;
    }

    public Object lazyLoadGetProperty(Object obj, String propName, PropertyExpr fullPropName) throws InterpreterException {
        return null;
    }
}

