/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.formula.platform.api.IVarInfo;
import kd.bos.formula.platform.engine.BOSEntityHelper;
import kd.bos.formula.platform.engine.IKScriptTransformer;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.Token;
import kd.bos.kscript.parser.TokenList;

class EnumTransformer
implements IKScriptTransformer {
    private Vector varList;
    private HashMap boMap;

    public EnumTransformer(Vector varList) {
        this.varList = varList;
        this.boMap = new HashMap();
    }

    public void addEntityTypes(MainEntityType[] entityTypes) {
        for (int i = 0; i < entityTypes.length; ++i) {
            MainEntityType entity = entityTypes[i];
            this.boMap.put(entity.getName(), entity);
        }
    }

    @Override
    public TokenList transform(TokenList tokenList) throws ParserException {
        return this.transform(tokenList, false);
    }

    @Override
    public TokenList reverseTransform(TokenList tokenList) throws ParserException {
        return this.transform(tokenList, true);
    }

    private TokenList transform(TokenList tokenList, boolean toAlias) throws ParserException {
        int index = 0;
        while (true) {
            boolean match = false;
            IVarInfo varinfo2 = null;
            Token k = tokenList.lookup(index);
            if (k == null || k.type == 12) break;
            if (k.type == 1) {
                if (index > 0 && tokenList.lookup(index - 1).equals(Token.PeriodToken)) {
                    ++index;
                    continue;
                }
                if (this.varList != null) {
                    for (IVarInfo varinfo2 : this.varList) {
                        String varName = varinfo2.getVarName();
                        if (!varName.equals(k.value)) continue;
                        match = true;
                        break;
                    }
                }
            }
            if (match) {
                StringBuilder propertyName = new StringBuilder();
                StringBuilder property = new StringBuilder();
                if (varinfo2 != null) {
                    property.append(varinfo2.getVarName());
                }
                int start = index;
                while (true) {
                    Token t1 = tokenList.lookup(start + 1);
                    Token t2 = tokenList.lookup(start + 2);
                    if (!t1.equals(Token.PeriodToken)) break;
                    if (start != index) {
                        propertyName.append(".");
                    } else {
                        property.append(".");
                    }
                    ++start;
                    if (t2.type != 1) break;
                    propertyName.append(t2.value);
                    ++start;
                }
                EntityType entityType = this.findEntityType(varinfo2);
                ComboProp prop = this.getComboProperty(entityType, propertyName.toString());
                index = start + 1;
                Token next = tokenList.lookup(index);
                if ((Token.EqualToken.equals(next) || Token.NotEqualToken.equals(next)) && prop != null) {
                    Token nextnext = tokenList.lookup(index + 1);
                    if (toAlias) {
                        this.replaceEnumAliasWhenPossible(nextnext, prop);
                    } else {
                        this.replaceEnumWhenPossible(nextnext, prop);
                    }
                }
                index += 2;
                continue;
            }
            ++index;
        }
        return tokenList;
    }

    private void replaceEnumWhenPossible(Token token, ComboProp prop) {
        if (token != null && token.type == 1) {
            if (prop instanceof BillStatusProp) {
                for (BillStatusProp.StatusItemPro item : ((BillStatusProp)prop).getStatusItems()) {
                    if (item.getStatusName() == null || !StringUtils.equalsIgnoreCase((CharSequence)token.value, (CharSequence)item.getStatusName().toString())) continue;
                    token.value = item.getStatusKey();
                }
            } else {
                for (ValueMapItem item : prop.getComboItems()) {
                    if (item.getName() == null || !StringUtils.equalsIgnoreCase((CharSequence)token.value, (CharSequence)item.getName().toString())) continue;
                    token.value = item.getValue();
                }
            }
            token.type = 6;
        }
    }

    private void replaceEnumAliasWhenPossible(Token token, ComboProp prop) {
        String alias;
        if (token != null && StringUtils.isNotBlank((CharSequence)(alias = prop.getItemByName(token.value)))) {
            token.value = alias;
            token.type = 1;
        }
    }

    private EntityType findEntityType(IVarInfo var) {
        if (var != null && !EnumTransformer.isSimapleType(var)) {
            String voFullName = var.getVarName();
            for (EntityType entity : this.boMap.values()) {
                if (!entity.getName().equals(voFullName)) continue;
                return entity;
            }
        }
        return null;
    }

    private static boolean isSimapleType(IVarInfo var) {
        return var.getVarType().equals("BIGDECIMAL") || var.getVarType().equals("BOOLEAN") || var.getVarType().equals("DATE") || var.getVarType().equals("DOUBLE") || var.getVarType().equals("INT") || var.getVarType().equals("LONG") || var.getVarType().equals("STRING");
    }

    private static int convertEnum(TokenList tokenList, int pos, String enumValue) throws ParserException {
        StringBuilder sb = new StringBuilder();
        if (pos > 0) {
            Token opToken = tokenList.lookup(pos - 1);
            if (opToken.equals(Token.EqualToken)) {
                sb.append(".equals('").append(enumValue).append("')");
                Lexer _lexer = new Lexer(sb.toString());
                TokenList _tokenList = new TokenList(_lexer);
                return EnumTransformer.replaceTokens(tokenList, _tokenList, pos - 1, pos);
            }
            if (opToken.equals(Token.NotEqualToken)) {
                int head = EnumTransformer.findOpHead(tokenList, pos - 1);
                tokenList.insert(head, Token.NotToken);
                sb.append(".equals('").append(enumValue).append("')");
                Lexer _lexer = new Lexer(sb.toString());
                TokenList _tokenList = new TokenList(_lexer);
                return EnumTransformer.replaceTokens(tokenList, _tokenList, pos - 1 + 1, pos + 1);
            }
            sb.append("'").append(enumValue).append("'");
            Lexer _lexer = new Lexer(sb.toString());
            TokenList _tokenList = new TokenList(_lexer);
            return EnumTransformer.replaceTokens(tokenList, _tokenList, pos, pos);
        }
        return pos;
    }

    static int findOpHead(TokenList tokenList, int opPos) throws ParserException {
        int i;
        int braceDep = 0;
        for (i = opPos - 1; i > 0; --i) {
            Token __t;
            Token _t = tokenList.lookup(i);
            if (_t == null) continue;
            if (_t.equals(Token.CloseBraceToken)) {
                ++braceDep;
                continue;
            }
            if (_t.equals(Token.OpenBraceToken)) {
                --braceDep;
                continue;
            }
            if (_t.type != 1 || braceDep != 0 || i <= 0 || (__t = tokenList.lookup(i - 1)) == null || __t.equals(Token.PeriodToken)) continue;
            return i - 1;
        }
        return i;
    }

    private static int replaceTokens(TokenList tokenList, TokenList insert, int start, int end) throws ParserException {
        Token first = tokenList.lookup(start);
        Token k = insert.lookup(0);
        first.type = k.type;
        first.value = k.value;
        for (int i = start + 1; i <= end; ++i) {
            tokenList.remove(start);
        }
        ++start;
        int index = 1;
        while (true) {
            k = insert.lookup(index++);
            if (k.type == 12) break;
            tokenList.insert(start++, k);
        }
        return start;
    }

    private ComboProp getComboProperty(EntityType entityType, String key) {
        if (entityType == null || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        List<DynamicProperty> props = BOSEntityHelper.findPropertys(entityType, key);
        if (props.isEmpty()) {
            return null;
        }
        if (props.get(props.size() - 1) instanceof ComboProp) {
            return (ComboProp)props.get(props.size() - 1);
        }
        return null;
    }
}

