/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.engine;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.formula.platform.api.BaseFormulaFunctions;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.api.IFormulaVarInfos;
import kd.bos.formula.platform.api.IVarInfo;
import kd.bos.formula.platform.engine.DynamicObjectLoaderProvider;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.kscript.IObjectLoaderProvider;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.runtime.Interpreter;
import kd.bos.kscript.runtime.InterpreterException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormulaEngine {
    public static Object runFormula(String formulaStr, Map paramCtx) throws RunFormulaException {
        Interpreter interpreter = new Interpreter();
        return FormulaEngine.runFormula(interpreter, formulaStr, paramCtx);
    }

    public static Object runFormula(String formulaStr, Object[] params) throws RunFormulaException {
        if (formulaStr == null) {
            throw new RunFormulaException("Formula string couldn't be null.");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        IVarInfo[] varInfos = IFormulaVarInfos.get().getFormulaVars(formulaStr);
        int paramIdx = 0;
        if (varInfos != null && params != null) {
            for (int i = 0; i < varInfos.length; ++i) {
                if (!"in".equals(varInfos[i].getVarScope())) continue;
                if (params.length <= paramIdx) break;
                paramMap.put(varInfos[i].getVarName(), params[i]);
                ++paramIdx;
            }
        }
        return FormulaEngine.runFormula(formulaStr, paramMap);
    }

    public static Object runFormula(Interpreter interpreter, String formulaStr, Map paramCtx) throws RunFormulaException {
        if (formulaStr == null) {
            throw new RunFormulaException("Formula string couldn't be null.");
        }
        Object rtnValue = null;
        DynamicObjectLoaderProvider objectLoaderProvider = new DynamicObjectLoaderProvider();
        objectLoaderProvider.setParamCtx(paramCtx);
        interpreter.setBizObjectProvider((IObjectLoaderProvider)objectLoaderProvider);
        try {
            rtnValue = interpreter.evalForMultiPass(formulaStr, paramCtx);
        }
        catch (InterpreterException e) {
            throw new RunFormulaException(e);
        }
        catch (ParserException e) {
            throw new RunFormulaException(e);
        }
        return rtnValue;
    }

    public static void registerFunctions(IFormulaFunctions functions) {
        if (functions == null) {
            return;
        }
        Interpreter.publicFuncProviderList.add(functions);
    }

    public static int getIntValue(Object obj) throws ClassCastException {
        return (Integer)obj;
    }

    public static byte getByteValue(Object obj) throws ClassCastException {
        return (Byte)obj;
    }

    public static short getShortValue(Object obj) throws ClassCastException {
        return (Short)obj;
    }

    public static char getCharValue(Object obj) throws ClassCastException {
        return ((Character)obj).charValue();
    }

    public static long getLongValue(Object obj) throws ClassCastException {
        return (Long)obj;
    }

    public static float getFloatValue(Object obj) throws ClassCastException {
        return ((Float)obj).floatValue();
    }

    public static double getDoubleValue(Object obj) throws ClassCastException {
        return (Double)obj;
    }

    public static boolean getBooleanValue(Object obj) throws ClassCastException {
        return (Boolean)obj;
    }

    public static BigDecimal getBigDecmialValue(Object obj) throws ClassCastException {
        return (BigDecimal)obj;
    }

    static {
        FormulaEngine.registerFunctions(new BaseFormulaFunctions());
    }
}

