/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.engine;

import java.util.Vector;
import kd.bos.entity.MainEntityType;
import kd.bos.formula.platform.builder.FormulaUtils;
import kd.bos.formula.platform.engine.BOSObjectTransformer;
import kd.bos.formula.platform.engine.EnumTransformer;
import kd.bos.formula.platform.engine.IfThenTransformer;
import kd.bos.formula.platform.engine.KeyWordTransformer;
import kd.bos.formula.platform.engine.ValidateResult;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.parser.KScriptParser;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.TokenList;

public class FormulaTransformer {
    private KeyWordTransformer keyWordTransformer = new KeyWordTransformer();
    private IfThenTransformer ifThenTransformer = new IfThenTransformer();
    private BOSObjectTransformer bosObjectTransformer;
    private EnumTransformer enumTransformer;

    public FormulaTransformer(Vector varList, Vector enumList) {
        this.bosObjectTransformer = new BOSObjectTransformer(varList, enumList);
        this.enumTransformer = new EnumTransformer(varList);
    }

    public FormulaTransformer() {
        this(null, null);
    }

    public void addEntityTypes(MainEntityType[] entityTypes) {
        this.bosObjectTransformer.addEntityTypes(entityTypes);
        this.enumTransformer.addEntityTypes(entityTypes);
    }

    public TokenList transformeToken(String formulaString) throws ParserException {
        Lexer lexer = new Lexer(formulaString);
        TokenList _tokenList = new TokenList(lexer);
        _tokenList = this.keyWordTransformer.transform(_tokenList);
        _tokenList = this.ifThenTransformer.transform(_tokenList);
        _tokenList = this.bosObjectTransformer.transform(_tokenList);
        _tokenList = this.enumTransformer.transform(_tokenList);
        return _tokenList;
    }

    public String reverseTransform(String script) throws ParserException {
        Lexer lexer = new Lexer(script);
        TokenList _tokenList = new TokenList(lexer);
        this.keyWordTransformer.fixSpace(_tokenList);
        _tokenList = this.enumTransformer.reverseTransform(_tokenList);
        this.keyWordTransformer.fixSpace(_tokenList);
        _tokenList = this.bosObjectTransformer.reverseTransform(_tokenList);
        this.keyWordTransformer.fixSpace(_tokenList);
        _tokenList = this.keyWordTransformer.reverseTransform(_tokenList);
        this.keyWordTransformer.fixSpace(_tokenList);
        return FormulaUtils.printTokenList(_tokenList);
    }

    public String transforme(String formulaString) throws ParserException {
        return FormulaUtils.printTokenList(this.transformeToken(formulaString));
    }

    public ValidateResult validate(String formulaString) {
        ValidateResult re = new ValidateResult();
        try {
            String script = this.transforme(formulaString);
            KScriptParser parser = new KScriptParser(script);
            parser.parse();
            return re;
        }
        catch (ParserException e) {
            re.success = false;
            re.errorMsg = e.getMessage();
            return re;
        }
    }

    public boolean scriptIsFormula(String script, String formulaString) throws ParserException {
        Lexer lexer = new Lexer(script);
        TokenList _scriptTokenList = new TokenList(lexer);
        TokenList _scriptTokenList1 = this.transformeToken(formulaString);
        return FormulaUtils.tokenListEquals(_scriptTokenList, _scriptTokenList1);
    }
}

