/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class EnvConfigurationUtil {
    @KSMethod
    public static boolean isPurePlatform() {
        String enableBlackList = System.getProperty("kd.pureplatform.enableblacklist", "true");
        if ("false".equals(enableBlackList)) {
            return false;
        }
        String isPurePlat = (String)EnvConfigurationUtil.getLocalCache().get("isPurePlatform");
        if (StringUtils.isBlank((CharSequence)isPurePlat)) {
            isPurePlat = (String)EnvConfigurationUtil.getCache().get(CacheKeyUtil.getAcctId() + "_isPurePlatform");
            if (StringUtils.isBlank((CharSequence)isPurePlat)) {
                isPurePlat = EnvConfigurationUtil.getPurePlatformParam();
                EnvConfigurationUtil.getCache().put(CacheKeyUtil.getAcctId() + "_isPurePlatform", (Object)isPurePlat, 3600);
            }
            EnvConfigurationUtil.getLocalCache().put("isPurePlatform", (Object)isPurePlat);
        }
        return "true".equals(isPurePlat);
    }

    private static String getPurePlatformParam() {
        String isPurePlat = System.getProperty("env.ispureplatform");
        if (StringUtils.isNotBlank((CharSequence)isPurePlat)) {
            return isPurePlat;
        }
        isPurePlat = (String)DB.query((DBRoute)DBRoute.base, (String)"select fvalue from t_svc_customparam where fnumber = 'kd_ispureplatform'", rs -> {
            String val;
            if (rs.next() && "true".equals(val = rs.getString(1))) {
                return "true";
            }
            return "false";
        });
        return isPurePlat;
    }

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(86400);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "kd_bos_entitymeta", info);
    }

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("KD_APPMETA", new DistributeCacheHAPolicy());
    }
}

