/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetaRedisCacheUtils;
import kd.bos.entity.AppMetadataLocalCache;
import kd.bos.entity.DebugLog;
import kd.bos.entity.EntityMetadataProvider;
import kd.bos.entity.IEntityMetaDataProvider;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.sharemeta.ShareMetaUtil;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class AppMetadataCache {
    private static final String REGEX = "[a-z]";
    static Log logger = LogFactory.getLog(AppMetadataCache.class);
    private static IEntityMetaDataProvider provider;

    public static IEntityMetaDataProvider getProvider() {
        if (provider == null) {
            provider = ShareMetaUtil.enableShareMeta() ? ShareMetaUtil.getEntityMetaDataProvider() : new EntityMetadataProvider();
        }
        return provider;
    }

    public static void setProvider(IEntityMetaDataProvider pro) {
        provider = pro;
    }

    public static String getAppNumberById(String id) {
        return AppMetadataCache.getProvider().getAppNumberById(id);
    }

    public static AppInfo getAppInfoByNumber(String number) {
        AppInfo appInfo = AppMetadataLocalCache.getAppInfo(number);
        if (appInfo != null) {
            return appInfo;
        }
        appInfo = AppMetadataCache.getProvider().getAppInfo(number);
        if (appInfo != null) {
            AppMetadataLocalCache.putAppInfo(number, appInfo);
        }
        return appInfo;
    }

    public static Map<String, AppInfo> getAllAppInfo() {
        Map<String, AppInfo> appInfoMap = AppMetadataLocalCache.getAllAppInfo();
        if (appInfoMap == null || appInfoMap.isEmpty()) {
            MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
            Map appInfos = metadataService.loadAllAppInfo();
            if (CollectionUtils.isEmpty((Map)appInfos)) {
                return new LinkedHashMap<String, AppInfo>(0);
            }
            appInfoMap = new LinkedHashMap<String, AppInfo>(appInfos.size());
            for (Map.Entry entry : appInfos.entrySet()) {
                AppInfo appInfo = (AppInfo)SerializationUtils.fromJsonString((String)((String)entry.getValue()), AppInfo.class);
                appInfoMap.put((String)entry.getKey(), appInfo);
            }
            AppMetadataLocalCache.putAllAppInfo(appInfoMap);
        }
        return appInfoMap;
    }

    public static Map<String, AppInfo> getVisibleAndEnableAppInfos() {
        Map<String, AppInfo> allAppInfo = AppMetadataCache.getAllAppInfo();
        HashMap<String, AppInfo> appInfoMap = new HashMap<String, AppInfo>(allAppInfo.size());
        for (Map.Entry<String, AppInfo> entry : allAppInfo.entrySet()) {
            AppInfo appInfo = entry.getValue();
            if (!"2".equals(appInfo.getDeployStatus()) || !appInfo.isVisible()) continue;
            appInfoMap.put(entry.getKey(), appInfo);
        }
        return appInfoMap;
    }

    public static AppInfo getAppInfo(String appId) {
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            String number;
            Pattern pattern = Pattern.compile(REGEX);
            Matcher matcher = pattern.matcher(appId);
            if ((appId.length() > 10 || !matcher.find()) && StringUtils.isNotBlank((CharSequence)(number = AppMetadataCache.getAppNumberById(appId)))) {
                appId = number;
            }
        }
        return AppMetadataCache.getAppInfoByNumber(appId);
    }

    public static AppMenuInfo getAppMenuInfo(String appId, String menuId) {
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            String number;
            Pattern pattern = Pattern.compile(REGEX);
            Matcher matcher = pattern.matcher(appId);
            if ((appId.length() > 10 || !matcher.find()) && StringUtils.isNotBlank((CharSequence)(number = AppMetadataCache.getAppNumberById(appId)))) {
                appId = number;
            }
        }
        return AppMetadataCache.getAppMenuInfoByAppNumAndMenuId(appId, menuId);
    }

    public static AppMenuInfo getAppMenuInfoByAppNumAndMenuId(String appNum, String menuId) {
        AppMenuInfo menuInfo = AppMetadataLocalCache.getAppMenuInfo(appNum, menuId);
        if (menuInfo != null) {
            return menuInfo;
        }
        List<AppMenuInfo> menus = AppMetadataCache.getProvider().getAppMenusInfoByAppId(appNum);
        if (menus != null) {
            AppMetadataLocalCache.putAppMenusInfo(appNum, menus);
            menuInfo = AppMetadataLocalCache.getAppMenuInfo(appNum, menuId);
        }
        return menuInfo;
    }

    public static List<AppMenuInfo> getAppMenusInfoByAppId(String appId) {
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            String number;
            Pattern pattern = Pattern.compile(REGEX);
            Matcher matcher = pattern.matcher(appId);
            if ((appId.length() > 10 || !matcher.find()) && StringUtils.isNotBlank((CharSequence)(number = AppMetadataCache.getAppNumberById(appId)))) {
                appId = number;
            }
        }
        return AppMetadataCache.getAppMenusInfoByAppNum(appId);
    }

    public static List<AppMenuInfo> getAppMenusInfoByAppNum(String appNum) {
        List<AppMenuInfo> menus = AppMetadataLocalCache.getAppMenusInfoByAppId(appNum);
        if (menus != null) {
            return menus;
        }
        menus = AppMetadataCache.getProvider().getAppMenusInfoByAppId(appNum);
        if (menus != null) {
            AppMetadataLocalCache.putAppMenusInfo(appNum, menus);
        }
        return menus;
    }

    public static Map<String, List<AppMenuInfo>> getAllAppMenus() {
        Map<String, List<AppMenuInfo>> menus = AppMetadataLocalCache.getAllAppMenusInfo();
        if (menus != null) {
            return menus;
        }
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        Map appMenusInfos = metadataService.loadAllAppMenusInfo();
        if (CollectionUtils.isEmpty((Map)appMenusInfos)) {
            menus = new LinkedHashMap<String, List<AppMenuInfo>>(0);
        } else {
            menus = new LinkedHashMap<String, List<AppMenuInfo>>(appMenusInfos.size());
            for (Map.Entry entry : appMenusInfos.entrySet()) {
                List appMenusInfo = SerializationUtils.fromJsonStringToList((String)((String)entry.getValue()), AppMenuInfo.class);
                menus.put((String)entry.getKey(), appMenusInfo);
            }
        }
        AppMetadataLocalCache.putAllAppMenusInfo(menus);
        return menus;
    }

    public static Map<String, String> getAppNumbers() {
        LinkedHashMap<String, String> idNumberMap = AppMetadataLocalCache.getAppNumbers();
        if (idNumberMap != null) {
            return idNumberMap;
        }
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        LinkedHashMap<String, String> map = metadataService.getAppNumbers();
        idNumberMap = CollectionUtils.isEmpty((Map)map) ? new LinkedHashMap<String, String>(0) : map;
        AppMetadataLocalCache.putAppNumbers((Map<String, String>)idNumberMap);
        return idNumberMap;
    }

    public static void removeCache() {
        AppMetadataLocalCache.clear();
        AppMetaRedisCacheUtils.clearAppCache();
        AppMetaRedisCacheUtils.clearMenuCache();
        AppMetaRedisCacheUtils.clearNumberCache();
        DebugLog debugLog = new DebugLog(AppMetadataCache.class.getName());
        debugLog.info("removeCache", "App cache is removed.");
    }

    public static void removeAppmetaLocalCache(String appId) {
        AppMetadataLocalCache.remove(appId);
    }

    public static void removeAppmetaLocalCache(String ... appIds) {
        AppMetadataLocalCache.remove(appIds);
    }
}

