/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.EhcacheStoreType;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataLocalCache;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.sharemeta.ShareMetaUtil;

public class EntityMetadataLocalDiskCache {
    private static final CacheConfigInfo info;
    private static boolean enableLocalDiskCache;
    private static final String LOCALDISKCACHE_MAXMEMSIZE = "meta.localdiskcache.entity.maxmemsize";
    private static final String LOCALDISKCACHE_TIMEOUT = "meta.localdiskcache.entity.timeout";
    private static int configDiskMaxMemSize;
    private static int configDiskTimeout;
    private static boolean mergeRegion;

    private static LocalMemoryCache getLocalDiskCache(String entitynumber) {
        String region = CacheKeyUtil.getAcctId();
        if (StringUtils.isNotBlank((CharSequence)entitynumber)) {
            region = ShareMetaUtil.getLocalCacheRegion(region, entitynumber);
        }
        if (mergeRegion) {
            region = "metadata";
        }
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "EntityMetadata", info, EhcacheStoreType.Disk);
    }

    public static boolean getLocalDiskCacheEnabled() {
        return enableLocalDiskCache;
    }

    static String get(RuntimeMetaType metaType, String number) {
        if (enableLocalDiskCache) {
            String key = EntityMetadataLocalDiskCache.makeCacheKey(metaType, number);
            return (String)EntityMetadataLocalDiskCache.getLocalDiskCache(number).get(key);
        }
        return null;
    }

    static void put(RuntimeMetaType metaType, String number, String val) {
        if (enableLocalDiskCache) {
            String key = EntityMetadataLocalDiskCache.makeCacheKey(metaType, number);
            EntityMetadataLocalDiskCache.getLocalDiskCache(number).put(key, (Object)val);
        }
    }

    private static String makeCacheKey(RuntimeMetaType type, String entitynumber) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return EntityMetadataLocalCache.makeCacheKey(appGroup, type, entitynumber);
    }

    static void remove(String appGroup, String entitynumber) {
        String key;
        if (!enableLocalDiskCache) {
            return;
        }
        LocalMemoryCache localCache = EntityMetadataLocalDiskCache.getLocalDiskCache(entitynumber);
        String[] keys = new String[RuntimeMetaType.values().length];
        int i = 0;
        for (RuntimeMetaType type : RuntimeMetaType.values()) {
            keys[i] = key = EntityMetadataLocalCache.makeCacheKey(appGroup, type, entitynumber);
            ++i;
        }
        localCache.remove(keys);
        key = EntityMetadataLocalCache.makeCacheKey(appGroup, RuntimeMetaType.Entity, entitynumber + ".ref");
        localCache.remove(new String[]{key});
    }

    static Object getThreadCache(String key) {
        return ThreadCache.get((Object)key);
    }

    static void putThreadCache(String key, Object dt) {
        ThreadCache.put((Object)key, (Object)dt);
    }

    static {
        String timeoutStr;
        enableLocalDiskCache = false;
        configDiskMaxMemSize = 3072;
        configDiskTimeout = 43200;
        mergeRegion = true;
        enableLocalDiskCache = Boolean.getBoolean("meta.localdiskcache.entity.enable");
        String itemSizeStr = System.getProperty(LOCALDISKCACHE_MAXMEMSIZE);
        if (StringUtils.isNotBlank((CharSequence)itemSizeStr)) {
            configDiskMaxMemSize = Integer.parseInt(itemSizeStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(timeoutStr = System.getProperty(LOCALDISKCACHE_TIMEOUT)))) {
            configDiskTimeout = Integer.parseInt(timeoutStr);
        }
        mergeRegion = Boolean.getBoolean("meta.localcache.mergeregion");
        boolean isTimeToLive = Boolean.getBoolean("meta.localcache.entity.istimetolive");
        info = new CacheConfigInfo();
        info.setTimeout(configDiskTimeout);
        info.setMaxMemSize(configDiskMaxMemSize);
        info.setTimeToLive(isTimeToLive);
    }
}

