/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class LayoutControlInfo
implements Serializable {
    private static final long serialVersionUID = -6011928040122520902L;
    private static Map<String, Integer> mapVis = new HashMap<String, Integer>(6);
    private static Map<String, Integer> mapLock = new HashMap<String, Integer>(5);
    private static String layoutSchemeOn = "layoutscheme.on";
    private static boolean enableLayoutScheme = false;
    private static String billLayoutOutLog;
    private static boolean enableOutLog;
    private String fieldKey;
    private String defValue;
    private int visible;
    private int lock;
    private boolean mustInput;
    private String fieldName;
    private String fieldType;
    private String fieldId;
    private String entityFieldKey;
    private int defValueType;
    private int mustInputType;

    public static boolean isBillTypeLayout() {
        return !enableLayoutScheme;
    }

    public static boolean isOutLog() {
        return enableOutLog;
    }

    public int getMustInputType() {
        return this.mustInputType;
    }

    public void setMustInputType(int mustInputType) {
        this.mustInputType = mustInputType;
    }

    public int getDefValueType() {
        return this.defValueType;
    }

    public void setDefValueType(int defValueType) {
        this.defValueType = defValueType;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    public int getVisible() {
        return this.visible;
    }

    public void setVisible(int visible) {
        this.visible = visible;
    }

    public int getLock() {
        return this.lock;
    }

    public void setLock(int lock) {
        this.lock = lock;
    }

    public void setLockInStr(String lock) {
        if (StringUtils.isBlank((CharSequence)lock)) {
            this.lock = 0;
            return;
        }
        String[] vs = lock.split(",");
        int ret = 0;
        for (String v : vs) {
            ret |= mapLock.get(v).intValue();
        }
        this.lock = ret;
    }

    public boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean mustInput) {
        this.mustInput = mustInput;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public boolean isLock(String status) {
        if (mapLock.containsKey(status) && mapLock.get(status) != null) {
            return (mapLock.get(status) & this.lock) != 0;
        }
        return false;
    }

    public boolean isVisible(String status) {
        if (mapVis.containsKey(status) && mapVis.get(status) != null) {
            return (mapVis.get(status) & this.visible) != 0;
        }
        return true;
    }

    public int hashCode() {
        return this.fieldKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutControlInfo) {
            LayoutControlInfo info = (LayoutControlInfo)obj;
            return Objects.equals(info.getFieldKey(), this.fieldKey);
        }
        return false;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getEntityFieldKey() {
        return this.entityFieldKey;
    }

    public void setEntityFieldKey(String entityFieldKey) {
        this.entityFieldKey = entityFieldKey;
    }

    static {
        enableLayoutScheme = Boolean.parseBoolean(System.getProperty(layoutSchemeOn));
        ConfigurationUtil.observeChange((String)layoutSchemeOn, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                enableLayoutScheme = Boolean.parseBoolean(System.getProperty(layoutSchemeOn));
            }
        });
        billLayoutOutLog = "bill.layout.outlog";
        enableOutLog = false;
        enableOutLog = Boolean.parseBoolean(System.getProperty(billLayoutOutLog));
        ConfigurationUtil.observeChange((String)billLayoutOutLog, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                enableOutLog = Boolean.parseBoolean(System.getProperty(billLayoutOutLog));
            }
        });
        mapVis.put("new", 1);
        mapVis.put("edit", 2);
        mapVis.put("view", 4);
        mapVis.put("init", 8);
        mapVis.put("submit", 16);
        mapVis.put("audit", 32);
        mapLock.put("new", 1);
        mapLock.put("edit", 2);
        mapLock.put("view", 4);
        mapLock.put("submit", 16);
        mapLock.put("audit", 32);
    }
}

