/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class ParameterReaderHelper {
    private static Log log = LogFactory.getLog(ParameterReaderHelper.class);
    private static Class<?> parameterReaderClass;
    private static Method getBillParameterMethod;

    ParameterReaderHelper() {
    }

    private static void initEventServiceClass() {
        try {
            if (parameterReaderClass == null) {
                parameterReaderClass = Class.forName("kd.bos.param.ParameterReader");
                getBillParameterMethod = parameterReaderClass.getMethod("getBillParameter", String.class);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            log.warn("init ParameterReader error", (Throwable)ex);
        }
    }

    public static boolean getBillParameter(String entityTypeId) {
        if (getBillParameterMethod == null) {
            ParameterReaderHelper.initEventServiceClass();
        }
        if (getBillParameterMethod != null) {
            DynamicObject billParamterObj = null;
            try {
                billParamterObj = (DynamicObject)getBillParameterMethod.invoke(null, entityTypeId);
                if (billParamterObj != null && billParamterObj.getDataEntityType().getProperties().containsKey((Object)"saverecord")) {
                    return billParamterObj.getBoolean("saverecord");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

