/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QueryPlugInField;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySortField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.JoinQueryParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QueryEntityType
extends BasedataEntityType {
    private static final Log log = LogFactory.getLog(QueryEntityType.class);
    private static final long serialVersionUID = -7435459599028242792L;
    private static final String AND = " and ";
    private String entityName;
    private String entityAlias;
    private String editEntityAliasName;
    private List<JoinEntity> joinEntitys = new ArrayList<JoinEntity>();
    List<QuerySourceJoinRelation> queryRelations = new ArrayList<QuerySourceJoinRelation>();
    List<QSConditionRow> whereConditions = new ArrayList<QSConditionRow>();
    List<QuerySelectField> selectFields = new ArrayList<QuerySelectField>();
    List<QuerySortField> sortFields = new ArrayList<QuerySortField>();
    List<QueryPlugInField> queryPlugInFields = new ArrayList<QueryPlugInField>();

    @CollectionPropertyAttribute(collectionItemPropertyType=QuerySourceJoinRelation.class)
    public List<QuerySourceJoinRelation> getJoinRelations() {
        return this.queryRelations;
    }

    public void addQuerySourceJoinRelation(QuerySourceJoinRelation rel) {
        this.queryRelations.add(rel);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QSConditionRow.class)
    public List<QSConditionRow> getWhereConditions() {
        return this.whereConditions;
    }

    public void addWhereCondition(QSConditionRow qsConditionRow) {
        this.whereConditions.add(qsConditionRow);
    }

    @SimplePropertyAttribute
    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @SimplePropertyAttribute
    public String getEntityAlias() {
        return this.entityAlias;
    }

    public void setEntityAlias(String entityAlias) {
        this.entityAlias = entityAlias;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QueryPlugInField.class)
    public List<QueryPlugInField> getQueryPlugInFields() {
        return this.queryPlugInFields;
    }

    public void addQueryPlugInFields(QueryPlugInField queryPlugInField) {
        this.queryPlugInFields.add(queryPlugInField);
    }

    @SimplePropertyAttribute
    public String getEditEntityAliasName() {
        return this.editEntityAliasName;
    }

    public void setEditEntityAliasName(String editEntityAliasName) {
        this.editEntityAliasName = editEntityAliasName;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=JoinEntity.class)
    public List<JoinEntity> getJoinEntitys() {
        return this.joinEntitys;
    }

    public void setJoinEntitys(List<JoinEntity> joinEntitys) {
        this.joinEntitys = joinEntitys;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QuerySelectField.class)
    public List<QuerySelectField> getSelectFields() {
        return this.selectFields;
    }

    public void addSelectField(QuerySelectField selectField) {
        this.selectFields.add(selectField);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=QuerySortField.class)
    public List<QuerySortField> getQuerySortFields() {
        return this.sortFields;
    }

    public void addSelectField(QuerySortField selectField) {
        this.sortFields.add(selectField);
    }

    @Override
    public synchronized void endInit() {
        try {
            this.fillProperties();
        }
        catch (CloneNotSupportedException e) {
            log.info(e.getMessage());
        }
        super.endInit();
    }

    public MainEntityType getMainEntityType() {
        return EntityMetadataCache.getDataEntityType(this.getEntityName());
    }

    public List<MainEntityType> getAllJoinEntityType() {
        ArrayList<MainEntityType> list = new ArrayList<MainEntityType>(20);
        for (JoinEntity joinEntity : this.getJoinEntitys()) {
            list.add(EntityMetadataCache.getDataEntityType(joinEntity.getEntityName()));
        }
        return list;
    }

    public String getEditEntityName() {
        String editEntityName = null;
        if (this.editEntityAliasName.equals(this.getEntityAlias())) {
            editEntityName = this.getEntityName();
        } else {
            for (JoinEntity joinEntity : this.getJoinEntitys()) {
                if (!this.getEditEntityAliasName().equals(joinEntity.getAlias())) continue;
                editEntityName = joinEntity.getEntityName();
                break;
            }
        }
        return editEntityName;
    }

    public String getEntityNameByAlias(String entityAlias) {
        String entityName = null;
        for (JoinEntity joinEntity : this.getJoinEntitys()) {
            if (!entityAlias.equals(joinEntity.getAlias())) continue;
            entityName = joinEntity.getEntityName();
            break;
        }
        return entityName;
    }

    public List<QFilter> getQFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        return filters;
    }

    public DataSet getQueryDataSetByPK(QueryBuilder queryBuilder, List<QFilter> idFilters, String queryFileds, boolean isLimitCount) {
        JoinQueryParameter jqp = new JoinQueryParameter(this.getEntityName());
        List<QFilter> qFilterList = this.getFiltersExcludeEmptyCondition(idFilters);
        qFilterList.addAll(Arrays.asList(queryBuilder.getFilters()));
        String selectFields = this.reorgnizeQueryFields(queryFileds);
        jqp.select(selectFields);
        jqp.filter(qFilterList.toArray(new QFilter[0]));
        jqp.orderBy(queryBuilder.getOrderBys());
        if (isLimitCount) {
            jqp.start(queryBuilder.getStart()).limit(queryBuilder.getLimit());
        }
        this.assembleJoinQueryParameter(jqp);
        DataSet ds = ORM.create().queryJoinDataSet(this.getName(), jqp);
        return ds;
    }

    private List<QFilter> getFiltersExcludeEmptyCondition(List<QFilter> idFilters) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        for (QFilter qFilter : idFilters) {
            if (qFilter == null) continue;
            List qFilterNestList = qFilter.getNests(false);
            boolean isEmptyFilter = false;
            for (QFilter.QFilterNest qFilterNest : qFilterNestList) {
                if (!qFilterNest.getFilter().getProperty().endsWith(".id") || !(qFilterNest.getFilter().getValue() instanceof QEmptyValue)) continue;
                isEmptyFilter = true;
            }
            if (isEmptyFilter) continue;
            qFilterList.add(qFilter);
        }
        return qFilterList;
    }

    public int getQueryDataCount(QueryBuilder queryBuilder, String queryFileds) {
        return this.getQueryDataCount(queryFileds, queryBuilder.getFilters());
    }

    public DataSet getQueryDataSet(QueryBuilder queryBuilder, String queryFileds, boolean isLimitCount) {
        DataSet ds = this.getQueryDataSet(queryFileds, queryBuilder.getFilters(), queryBuilder.getOrderBys(), isLimitCount, queryBuilder.getStart(), queryBuilder.getLimit());
        return ds;
    }

    public int getQueryDataCount(String queryFileds, QFilter[] qFilters) {
        JoinQueryParameter jqp = new JoinQueryParameter(this.getEntityName());
        String selectFields = this.reorgnizeQueryFields(queryFileds);
        jqp.select(selectFields);
        jqp.filter(qFilters);
        this.assembleJoinQueryParameter(jqp);
        return ORM.create().queryJoinCount(this.getName(), jqp);
    }

    public DataSet getQueryDataSet(String queryFileds, QFilter[] qFilters, String orderBys) {
        return this.getQueryDataSet(queryFileds, qFilters, orderBys, false, 0, 0);
    }

    public DataSet getQueryDataSet(String queryFileds, QFilter[] qFilters, String orderBys, int start, int limit) {
        return this.getQueryDataSet(queryFileds, qFilters, orderBys, true, start, limit);
    }

    public DataSet getQueryDataSet(String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        JoinQueryParameter jqp = new JoinQueryParameter(this.getEntityName());
        String selectFields = this.reorgnizeQueryFields(queryFileds);
        jqp.select(selectFields);
        jqp.filter(qFilters);
        jqp.orderBy(orderBys);
        if (isLimitCount) {
            jqp.start(start).limit(limit);
        }
        this.assembleJoinQueryParameter(jqp);
        DataSet ds = ORM.create().queryJoinDataSet(this.getName(), jqp);
        return ds;
    }

    private void assembleJoinQueryParameter(JoinQueryParameter jqp) {
        Map<String, List<QFilter>> joinOnMap = this.splitJoinOnCondition(jqp);
        for (QuerySourceJoinRelation rel : this.queryRelations) {
            ArrayList<Object> dateParamList = new ArrayList<Object>();
            List<QSConditionRow> rows = rel.getCondition();
            JoinQueryParameter.JoinQuery joinQuery = null;
            boolean isFirstConditionRow = true;
            StringBuffer andConditionBuffer = new StringBuffer();
            String joinEntityAlias = rel.getRelEntityNumber();
            for (QSConditionRow row : rows) {
                if (isFirstConditionRow && "=".equals(row.getCompareOp())) {
                    String joinEtityName = this.getEntityNameByAlias(rel.getRelEntityNumber());
                    joinQuery = new JoinQueryParameter.JoinQuery(joinEtityName);
                    joinQuery.joinEntityAlias(joinEntityAlias);
                    joinQuery.property(row.getLeftItem().toString());
                    String joinRightEntityAliasProp = row.getRightItem().toString().replaceFirst(joinEtityName + "\\.", joinEntityAlias + "\\.");
                    joinQuery.joinProperty(joinRightEntityAliasProp);
                    joinQuery.joinHint(ORMHint.JoinHint.LEFT);
                    jqp.addJoinQuery(joinQuery);
                    isFirstConditionRow = false;
                    continue;
                }
                this.assembleJoinOnCondition(jqp, dateParamList, andConditionBuffer, row, rel.getEntityNumber(), rel.getRelEntityNumber());
            }
            if (joinQuery == null) continue;
            if (joinOnMap.get(joinEntityAlias) != null) {
                String andCondString = this.assembleJoinOnCondition(joinOnMap, dateParamList, andConditionBuffer, joinEntityAlias);
                joinQuery.andExp(andCondString);
            }
            if (andConditionBuffer.length() > 0) {
                joinQuery.andExp(andConditionBuffer.toString());
            }
            if (dateParamList.size() > 0) {
                joinQuery.andExpParams(dateParamList.toArray());
                continue;
            }
            joinQuery.andExpParams(null);
        }
    }

    private void assembleJoinOnCondition(JoinQueryParameter jqp, List<Object> dataParamList, StringBuffer andConditionBuffer, QSConditionRow row, String etityAlias, String joinEntityAlias) {
        String joinPropName = row.getLeftItem().toString();
        joinPropName = joinPropName.startsWith(this.getEntityNameByAlias(joinEntityAlias)) ? joinPropName.replaceFirst(this.getEntityNameByAlias(joinEntityAlias) + "\\.", joinEntityAlias + "\\.") : etityAlias + "." + row.getLeftItem().toString();
        String compareOp = row.getCompareOp();
        String rightItem = row.getRightItem().toString().replaceFirst(this.getEntityNameByAlias(joinEntityAlias) + "\\.", joinEntityAlias + "\\.");
        if (compareOp.equals("like") || compareOp.equals("not like")) {
            compareOp = " " + compareOp + " ";
            rightItem = rightItem.substring(0, rightItem.length() - 1) + "%'";
        } else if (compareOp.equals("in") || compareOp.equals("not in")) {
            compareOp = " " + compareOp + " ";
            rightItem = "(" + rightItem + ")";
        }
        if (andConditionBuffer.length() == 0) {
            Object[] joinOnParam = this.getJoinOnFilterValue(row);
            if (Objects.nonNull(joinOnParam[0])) {
                andConditionBuffer.append(joinPropName).append(compareOp).append("(");
                for (int i = 0; i < joinOnParam.length; ++i) {
                    andConditionBuffer.append("?").append(",");
                    dataParamList.add(joinOnParam[i]);
                }
                andConditionBuffer.deleteCharAt(andConditionBuffer.length() - 1);
                andConditionBuffer.append(")");
            } else {
                andConditionBuffer.append(joinPropName).append(compareOp).append(rightItem);
            }
        } else {
            andConditionBuffer.append(AND);
            Object[] joinOnParam = this.getJoinOnFilterValue(row);
            if (Objects.nonNull(joinOnParam[0])) {
                andConditionBuffer.append(joinPropName).append(compareOp).append("(");
                for (int i = 0; i < joinOnParam.length; ++i) {
                    andConditionBuffer.append("?").append(",");
                    dataParamList.add(joinOnParam[i]);
                }
                andConditionBuffer.deleteCharAt(andConditionBuffer.length() - 1);
                andConditionBuffer.append(")");
            } else {
                andConditionBuffer.append(joinPropName).append(compareOp).append(rightItem);
            }
        }
    }

    private Map<String, List<QFilter>> splitJoinOnCondition(JoinQueryParameter jqp) {
        QFilter[] qFilterArray = jqp.getFilter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        HashMap<String, List<QFilter>> joinOnMap = new HashMap<String, List<QFilter>>();
        for (QFilter qFilter : qFilterArray) {
            if (qFilter != null && !StringUtils.isEmpty((String)qFilter.getJoinEntityPath())) {
                List<QFilter> joinFilterList;
                if (joinOnMap.get(qFilter.getJoinEntityPath()) == null) {
                    joinFilterList = new ArrayList<QFilter>();
                    joinFilterList.add(qFilter);
                    joinOnMap.put(qFilter.getJoinEntityPath(), joinFilterList);
                    continue;
                }
                joinFilterList = (List)joinOnMap.get(qFilter.getJoinEntityPath());
                joinFilterList.add(qFilter);
                continue;
            }
            qFilterList.add(qFilter);
        }
        jqp.filter(qFilterList.toArray(new QFilter[qFilterList.size()]));
        return joinOnMap;
    }

    private String assembleJoinOnCondition(Map<String, List<QFilter>> joinOnMap, List<Object> dateParamList, StringBuffer andConditionBuffer, String joinEntityAlias) {
        StringBuilder onCondStrBuffer = new StringBuilder(andConditionBuffer);
        if (onCondStrBuffer.length() == 0) {
            List<QFilter> joinFilterList = joinOnMap.get(joinEntityAlias);
            int joinOnNum = 0;
            for (QFilter joinFilter : joinFilterList) {
                String filterStr;
                if (joinOnNum == 0) {
                    if (joinFilter.getValue() instanceof Object) {
                        filterStr = joinFilter.getProperty() + joinFilter.getCP() + "?";
                        onCondStrBuffer.append(filterStr);
                        dateParamList.add(joinFilter.getValue());
                    } else {
                        onCondStrBuffer.append(joinFilter);
                    }
                } else if (joinFilter.getValue() instanceof Object) {
                    filterStr = joinFilter.getProperty() + joinFilter.getCP() + "?";
                    onCondStrBuffer.append(AND).append(filterStr);
                    dateParamList.add(joinFilter.getValue());
                } else {
                    onCondStrBuffer.append(AND).append(joinFilter);
                }
                ++joinOnNum;
            }
        } else {
            List<QFilter> joinFilterList = joinOnMap.get(joinEntityAlias);
            for (QFilter joinFilter : joinFilterList) {
                if (joinFilter.getValue() instanceof Date) {
                    String filterStr = joinFilter.getProperty() + joinFilter.getCP() + "?";
                    onCondStrBuffer.append(AND).append(filterStr);
                    dateParamList.add((Date)joinFilter.getValue());
                    continue;
                }
                onCondStrBuffer.append(AND).append(joinFilter);
            }
        }
        return onCondStrBuffer.toString();
    }

    private void fillProperties() throws CloneNotSupportedException {
        MainEntityType dt = EntityMetadataCache.getDataEntityType(this.getEntityName());
        this.setAlias(dt.getAlias());
        this.setDBRouteKey(dt.getDBRouteKey());
        this.fillQueryEntityProperties(dt);
        this.pkList.clear();
        this.createPropIndexsNoCache();
        for (JoinEntity joinEntity : this.getJoinEntitys()) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType(joinEntity.getEntityName());
            IDataEntityProperty FKProperty = this.findProperty(joinEntity.getFKProperty());
            IDataEntityProperty joinProperty = entityType.findProperty(joinEntity.getProperty());
            if (joinProperty == null) {
                joinProperty = entityType.findProperty(joinEntity.getEntityName() + "." + joinEntity.getProperty());
            }
            JoinProperty property = new JoinProperty(FKProperty, joinProperty);
            if (FKProperty instanceof BasedataProp) {
                property.setRefIdProp(((BasedataProp)FKProperty).getRefIdProp());
            } else {
                property.setRefIdProp(FKProperty);
            }
            property.setAlias(FKProperty == null ? joinEntity.getFKProperty() : FKProperty.getAlias());
            for (IDataEntityProperty prop : entityType.getProperties()) {
                DynamicProperty dp = (DynamicProperty)prop;
                if (!(dp instanceof DynamicSimpleProperty)) continue;
                DynamicSimpleProperty simpleProp = (DynamicSimpleProperty)dp;
                if (!joinEntity.isMultiRow() || !simpleProp.isPrimaryKey()) continue;
                DynamicSimpleProperty pkSimpleProp = (DynamicSimpleProperty)simpleProp.clone();
                pkSimpleProp.setName(joinEntity.getAlias() + "." + simpleProp.getName());
                this.pkList.add(pkSimpleProp);
                this.addProperty((DynamicProperty)pkSimpleProp);
            }
            property.setName(joinEntity.getAlias());
            property.setComplexType((IDataEntityType)entityType);
            property.setBaseEntityId(joinEntity.getEntityName());
            this.addProperty((DynamicProperty)property);
        }
    }

    private void fillQueryEntityProperties(MainEntityType dt) throws CloneNotSupportedException {
        boolean isContainNumber = false;
        for (IDataEntityProperty property : dt.getProperties()) {
            DynamicProperty cloneProp = (DynamicProperty)property.clone();
            this.addProperty(cloneProp);
            if (!"number".equals(property.getName())) continue;
            isContainNumber = true;
        }
        if (!isContainNumber) {
            this.setBillNo(null);
        }
    }

    @Override
    @KSMethod
    public MainOrgProp getMainOrgProperty() {
        if (!StringUtils.isEmpty((String)this.getMainOrg())) {
            MainOrgProp mainOrgProp = new MainOrgProp();
            mainOrgProp.setName(this.getMainOrg());
            return mainOrgProp;
        }
        return null;
    }

    public Object[] getJoinOnFilterValue(QSConditionRow row) {
        String leftItemString;
        String propName = row.getLeftItem().toString();
        String mainEntityName = this.getMainEntityType().getName();
        String leftItemEntityName = row.getLeftItem().getEntityName();
        if (row.getLeftItem() instanceof QSIdentifierExpr) {
            String[] leftItemEntityNames = StringUtils.split((String)row.getLeftItem().toString(), (boolean)true, (char[])new char[]{'.'});
            leftItemEntityName = leftItemEntityNames.length == 0 ? row.getLeftItem().toString() : leftItemEntityNames[0];
        }
        if (mainEntityName.equals(leftItemEntityName) && (leftItemString = row.getLeftItem().toString()).startsWith(mainEntityName)) {
            propName = leftItemString.substring(mainEntityName.length() + 1);
        }
        IDataEntityProperty prop = EntityTypeUtil.getDataEntityProperty(propName, this, false);
        Class type = prop.getPropertyType();
        String[] rightItemString = StringUtils.split((String)row.getRightItem().toString(), (boolean)true, (char[])new char[]{','});
        Object[] joinOnParamVal = new Object[rightItemString.length];
        String pattern = "\\d\\d\\d\\d-\\d\\d-\\d\\d*";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < rightItemString.length; ++i) {
            if (!Date.class.equals((Object)type) || !Pattern.matches(pattern, rightItemString[i])) continue;
            try {
                joinOnParamVal[i] = sdf.parse(rightItemString[i]);
                continue;
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
        }
        return joinOnParamVal;
    }

    private String reorgnizeQueryFields(String queryFileds) {
        if (queryFileds.endsWith(",")) {
            queryFileds = queryFileds.substring(0, queryFileds.length() - 1);
        }
        return queryFileds;
    }
}

