/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.license.api.ICoreLicenseService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SingleOrgContextHelper {
    private static final String ORG_ENTITY_NUMBER = "bos_org";
    private static final String ORG_FUNC_ADMIN = "01";
    private static final String THREAD_CACHE_KEY_LICENSE_MODE_TYPE = "bos_license_mode_type";

    public static boolean isStandardVersionMode() {
        Integer license_modeType = (Integer)ThreadCache.get((Object)THREAD_CACHE_KEY_LICENSE_MODE_TYPE, (CacheLoader)new CacheLoader<Integer>(){

            public Integer load() {
                ICoreLicenseService service = (ICoreLicenseService)ServiceFactory.getService(ICoreLicenseService.class);
                return service.getModeType();
            }
        });
        return license_modeType != null && 1 == license_modeType;
    }

    public static boolean isFlagShipVersionMode() {
        Integer license_modeType = (Integer)ThreadCache.get((Object)THREAD_CACHE_KEY_LICENSE_MODE_TYPE, (CacheLoader)new CacheLoader<Integer>(){

            public Integer load() {
                ICoreLicenseService service = (ICoreLicenseService)ServiceFactory.getService(ICoreLicenseService.class);
                return service.getModeType();
            }
        });
        return license_modeType != null && 4 == license_modeType;
    }

    public static boolean isFieldNeedHide(IDataEntityProperty prop) {
        boolean ret = false;
        if (SingleOrgContextHelper.isStandardVersionMode()) {
            if (prop == null) {
                return false;
            }
            if (prop instanceof OrgProp && !ORG_FUNC_ADMIN.equals(((OrgProp)prop).getOrgFunc())) {
                ret = true;
            }
            if (!(prop instanceof OrgProp) && prop instanceof BasedataProp && !(prop instanceof ItemClassProp) && ORG_ENTITY_NUMBER.equals(((BasedataProp)prop).getBaseEntityId())) {
                ret = true;
            }
            if (prop instanceof MulBasedataProp && ORG_ENTITY_NUMBER.equals(((MulBasedataProp)prop).getBaseEntityId()) && !ORG_FUNC_ADMIN.equals(((MulBasedataProp)prop).getOrgFunc())) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean isFieldNeedHideForCommonFilterColumn(IDataEntityProperty prop) {
        boolean ret = SingleOrgContextHelper.isFieldNeedHide(prop);
        if (SingleOrgContextHelper.isFlagShipVersionMode()) {
            if (prop == null) {
                return false;
            }
            if (prop instanceof OrgProp && !ORG_FUNC_ADMIN.equals(((OrgProp)prop).getOrgFunc())) {
                ret = true;
            }
            if (!(prop instanceof OrgProp) && prop instanceof BasedataProp && !(prop instanceof ItemClassProp) && ORG_ENTITY_NUMBER.equals(((BasedataProp)prop).getBaseEntityId())) {
                ret = true;
            }
            if (prop instanceof MulBasedataProp && ORG_ENTITY_NUMBER.equals(((MulBasedataProp)prop).getBaseEntityId()) && !ORG_FUNC_ADMIN.equals(((MulBasedataProp)prop).getOrgFunc())) {
                ret = true;
            }
        }
        return ret;
    }
}

