/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.entity.botp.CheckMessage;
import kd.bos.entity.botp.CheckMessageType;
import kd.bos.entity.botp.CheckPoint;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CheckResult {
    List<CheckMessage> messages = new ArrayList<CheckMessage>();

    public boolean isPass() {
        for (CheckMessage msg : this.getMessages()) {
            if (msg.getMsgType() != CheckMessageType.Error) continue;
            return false;
        }
        return true;
    }

    public List<CheckMessage> getMessages() {
        return this.messages;
    }

    public CheckMessage addMessage(CheckPoint checkPoint, String message) {
        CheckMessage msg = new CheckMessage(checkPoint, message);
        this.getMessages().add(msg);
        return msg;
    }

    public CheckMessage addErrorMessage(CheckPoint checkPoint, String errMessage) {
        CheckMessage msg = new CheckMessage(checkPoint, CheckMessageType.Error, errMessage);
        this.getMessages().add(msg);
        return msg;
    }

    public void merge(CheckResult otherResult) {
        if (otherResult == null) {
            return;
        }
        this.messages.addAll(otherResult.getMessages());
    }

    public void sortMessage() {
        this.messages.sort(new Comparator<CheckMessage>(){

            @Override
            public int compare(CheckMessage o1, CheckMessage o2) {
                int level2;
                int level1 = o1.getCheckPoint().getSeqArray().length;
                int level = level1 > (level2 = o2.getCheckPoint().getSeqArray().length) ? level1 : level2;
                for (int i = 0; i < level; ++i) {
                    int seq2;
                    if (i >= level1) {
                        return -1;
                    }
                    if (i >= level2) {
                        return 1;
                    }
                    int seq1 = o1.getCheckPoint().getSeqArray()[i];
                    if (seq1 == (seq2 = o2.getCheckPoint().getSeqArray()[i])) continue;
                    return seq1 - seq2;
                }
                return 0;
            }
        });
    }
}

