/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.math.BigDecimal;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;

public class AmountPrecision
extends NumberPrecision {
    public AmountPrecision() {
    }

    public AmountPrecision(FormatObject formatObject) {
        this.setFormatObject(formatObject);
    }

    public AmountPrecision(int precision, String sign, boolean isShowSign, BigDecimal result) {
        super(precision, sign, isShowSign, result);
    }

    public AmountPrecision(int precision, String sign, boolean isShowSign, BigDecimal result, FormatObject formatObject) {
        super(precision, sign, isShowSign, result);
        this.setFormatObject(formatObject);
    }

    @Override
    public String toString() {
        if (this.result == null) {
            return null;
        }
        FormatObject formatObject = this.getFormatObject();
        if (formatObject == null || formatObject.getCurrencyFormat() == null) {
            return super.toString();
        }
        BigDecimal newResult = this.result;
        formatObject.getCurrencyFormat().setGroupingUsed(this.isGroupingUsed);
        if (this.isStripTrailingZeros()) {
            newResult = this.result.stripTrailingZeros();
            formatObject.getCurrencyFormat().setMinimumFractionDigits(newResult.scale());
        } else {
            formatObject.getCurrencyFormat().setMinimumFractionDigits(this.getPrecision());
        }
        if (this.isShowSign) {
            formatObject.getCurrencyFormat().setCurrencySymbols(this.sign);
        } else {
            formatObject.getCurrencyFormat().setCurrencySymbols("");
        }
        return FormatFactory.get(FormatTypes.Currency).getFormat(formatObject).format(newResult);
    }
}

