/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.math.BigDecimal;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;

public class DecimalPrecision
extends NumberPrecision {
    public DecimalPrecision() {
    }

    public DecimalPrecision(FormatObject formatObject) {
        this.setFormatObject(formatObject);
    }

    public DecimalPrecision(int precision, String sign, boolean isShowSign, BigDecimal result) {
        super(precision, sign, isShowSign, result);
    }

    public DecimalPrecision(int precision, String sign, boolean isShowSign, BigDecimal result, FormatObject formatObject) {
        super(precision, sign, isShowSign, result);
        this.setFormatObject(formatObject);
    }

    @Override
    public String toString() {
        if (this.result == null) {
            return null;
        }
        FormatObject formatObject = this.getFormatObject();
        if (formatObject == null || formatObject.getNumberFormat() == null) {
            return super.toString();
        }
        BigDecimal newResult = this.result;
        formatObject.getNumberFormat().setGroupingUsed(this.isGroupingUsed);
        if (this.isStripTrailingZeros()) {
            newResult = this.result.stripTrailingZeros();
            formatObject.getNumberFormat().setMinimumFractionDigits(newResult.scale());
        } else {
            formatObject.getNumberFormat().setMinimumFractionDigits(this.getPrecision());
        }
        return FormatFactory.get(FormatTypes.Number).getFormat(formatObject).format(newResult);
    }
}

