/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BasedataQFilterBuilder;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.CurrentDateTimeService;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.MapExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.ICorePermissionService;
import kd.bos.service.InteTimeZone;
import kd.bos.service.ServiceFactory;
import kd.bos.utils.DbTypeConverter;

public class DefaultValueCalculator {
    private static final Log log = LogFactory.getLog(DefaultValueCalculator.class);
    protected IDataModel model;
    protected DynamicObject dataEntity;
    protected IDataEntityProperty fieldProp;
    int rowIndex;

    public DefaultValueCalculator() {
    }

    public DefaultValueCalculator(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        this.model = model;
        this.dataEntity = dataEntity;
        this.rowIndex = rowIndex;
    }

    public Object getValue(IDataEntityProperty property, Object defVal) {
        this.fieldProp = property;
        Object ret = defVal;
        if (defVal instanceof String) {
            switch ((String)defVal) {
                case "#CurrentDate#": 
                case "#CurrentDatetime#": 
                case "#CurrentUser#": 
                case "#CurrentOrg#": {
                    ret = this.getVariableValue((String)defVal);
                    break;
                }
                default: {
                    if (property instanceof DateTimeProp) {
                        if (!StringUtils.isNotBlank((Object)defVal)) break;
                        try {
                            if (property instanceof DateProp) {
                                ret = InteTimeZone.getSysTimeZone().parse((String)defVal, (DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
                                break;
                            }
                            ret = InteTimeZone.getSysTimeZone().parse((String)defVal, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                        }
                        catch (ParseException e) {
                            Expr expr = ExprParser.parse((String)((String)defVal));
                            MapExecuteContext context = new MapExecuteContext();
                            ret = expr.execute((ExecuteContext)context);
                        }
                        break;
                    }
                    if (property instanceof AssistantProp) {
                        ret = this.getAssistantData((AssistantProp)property, defVal);
                        break;
                    }
                    if (property instanceof ItemClassProp) {
                        ret = this.getItemClass((ItemClassProp)property, defVal);
                        break;
                    }
                    if (!(property instanceof BasedataProp)) break;
                    ret = this.getBasedata(((BasedataProp)property).getBaseEntityId(), defVal);
                }
            }
        }
        return ret;
    }

    public Object getValue2(IDataModel model, DynamicObject dataEntity, IDataEntityProperty property, FieldDefValue defValue2) {
        this.model = model;
        this.dataEntity = dataEntity;
        this.fieldProp = property;
        if (defValue2 == null) {
            return null;
        }
        Object value = null;
        switch (defValue2.getDefValueType()) {
            case Const: {
                value = defValue2.getConstValue();
                break;
            }
            case Variable: {
                value = this.getVariableValue(defValue2.getVarName());
                break;
            }
            case Function: {
                value = this.getFuncValue(defValue2.getFuncName(), defValue2.getFuncParameter());
                break;
            }
            case Formula: {
                value = this.getFormulaValue(defValue2.getFormula());
                break;
            }
            case Reference: {
                value = this.getReferenceValue(dataEntity, defValue2.getFuncName(), defValue2.getFuncParameter());
                break;
            }
        }
        return value;
    }

    protected Object getVariableValue(String varName) {
        Object value = null;
        switch (varName) {
            case "#CurrentDate#": {
                value = CurrentDateTimeService.getCurrentDate();
                break;
            }
            case "#CurrentDatetime#": {
                value = CurrentDateTimeService.getCurrentDatetime(this.fieldProp);
                break;
            }
            case "#CurrentDateSysTZ#": {
                value = CurrentDateTimeService.getCurrentDateSysTZ();
                break;
            }
            case "#CurrentUser#": {
                value = RequestContext.getOrCreate().getUserId();
                break;
            }
            case "#CurrentOrg#": {
                value = RequestContext.getOrCreate().getOrgId();
                break;
            }
        }
        return value;
    }

    protected Object getFuncValue(String funcName, String funcParameter) {
        Object value = null;
        if (StringUtils.isBlank((CharSequence)funcName) || StringUtils.isBlank((CharSequence)funcParameter)) {
            return value;
        }
        switch (funcName) {
            case "getBasedata": {
                value = this.getBasedata2(((BasedataProp)this.fieldProp).getBaseEntityId(), funcParameter);
                break;
            }
            case "getAssistant": {
                value = this.getAssistantData((AssistantProp)this.fieldProp, funcParameter);
                break;
            }
        }
        return value;
    }

    protected Object getFormulaValue(String formula) {
        Object value;
        block6: {
            value = null;
            if (StringUtils.isBlank((CharSequence)formula)) {
                return value;
            }
            try {
                MapExecuteContext context = new MapExecuteContext();
                String[] vars = FormulaEngine.extractVariables((String)formula);
                if (vars != null && vars.length > 0) {
                    if (this.model == null || this.dataEntity == null) {
                        return value;
                    }
                    RowDataModel rowDataModel = new RowDataModel(this.fieldProp.getParent().getName(), this.model);
                    rowDataModel.setRowContext(this.dataEntity);
                    for (String var : vars) {
                        context.putValue(var, rowDataModel.getValue(var));
                    }
                }
                Expr expr = ExprParser.parse((String)formula);
                value = expr.execute((ExecuteContext)context);
            }
            catch (Throwable exp) {
                if (!log.isErrorEnabled()) break block6;
                log.error(exp);
            }
        }
        return value;
    }

    protected Object getBasedata(String baseEntityKey, Object basedata) {
        Object ret = null;
        if (StringUtils.isNotBlank((CharSequence)baseEntityKey) && StringUtils.isNotBlank((Object)basedata)) {
            BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType(baseEntityKey);
            ORM orm = ORM.create();
            QFilter filter = this.buildBasedataNumberFilter(entityType, basedata);
            try (DataSet ds = orm.queryDataSet(entityType.getPrimaryKey().getName(), entityType.getName(), entityType.getPrimaryKey().getName(), new QFilter[]{filter});){
                if (ds.hasNext()) {
                    Row data = ds.next();
                    ret = data.get(entityType.getPrimaryKey().getName());
                }
            }
        }
        return ret;
    }

    protected Object getBasedata2(String baseEntityKey, Object basedata) {
        Object ret = null;
        Object id = null;
        Object number = null;
        Map basedataMap = (Map)SerializationUtils.fromJsonString((String)((String)basedata), Map.class);
        id = basedataMap.get("id");
        number = basedataMap.get("number");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        try (EntityTraceSpan span = EntityTracer.create((String)"DefaultValueCalculator", (String)"getBasedata2");){
            if (StringUtils.isNotBlank((CharSequence)baseEntityKey) && StringUtils.isNotBlank((Object)basedata)) {
                QFilter approvedQFilter;
                String appId;
                DynamicProperty prop;
                if (span.isRealtime()) {
                    span.addTag("baseEntityKey", baseEntityKey);
                    span.addLocaleTag("basedata", basedata);
                }
                BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType(baseEntityKey);
                int dbType = entityType.getPrimaryKey().getDbType();
                id = DbTypeConverter.safeConvert(dbType, id);
                ORM orm = ORM.create();
                QFilter pkIdFilter = new QFilter(entityType.getPrimaryKey().getName(), "=", id);
                QFilter numberFilter = this.buildBasedataNumberFilter(entityType, number);
                QFilter idOrNumberFilter = pkIdFilter.or(numberFilter);
                filters.add(idOrNumberFilter);
                if (this.fieldProp instanceof AssistantProp && (prop = entityType.getProperty("group")) instanceof GroupProp) {
                    dbType = ((GroupProp)prop).getDbType();
                    Object typeId = DbTypeConverter.safeConvert(dbType, ((AssistantProp)this.fieldProp).getAsstTypeId());
                    QFilter typeFilter = new QFilter("group", "=", typeId);
                    filters.add(typeFilter);
                }
                if (this.model != null && !StringUtils.isBlank((CharSequence)(appId = (String)this.model.getContextVariable("CUR_APP_ID")))) {
                    QFilter dataRuleForBD;
                    HashMap<String, Object> customParam;
                    List<QFilter> coreFilters;
                    QFilter specFilter = BasedataQFilterBuilder.getSpecialDataPermissionFilter(appId, entityType.getName(), "47150e89000000ac");
                    if (specFilter != null) {
                        filters.add(specFilter);
                    }
                    if ((coreFilters = BasedataQFilterBuilder.getBaseDataPropertyQFilters(this.model, entityType.getName(), (IBasedataField)this.fieldProp, appId, "47150e89000000ac")) != null && !coreFilters.isEmpty()) {
                        filters.addAll(coreFilters);
                    }
                    if ((customParam = (HashMap<String, Object>)this.model.getContextVariable("CUSTOM_PARAM")) == null) {
                        customParam = new HashMap<String, Object>();
                    }
                    long userId = RequestContext.get().getCurrUserId();
                    ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put("isLookUp", true);
                    customParams.putAll(customParam);
                    List<QFilter> dataRuleFilters = Collections.singletonList(permissionService.getDataPermWithOrg(userId, appId, entityType.getName(), customParams));
                    if (dataRuleFilters != null && !dataRuleFilters.isEmpty()) {
                        filters.addAll(dataRuleFilters);
                    }
                    String entityTypeId = this.model.getDataEntityType().getName();
                    if (span.isRealtime()) {
                        span.addTag("appId", appId);
                        span.addTag("entityTypeId", entityTypeId);
                        span.addTag("basedataFieldKey", this.fieldProp.getName());
                        span.addTag("perItemId", "47150e89000000ac");
                        span.addLocaleTag("customParam", customParam);
                    }
                    if ((dataRuleForBD = BasedataQFilterBuilder.getDataRuleForBdProp(appId, entityTypeId, this.fieldProp.getName(), "47150e89000000ac", customParam)) != null) {
                        if (span.isRealtime()) {
                            span.addLocaleTag("dataRuleForBD", (Object)dataRuleForBD);
                        }
                        filters.add(dataRuleForBD);
                    }
                }
                IDataEntityProperty enableProp = entityType.findProperty("enable");
                if (((BasedataProp)this.fieldProp).isShowUsed() && enableProp instanceof BillStatusProp && StringUtils.isNotBlank((CharSequence)enableProp.getAlias())) {
                    filters.add(new QFilter("enable", "=", (Object)"1"));
                }
                if ((approvedQFilter = PermissionFilterUtil.getApprovedFilter(entityType)) != null) {
                    filters.add(approvedQFilter);
                }
                try (DataSet ds = orm.queryDataSet(entityType.getPrimaryKey().getName(), entityType.getName(), entityType.getPrimaryKey().getName(), filters.toArray(new QFilter[0]));){
                    while (true) {
                        if (ds.hasNext()) {
                            Row data = ds.next();
                            ret = data.get(entityType.getPrimaryKey().getName());
                            if (id != null && !id.equals(ret)) continue;
                            Object object = ret;
                            return object;
                            continue;
                        }
                        break;
                    }
                }
            }
            Object object = ret;
            return object;
        }
    }

    protected Object getItemClass(ItemClassProp itemClassProp, Object defVal) {
        Object value = null;
        try {
            if (this.model == null || this.dataEntity == null) {
                return value;
            }
            String typePropName = itemClassProp.getTypePropName();
            ItemClassTypeProp typeprop = (ItemClassTypeProp)itemClassProp.getParent().getProperties().get((Object)typePropName);
            RowDataModel rowDataModel = new RowDataModel(itemClassProp.getParent().getName(), this.model);
            rowDataModel.setRowContext(this.dataEntity);
            Object type = rowDataModel.getValue(typePropName);
            String baseEntityId = null;
            if (StringUtils.isBlank((Object)type)) {
                if (typeprop != null) {
                    typeprop.applyDefaultValue(this.model, this.dataEntity, this.rowIndex);
                    baseEntityId = (String)rowDataModel.getValue(typePropName);
                }
            } else {
                baseEntityId = (String)type;
            }
            value = this.getBasedata(baseEntityId, defVal);
        }
        catch (Throwable t) {
            log.error(t);
        }
        return value;
    }

    private QFilter buildBasedataNumberFilter(BasedataEntityType bdType, Object number) {
        QFilter filter = null;
        if (bdType.getMasteridType() == 2) {
            BasedataProp masterProp = (BasedataProp)bdType.findProperty(bdType.getMasteridPropName());
            filter = new QFilter(bdType.getMasteridPropName() + "." + masterProp.getNumberProp(), "=", number);
        } else {
            filter = new QFilter(bdType.getNumberProperty(), "=", number);
        }
        return filter;
    }

    private Object getAssistantData(AssistantProp assistantProp, Object number) {
        Object ret = null;
        String baseEntityKey = assistantProp.getBaseEntityId();
        if (StringUtils.isNotBlank((CharSequence)baseEntityKey) && StringUtils.isNotBlank((Object)number)) {
            BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType(baseEntityKey);
            Object typeId = assistantProp.getAsstTypeId();
            DynamicProperty group = entityType.getProperty("group");
            if (group instanceof GroupProp) {
                int dbType = ((GroupProp)group).getDbType();
                typeId = DbTypeConverter.safeConvert(dbType, typeId);
            }
            ORM orm = ORM.create();
            QFilter[] filters = new QFilter[]{new QFilter(entityType.getNumberProperty(), "=", number), new QFilter("group", "=", typeId)};
            try (DataSet ds = orm.queryDataSet(entityType.getPrimaryKey().getName(), entityType.getName(), entityType.getPrimaryKey().getName(), filters);){
                if (ds.hasNext()) {
                    Row data = ds.next();
                    ret = data.get(entityType.getPrimaryKey().getName());
                }
            }
        }
        return ret;
    }

    private Object getReferenceValue(DynamicObject dataEntity, String funcName, String funcFeild) {
        Date value = null;
        if (dataEntity == null || StringUtils.isBlank((CharSequence)funcName) || StringUtils.isBlank((CharSequence)funcFeild)) {
            return value;
        }
        Object refereValue = dataEntity.get(funcFeild);
        switch (funcName) {
            case "#CurrentDateOrgTZ#": {
                value = CurrentDateTimeService.getCurrentDateOrgTZ(refereValue, false, this.fieldProp instanceof DateTimeProp);
                break;
            }
        }
        return value;
    }

    public static Date getCurrentDateOrgTZ(Object orgValue, boolean isDateTime, boolean isDateTimeProp) {
        return CurrentDateTimeService.getCurrentDateOrgTZ(orgValue, isDateTime, isDateTimeProp);
    }
}

