/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.format.TimeFormatObject;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class NumberPrecision
implements Serializable {
    private static final long serialVersionUID = 7350402724212283535L;
    private int precision;
    private boolean stripTrailingZeros;
    private transient FormatObject formatObject;
    String sign;
    boolean isShowSign;
    boolean isGroupingUsed = true;
    BigDecimal result = null;

    public boolean isStripTrailingZeros() {
        return this.stripTrailingZeros;
    }

    @SimplePropertyAttribute(name="StripTrailingZeros")
    public void setStripTrailingZeros(boolean stripTrailingZeros) {
        this.stripTrailingZeros = stripTrailingZeros;
    }

    @SimplePropertyAttribute
    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @SimplePropertyAttribute
    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    @SimplePropertyAttribute(name="ShowSign")
    public boolean isShowSign() {
        return this.isShowSign;
    }

    public void setShowSign(boolean isShowSign) {
        this.isShowSign = isShowSign;
    }

    @SimplePropertyAttribute(name="GroupingUsed")
    @DefaultValueAttribute(value="true")
    public boolean isGroupingUsed() {
        return this.isGroupingUsed;
    }

    public void setGroupingUsed(boolean isGroupingUsed) {
        this.isGroupingUsed = isGroupingUsed;
    }

    @SimplePropertyAttribute
    public BigDecimal getResult() {
        return this.result;
    }

    public void setResult(BigDecimal result) {
        this.result = result;
    }

    public void addResult(BigDecimal result) {
        if (this.result == null && result == null) {
            return;
        }
        this.result = this.result == null && result != null ? result : this.result.add(result);
    }

    public FormatObject getFormatObject() {
        return this.formatObject;
    }

    public void setFormatObject(FormatObject formatObject) {
        this.formatObject = formatObject;
    }

    private BigDecimal halfUp(BigDecimal v, int scale) {
        if (scale < 0) {
            return v;
        }
        return v.setScale(scale, 4);
    }

    public NumberPrecision() {
    }

    public NumberPrecision(BigDecimal result) {
        this.result = result;
    }

    public NumberPrecision(FormatObject formatObject) {
        this.formatObject = formatObject;
    }

    public NumberPrecision(int precision, String sign, boolean isShowSign, BigDecimal result) {
        this.precision = precision;
        this.sign = sign;
        this.isShowSign = isShowSign;
        this.result = result;
    }

    public NumberPrecision(int precision, String sign, boolean isShowSign, BigDecimal result, FormatObject formatObject) {
        this.precision = precision;
        this.sign = sign;
        this.isShowSign = isShowSign;
        this.result = result;
        this.formatObject = formatObject;
    }

    public String getFmtString() {
        return this.toString();
    }

    public String toString() {
        BigDecimal newResult;
        if (this.result == null) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingUsed(this.isGroupingUsed);
        if (this.isStripTrailingZeros()) {
            newResult = this.result.stripTrailingZeros();
            decimalFormat.setMinimumFractionDigits(newResult.scale());
        } else {
            newResult = this.halfUp(this.result, this.precision);
            decimalFormat.setMinimumFractionDigits(this.precision);
        }
        if (!this.isShowSign) {
            return decimalFormat.format(newResult);
        }
        return String.format("%s %s", this.sign, decimalFormat.format(newResult));
    }

    public void initFromMap(Map<String, Object> map) {
        Object isGroupingUsed1;
        Object stripTrailingZeros1;
        Object precision1;
        Object result1;
        Map formatObject1;
        Object sign1;
        Object isShowSign1 = map.get("isShowSign");
        if (isShowSign1 != null) {
            this.setShowSign((Boolean)isShowSign1);
        }
        if ((sign1 = map.get("sign")) != null) {
            this.setSign(sign1.toString());
        }
        if ((formatObject1 = (Map)map.get("formatObject")) != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            this.setFormatObject(new FormatObject((CurrencyFormatObject)objectMapper.convertValue(formatObject1.get("currencyFormat"), CurrencyFormatObject.class), (NumberFormatObject)objectMapper.convertValue(formatObject1.get("numberFormat"), NumberFormatObject.class), (DateFormatObject)objectMapper.convertValue(formatObject1.get("dateFormat"), DateFormatObject.class), (TimeFormatObject)objectMapper.convertValue(formatObject1.get("timeFormat"), TimeFormatObject.class)));
        }
        if ((result1 = map.get("result")) != null) {
            this.setResult(BigDecimal.valueOf(Double.parseDouble(result1.toString())));
        }
        if ((precision1 = map.get("precision")) != null) {
            this.setPrecision((Integer)precision1);
        }
        if ((stripTrailingZeros1 = map.get("stripTrailingZeros")) != null) {
            this.setStripTrailingZeros((Boolean)stripTrailingZeros1);
        }
        if ((isGroupingUsed1 = map.get("isGroupingUsed")) != null) {
            this.setGroupingUsed((Boolean)isGroupingUsed1);
        }
    }
}

