/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel.events;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterTogetherMoveEntryRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeSetItemValueEventArgs;
import kd.bos.entity.datamodel.events.BeforeTogetherMoveEntryRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.datamodel.events.TotalEntriesEventArgs;
import kd.bos.entity.plugin.manager.EventMethod;
import kd.bos.entity.plugin.manager.IConditionEvent;
import kd.bos.entity.plugin.manager.IPluginManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ModelEventProxy {
    private static Log logger = LogFactory.getLog(ModelEventProxy.class);
    private static final String PLUGIN = "plugin";
    protected List<IDataModelListener> modelListeners = new ArrayList<IDataModelListener>();
    protected LinkedHashSet<IDataModelChangeListener> modelChangeListeners = new LinkedHashSet();
    private IPluginManager pluginManager;

    private boolean isNotOverride(Class<?> pluginClass, String methodName, Class<?> ... parameterTypes) {
        return this.isNotOverride(pluginClass, methodName, (IConditionEvent)null, parameterTypes);
    }

    private boolean isNotOverride(Class<?> pluginClass, String methodName, IConditionEvent conditionEvent, Class<?> ... parameterTypes) {
        EventMethod eventMethod = EventMethod.create(methodName, conditionEvent, parameterTypes);
        if (Objects.isNull(this.pluginManager)) {
            return true;
        }
        boolean isNotOverride = this.pluginManager.isNotOverride(eventMethod, pluginClass);
        if (!isNotOverride) {
            logger.warn(pluginClass.getName() + "." + methodName + "\u7981\u7528\u6267\u884c" + (conditionEvent != null ? "\uff0c\u53c2\u6570\u6761\u4ef6\uff1a" + conditionEvent.getVarMap() : ""));
        }
        return isNotOverride;
    }

    private void invokeModelListenerMethod(Consumer<IDataModelListener> consumer, String methodName, Class<?> ... parameterTypes) {
        for (IDataModelListener l : this.modelListeners) {
            if (!this.isNotOverride(l.getClass(), methodName, parameterTypes)) continue;
            EntityTraceSpan span = EntityTracer.create((String)PLUGIN, (String)(l.getClass().getName() + "." + methodName), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());
            Throwable throwable = null;
            try {
                consumer.accept(l);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeModelImportListenerMethod(Consumer<IDataModelListener> consumer, String methodName, Class<?> ... parameterTypes) {
        for (IDataModelListener l : this.modelListeners) {
            if (!this.isNotOverride(l.getClass(), methodName, parameterTypes)) continue;
            EntityTraceSpan span = null;
            try {
                if (EntityTracer.isRealtime()) {
                    span = EntityTracer.create((String)"importplugin", (String)(l.getClass().getName() + "." + methodName), (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                }
                consumer.accept(l);
            }
            finally {
                if (span == null) continue;
                span.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeModelChangeListenerMethod(Consumer<IDataModelChangeListener> consumer, String methodName, Class<?> ... parameterTypes) {
        for (IDataModelChangeListener l : this.modelChangeListeners) {
            if (!this.isNotOverride(l.getClass(), methodName, parameterTypes)) continue;
            EntityTraceSpan span = null;
            try {
                if (EntityTracer.isRealtime()) {
                    span = EntityTracer.create((String)PLUGIN, (String)(l.getClass().getName() + "." + methodName), (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                }
                consumer.accept(l);
            }
            finally {
                if (span == null) continue;
                span.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeModelChangeListenerMethod(Consumer<IDataModelChangeListener> consumer, String methodName, IConditionEvent conditionEvent, Class<?> ... parameterTypes) {
        for (IDataModelChangeListener pl : this.modelChangeListeners) {
            if (!this.isNotOverride(pl.getClass(), methodName, conditionEvent, parameterTypes)) continue;
            EntityTraceSpan span = null;
            try {
                if (EntityTracer.isRealtime()) {
                    span = EntityTracer.create((String)PLUGIN, (String)(pl.getClass().getName() + "." + methodName), (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                }
                consumer.accept(pl);
            }
            finally {
                if (span == null) continue;
                span.close();
            }
        }
    }

    public void addPluginManager(IPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void addDataModelListener(IDataModelListener l) {
        this.modelListeners.add(l);
    }

    public void addDataModelChangeListener(IDataModelChangeListener l) {
        this.modelChangeListeners.add(l);
    }

    public void fireAfterCreateNewData(EventObject e) {
        this.invokeModelListenerMethod(modelListener -> modelListener.afterCreateNewData(e), "afterCreateNewData", EventObject.class);
    }

    public void fireInitImportData(InitImportDataEventArgs e) {
        this.invokeModelImportListenerMethod(modelListener -> modelListener.initImportData(e), "initImportData", InitImportDataEventArgs.class);
    }

    public void fireBeforeImportData(BeforeImportDataEventArgs e) {
        this.invokeModelImportListenerMethod(modelListener -> modelListener.beforeImportData(e), "beforeImportData", BeforeImportDataEventArgs.class);
    }

    public void fireQueryImportBasedata(QueryImportBasedataEventArgs e) {
        this.invokeModelImportListenerMethod(modelListener -> modelListener.queryImportBasedata(e), "queryImportBasedata", QueryImportBasedataEventArgs.class);
    }

    public void fireBeforeImportEntry(BeforeImportEntryEventArgs e) {
        this.invokeModelImportListenerMethod(modelListener -> modelListener.beforeImportEntry(e), "beforeImportEntry", BeforeImportEntryEventArgs.class);
    }

    public void fireAfterImportData(ImportDataEventArgs e) {
        this.invokeModelImportListenerMethod(modelListener -> modelListener.afterImportData(e), "afterImportData", ImportDataEventArgs.class);
    }

    public void fireLoadData(LoadDataEventArgs e) {
        this.invokeModelListenerMethod(modelListener -> modelListener.loadData(e), "loadData", LoadDataEventArgs.class);
    }

    public void fireCreateNewData(BizDataEventArgs e) {
        this.invokeModelListenerMethod(modelListener -> modelListener.createNewData(e), "createNewData", BizDataEventArgs.class);
    }

    public void fireAfterCopyeData(EventObject e) {
        this.invokeModelListenerMethod(modelListener -> modelListener.afterCopyData(e), "afterCopyData", EventObject.class);
    }

    public void fireBeforePopertyChanged(PropertyChangedArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.beforePropertyChanged(e), "beforePropertyChanged", PropertyChangedArgs.class);
    }

    public void firePopertyChanged(PropertyChangedArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> {
            if (modelChangeListener.isSupportBatchPropChanged()) {
                modelChangeListener.propertyChanged(e);
            } else {
                for (ChangeData changeData : e.getChangeSet()) {
                    PropertyChangedArgs singleArg = new PropertyChangedArgs(e.getProperty(), new ChangeData[]{changeData});
                    modelChangeListener.propertyChanged(singleArg);
                }
            }
        }, "propertyChanged", e, PropertyChangedArgs.class);
    }

    public void fireInitPopertyChanged(PropertyChangedArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> {
            if (modelChangeListener.isSupportBatchPropChanged()) {
                modelChangeListener.initPropertyChanged(e);
            } else {
                for (ChangeData changeData : e.getChangeSet()) {
                    PropertyChangedArgs singleArg = new PropertyChangedArgs(e.getProperty(), new ChangeData[]{changeData});
                    modelChangeListener.initPropertyChanged(singleArg);
                }
            }
        }, "initPropertyChanged", e, PropertyChangedArgs.class);
    }

    public void fireBeforeAddRow(BeforeAddRowEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.beforeAddRow(e), "beforeAddRow", BeforeAddRowEventArgs.class);
    }

    public void fireAfterAddRow(AfterAddRowEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.afterAddRow(e), "afterAddRow", e, AfterAddRowEventArgs.class);
    }

    public void fireBeforeDeleteRow(BeforeDeleteRowEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.beforeDeleteRow(e), "beforeDeleteRow", e, BeforeDeleteRowEventArgs.class);
    }

    public void fireAfterDeleteRow(AfterDeleteRowEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.afterDeleteRow(e), "afterDeleteRow", e, AfterDeleteRowEventArgs.class);
    }

    public void fireBeforeDeleteEntry(BeforeDeleteEntryEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.beforeDeleteEntry(e), "beforeDeleteEntry", e, BeforeDeleteEntryEventArgs.class);
    }

    public void fireAfterDeleteEntry(AfterDeleteEntryEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.afterDeleteEntry(e), "afterDeleteEntry", e, AfterDeleteEntryEventArgs.class);
    }

    public void fireAfterMoveEntryUp(AfterMoveEntryEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.afterMoveEntryUp(e), "afterMoveEntryUp", e, AfterMoveEntryEventArgs.class);
    }

    public void fireAfterMoveEntryDown(AfterMoveEntryEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.afterMoveEntryDown(e), "afterMoveEntryDown", e, AfterMoveEntryEventArgs.class);
    }

    public void fireAfterTogetherMoveEntryRow(AfterTogetherMoveEntryRowEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.afterTogetherMoveEntryRow(e), "afterTogetherMoveEntryRow", e, AfterTogetherMoveEntryRowEventArgs.class);
    }

    public void fireBeforeTogetherMoveEntryRow(BeforeTogetherMoveEntryRowEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.beforeTogetherMoveEntryRow(e), "beforeTogetherMoveEntryRow", e, BeforeTogetherMoveEntryRowEventArgs.class);
    }

    public void fireGetEntityType(GetEntityTypeEventArgs e) {
        this.invokeModelListenerMethod(dataModelListener -> dataModelListener.getEntityType(e), "getEntityType", GetEntityTypeEventArgs.class);
    }

    public void fireBeforeSetItemValueByNumber(BeforeSetItemValueEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.beforeSetItemValue(e), "beforeSetItemValue", BeforeSetItemValueEventArgs.class);
    }

    public void fireAfterSetEntryTop(AfterMoveEntryEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.afterSetEntryTop(e), "afterSetEntryTop", AfterMoveEntryEventArgs.class);
    }

    public void fireAfterSetEntryBottom(AfterMoveEntryEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.afterSetEntryBottom(e), "afterSetEntryBottom", AfterMoveEntryEventArgs.class);
    }

    public void fireBeforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.beforeBatchFillEntry(e), "beforeBatchFillEntry", BeforeBatchFillEntryArgs.class);
    }

    public void fireTotalEntries(TotalEntriesEventArgs e) {
        this.invokeModelChangeListenerMethod((IDataModelChangeListener modelChangeListener) -> modelChangeListener.totalEntriesByCondition(e), "totalEntriesEventArgs", TotalEntriesEventArgs.class);
    }
}

