/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.dynplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.dynplugin.EntityDynamicPluginReader;
import kd.bos.service.dynplugin.DynPlugin;

public class EntityDynamicPluginCache {
    private static final CacheConfigInfo info;
    private static final String TYPE_NAME = "EntityDynamicPluginCache";
    private EntityDynamicPluginReader entityDynamicPluginReader = new EntityDynamicPluginReader();
    private static EntityDynamicPluginCache _entityDynPluginCache;

    private EntityDynamicPluginCache() {
    }

    public static List<DynPlugin> getDynamicPlugins(String entityNumber, String eventmethod, String operationkey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getDynamicPlugins");){
            if (span.isRealtime()) {
                span.addTag("entityNumber", entityNumber);
                span.addTag("eventmethod", eventmethod);
                span.addTag("operationkey", operationkey);
            }
            List dynamicPlugins = new ArrayList(0);
            Map<String, List<DynPlugin>> dynamicPluginMap = (Map<String, List<DynPlugin>>)EntityDynamicPluginCache.getLocalCache(entityNumber).get(EntityDynamicPluginCache.getKey(entityNumber, operationkey));
            if (dynamicPluginMap != null) {
                dynamicPlugins = dynamicPluginMap.computeIfAbsent(eventmethod, p -> new ArrayList(0));
                if (span.isRealtime()) {
                    span.addLocaleTag("dynamicPlugins", dynamicPluginMap);
                }
                ArrayList<DynPlugin> arrayList = dynamicPlugins;
                return arrayList;
            }
            dynamicPluginMap = EntityDynamicPluginCache._entityDynPluginCache.entityDynamicPluginReader.getDynamicPluginMap(entityNumber, operationkey);
            if (dynamicPluginMap != null) {
                EntityDynamicPluginCache.getLocalCache(entityNumber).put(EntityDynamicPluginCache.getKey(entityNumber, operationkey), dynamicPluginMap);
                dynamicPlugins = dynamicPluginMap.computeIfAbsent(eventmethod, p -> new ArrayList(0));
                if (span.isRealtime()) {
                    span.addLocaleTag("dynamicPlugins", dynamicPluginMap);
                }
            }
            ArrayList<DynPlugin> arrayList = dynamicPlugins;
            return arrayList;
        }
    }

    public static void clearCacheByDynPluginIds(List<Object> dynPluginIds) {
        List<Map<String, String>> infos = EntityDynamicPluginCache._entityDynPluginCache.entityDynamicPluginReader.getClearCacheInfosByDynPluginIds(dynPluginIds);
        EntityDynamicPluginCache.batchClearCache(infos);
    }

    public static void clearCacheByDynPluginBindIds(List<Object> dynPluginBindIds) {
        List<Map<String, String>> infos = EntityDynamicPluginCache._entityDynPluginCache.entityDynamicPluginReader.getClearCacheInfosByDynPluginBindIds(dynPluginBindIds);
        EntityDynamicPluginCache.batchClearCache(infos);
    }

    public static void batchClearCache(List<Map<String, String>> dynPluginInfos) {
        if (dynPluginInfos != null && dynPluginInfos.size() > 0) {
            for (Map<String, String> dynPluginInfo : dynPluginInfos) {
                String entityNumber = dynPluginInfo.get("formNumber");
                String operationkey = dynPluginInfo.get("operationkey");
                EntityDynamicPluginCache.clearCache(entityNumber, operationkey);
            }
        }
    }

    private static void clearCache(String entityNumber, String operationkey) {
        EntityDynamicPluginCache._entityDynPluginCache.entityDynamicPluginReader.clearCache(entityNumber, operationkey);
        EntityDynamicPluginCache.getLocalCache(entityNumber).remove(new String[]{EntityDynamicPluginCache.getKey(entityNumber, operationkey)});
    }

    private static LocalMemoryCache getLocalCache(String formNumber) {
        String region = CacheKeyUtil.getAcctId();
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "EntityDynamicPlugin", info);
    }

    private static String getKey(String entityNumber, String operationkey) {
        return entityNumber + "-" + operationkey;
    }

    static {
        int maxItemSize = 200000;
        int timeout = 300;
        info = new CacheConfigInfo();
        info.setTimeout(timeout);
        info.setMaxItemSize(maxItemSize);
        info.setTimeToLive(true);
        _entityDynPluginCache = new EntityDynamicPluginCache();
    }
}

