/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.dynplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dlock.DLock;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.dynplugin.EntityDynamicPluginDesignReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.dynplugin.DynPlugin;
import kd.bos.service.dynplugin.DynamicPluginService;
import kd.bos.service.metadata.MetadataService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EntityDynamicPluginReader {
    private static final Log log = LogFactory.getLog(EntityDynamicPluginReader.class);
    private EntityDynamicPluginDesignReader entityDynamicPluginDesignReader = new EntityDynamicPluginDesignReader();
    private DynamicPluginService dynamicPluginService = (DynamicPluginService)ServiceFactory.getService(DynamicPluginService.class);
    private MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
    private static final String TYPE_NAME = "FormDynamicPluginCache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, List<DynPlugin>> getDynamicPluginMap(String entityNumber, String operationkey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getDynamicPluginMap");){
            Map<String, List<DynPlugin>> firstReadDynamicPluginMap;
            if (span.isRealtime()) {
                span.addTag("entityNumber", entityNumber);
                span.addTag("operationkey", operationkey);
            }
            if ((firstReadDynamicPluginMap = this.getDynamicPluginMapByRuntimeMeta(entityNumber, operationkey)) != null) {
                if (span.isRealtime()) {
                    span.addLocaleTag("firstReadDynamicPluginMap", firstReadDynamicPluginMap);
                }
                Map<String, List<DynPlugin>> map = firstReadDynamicPluginMap;
                return map;
            }
            String key = this.getKey(entityNumber, operationkey);
            HashMap<String, List<DynPlugin>> dynamicPluginMap = new HashMap<String, List<DynPlugin>>(10);
            DLock lock = DLock.create((String)("EntityDynamicPluginReader_getDynamicPlugin_" + RequestContext.get().getAccountId() + "_" + key)).fastMode();
            try {
                if (lock.tryLock()) {
                    Map<String, List<DynPlugin>> twoReadDynamicPluginMap = this.getDynamicPluginMapByRuntimeMeta(entityNumber, operationkey);
                    if (twoReadDynamicPluginMap != null) {
                        if (span.isRealtime()) {
                            span.addLocaleTag("twoReadDynamicPluginMap", twoReadDynamicPluginMap);
                        }
                        Map<String, List<DynPlugin>> map = twoReadDynamicPluginMap;
                        return map;
                    }
                    List<DynPlugin> dynamicPlugins = this.entityDynamicPluginDesignReader.getDynamicPlugins(entityNumber, "", operationkey);
                    if (CollectionUtils.isEmpty(dynamicPlugins)) {
                        boolean b = this.dynamicPluginService.writeEntityRuntimeMeta(entityNumber, operationkey, JSON.toJSONString((Object)new Object()));
                        if (span.isRealtime()) {
                            span.addTag("result", "{}");
                        }
                        HashMap<String, List<DynPlugin>> hashMap = new HashMap<String, List<DynPlugin>>(0);
                        return hashMap;
                    }
                    for (DynPlugin dynPlugin : dynamicPlugins) {
                        String eventmethod = dynPlugin.getEventmethod();
                        ArrayList<DynPlugin> dynPlugins = (ArrayList<DynPlugin>)dynamicPluginMap.get(eventmethod);
                        if (dynPlugins == null) {
                            dynPlugins = new ArrayList<DynPlugin>();
                            dynamicPluginMap.put(eventmethod, dynPlugins);
                        }
                        dynPlugins.add(dynPlugin);
                    }
                    if (span.isRealtime()) {
                        span.addLocaleTag("result", dynamicPluginMap);
                    }
                    boolean bl = this.dynamicPluginService.writeEntityRuntimeMeta(entityNumber, operationkey, JSON.toJSONString(dynamicPluginMap));
                } else {
                    lock.lock();
                }
            }
            finally {
                lock.unlock();
            }
            HashMap<String, List<DynPlugin>> hashMap = dynamicPluginMap;
            return hashMap;
        }
    }

    private Map<String, List<DynPlugin>> getDynamicPluginMapByRuntimeMeta(String entityNumber, String operationkey) {
        String dataJson = this.metadataService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.DynPlugin.getValue(), operationkey);
        if (StringUtils.isNotBlank((CharSequence)dataJson)) {
            if (dataJson.equals("{}")) {
                return new HashMap<String, List<DynPlugin>>(0);
            }
            return (Map)JSON.parseObject((String)dataJson, (TypeReference)new TypeReference<Map<String, List<DynPlugin>>>(){}, (Feature[])new Feature[0]);
        }
        return null;
    }

    public List<Map<String, String>> getClearCacheInfosByDynPluginIds(List<Object> dynPluginIds) {
        return this.dynamicPluginService.getClearCacheInfosByDynPluginIds(dynPluginIds);
    }

    public List<Map<String, String>> getClearCacheInfosByDynPluginBindIds(List<Object> dynPluginBindIds) {
        return this.dynamicPluginService.getClearCacheInfosByDynPluginBindIds(dynPluginBindIds);
    }

    public void clearCache(String entityNumber, String operationkey) {
        this.dynamicPluginService.clearEntityRuntimeMetaCache(entityNumber, operationkey);
    }

    private String getKey(String entityNumber, String operationkey) {
        return entityNumber + "-" + operationkey;
    }
}

