/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.privacy.PrivacyCenterTools;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.entity.CompareTypeField;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.ColumnParam;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ICompareTypeConfig;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterField {
    Log log = LogFactory.getLog(FilterField.class);
    public static final String FBASEDATAID = "fbasedataid";
    public static final String FBASEDATAID2 = ".fbasedataid";
    private int seq;
    private String entityKey;
    private String subEntityName;
    private String fieldName;
    private String fullFieldName;
    private LocaleString caption;
    private IDataEntityProperty fieldProp;
    private String srcFieldKey;
    private IDataEntityProperty srcFieldProp;
    private String refPropKey1;
    private IDataEntityProperty refProp1;
    private String refPropKey2;
    private IDataEntityProperty refProp2;
    private JoinProperty joinProperty;
    private String refPropKey;
    private String refEntityId;
    private int fieldType;
    protected String defaultCompareTypeId = "0";
    protected String defaultMultiCompareTypeId = "0";
    private String compareGroupID;
    private List<CompareType> compareTypes;
    private List<ValueMapItem> comboItems;
    private String baseDataFilterControlType;
    MainEntityType mainType;
    private IDataEntityProperty lastBasedataProp = null;
    private boolean isMulBasedata;
    List<CompareType> customCompareTypes = new ArrayList<CompareType>(10);

    public static FilterField create(MainEntityType mainType, String fieldName) {
        return FilterField.innerCreate(mainType, fieldName, null);
    }

    public static FilterField createForItemClassProp(MainEntityType mainType, String fieldName, String baseEntityId) {
        return FilterField.innerCreate(mainType, fieldName, baseEntityId);
    }

    private static FilterField innerCreate(MainEntityType mainType, String fieldName, String baseEntityId) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return null;
        }
        String[] keys = StringUtils.split((String)fieldName, (String)".");
        ArrayList<String> propNames = new ArrayList<String>(10);
        for (int i = 0; i < keys.length; ++i) {
            propNames.add(keys[i]);
        }
        IDataEntityProperty srcFieldProp = null;
        MainEntityType parenType = mainType;
        JoinProperty parentProp = null;
        String joinPropName = "";
        if (mainType instanceof QueryEntityType) {
            QueryEntitySrcResult queryEntitySrcResult = FilterField.getQueryEntitySrcFieldProp(mainType, fieldName, propNames);
            srcFieldProp = queryEntitySrcResult.getDataEntityProperty();
            joinPropName = queryEntitySrcResult.getJoinPropertyName();
            while (srcFieldProp != null && !((String)propNames.get(0)).equals(srcFieldProp.getName())) {
                propNames.remove(0);
            }
            if (StringUtils.isNotBlank((CharSequence)joinPropName)) {
                JoinProperty joinProperty = (JoinProperty)mainType.findProperty(joinPropName);
                parenType = (MainEntityType)joinProperty.getComplexType();
                parentProp = joinProperty;
            }
        } else {
            srcFieldProp = mainType.findProperty((String)propNames.get(0));
        }
        if (srcFieldProp == null && mainType.getProperties().containsKey(propNames.get(0))) {
            srcFieldProp = (IDataEntityProperty)mainType.getProperties().get(propNames.get(0));
        }
        while (srcFieldProp instanceof EntryProp && propNames.size() > 1) {
            propNames.remove(0);
            srcFieldProp = (IDataEntityProperty)((EntryProp)srcFieldProp).getItemType().getProperties().get(propNames.get(0));
        }
        if (srcFieldProp instanceof EntryProp) {
            propNames.clear();
            srcFieldProp = ((EntryProp)srcFieldProp).getItemType().getPrimaryKey();
            propNames.add(srcFieldProp.getName());
        }
        if (srcFieldProp == null) {
            return null;
        }
        FilterField filterField = null;
        Iterator<String> iterator = new ArrayList<String>(propNames).iterator();
        JoinProperty lastBasedataProp = null;
        int size = propNames.size();
        int fromindex = -1;
        while (iterator.hasNext()) {
            String name = iterator.next();
            int index = propNames.indexOf(name);
            if (index > -1 && index == fromindex) {
                for (int i = fromindex + 1; i < propNames.size(); ++i) {
                    if (!name.equals(propNames.get(i))) continue;
                    index = i;
                    break;
                }
            }
            fromindex = index;
            if (parentProp instanceof MulBasedataProp && !FBASEDATAID.equals(name) && (index + 1 < size && !FBASEDATAID.equals(propNames.get(index + 1)) || index == size - 1)) {
                lastBasedataProp = parentProp;
                propNames.add(index, FBASEDATAID);
            } else if (parentProp instanceof MulBasedataProp && !FBASEDATAID.equals(name) && index - 1 > -1 && !FBASEDATAID.equals(propNames.get(index - 1))) {
                lastBasedataProp = parentProp;
                propNames.add(index, FBASEDATAID);
            } else if (parentProp instanceof IBasedataField || parentProp instanceof IRefBillField) {
                lastBasedataProp = parentProp;
            }
            DynamicProperty property = (DynamicProperty)parenType.findProperty(name);
            if (property instanceof IBasedataField) {
                if (property instanceof ItemClassProp) {
                    parenType = ((ItemClassProp)property).getComplexType(baseEntityId);
                    if (parenType == null) {
                        parenType = (MainEntityType)((IBasedataField)property).getComplexType();
                    }
                } else {
                    parenType = (MainEntityType)((IBasedataField)property).getComplexType();
                }
            }
            parentProp = property;
        }
        if (parentProp instanceof IBasedataField || parentProp instanceof IRefBillField) {
            lastBasedataProp = parentProp;
        }
        String refPropName = StringUtils.join((Object[])propNames.toArray(), (String)".");
        if (srcFieldProp instanceof IFieldHandle && !(srcFieldProp instanceof JoinProperty)) {
            filterField = srcFieldProp instanceof ItemClassProp && baseEntityId != null ? ((ItemClassProp)srcFieldProp).createFilterField(mainType, refPropName, baseEntityId) : ((IFieldHandle)srcFieldProp).createFilterField(mainType, refPropName);
        }
        if (filterField == null) {
            return null;
        }
        if (mainType instanceof QueryEntityType) {
            String preFieldPropName = StringUtils.isBlank((CharSequence)joinPropName) ? "" : joinPropName + ".";
            filterField.setFullFieldName(preFieldPropName + filterField.getFullFieldName());
            if (filterField.getSrcFieldProp().getParent() instanceof EntryType) {
                filterField.setSubEntityName(preFieldPropName + filterField.getSubEntityName());
            }
            if (StringUtils.isNotBlank((CharSequence)joinPropName)) {
                JoinProperty finalLastBasedataProp = lastBasedataProp;
                IDataEntityProperty property = mainType.findProperty(joinPropName);
                if (property instanceof JoinProperty) {
                    filterField.setJoinProperty((JoinProperty)property);
                    filterField.getCompareTypes().removeIf(arg_0 -> FilterField.lambda$innerCreate$0(mainType, property, (DynamicProperty)finalLastBasedataProp, arg_0));
                }
            }
        }
        filterField.setFieldName(fieldName);
        filterField.setMainType(mainType);
        filterField.setLastBasedataProp((IDataEntityProperty)lastBasedataProp);
        filterField.setMulBasedata(lastBasedataProp instanceof MulBasedataProp);
        return filterField;
    }

    private static QueryEntitySrcResult getQueryEntitySrcFieldProp(MainEntityType mainType, String fieldName, List<String> propNames) {
        if (propNames.size() > 1) {
            String propName = propNames.get(0);
            if (fieldName.equals(mainType.getName() + "." + mainType.getPrimaryKey().getName())) {
                propName = propNames.get(1);
                return new QueryEntitySrcResult((IDataEntityProperty)mainType.getProperty(propName), mainType);
            }
            IDataEntityProperty dp = mainType.findProperty(propName);
            if (dp instanceof JoinProperty) {
                JoinProperty joinProp = (JoinProperty)dp;
                MainEntityType complexType = (MainEntityType)joinProp.getComplexType();
                String subPropName = fieldName.substring(propName.length());
                if (subPropName.startsWith(".")) {
                    subPropName = subPropName.substring(1);
                }
                QueryEntitySrcResult queryEntitySrcResult = new QueryEntitySrcResult(complexType.findProperty(StringUtils.split((String)subPropName, (String)".")[0]), complexType);
                queryEntitySrcResult.setJoinPropertyName(propName);
                return queryEntitySrcResult;
            }
            return new QueryEntitySrcResult(mainType.findProperty(propNames.get(0)), mainType);
        }
        return new QueryEntitySrcResult(mainType.findProperty(propNames.get(0)), mainType);
    }

    public FilterField() {
    }

    public FilterField(MainEntityType mainType, IDataEntityProperty srcFieldProp, IDataEntityProperty refProp1, IDataEntityProperty refProp2, String refEntityId) {
        this.refEntityId = refEntityId;
        this.fieldProp = srcFieldProp;
        this.srcFieldProp = srcFieldProp;
        this.srcFieldKey = srcFieldProp.getName();
        this.entityKey = mainType instanceof QueryEntityType ? mainType.getName() : this.srcFieldProp.getParent().getName();
        this.subEntityName = this.srcFieldProp.getParent().getName();
        this.mainType = mainType;
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(this.srcFieldKey);
        this.refProp1 = refProp1;
        if (refProp1 != null) {
            this.fieldProp = refProp1;
            this.refPropKey1 = refProp1.getName();
            keys.add(this.refPropKey1);
        }
        this.refProp2 = refProp2;
        if (refProp2 != null) {
            this.fieldProp = refProp2;
            this.refPropKey2 = refProp2.getName();
            keys.add(this.refPropKey2);
        }
        this.refPropKey = this.fieldProp.getName();
        this.fieldName = StringUtils.join((Object[])keys.toArray(), (String)".");
        this.fullFieldName = this.buildFullFieldName();
        this.caption = new LocaleString(this.getFullFieldCaption1());
        this.fieldType = this.buildFieldType();
        String defCompareTypeId = ((IFieldHandle)this.fieldProp).getDefaultCompareTypeId();
        String defMultiCompareTypeId = ((IFieldHandle)this.fieldProp).getDefaultMultiCompareTypeId();
        String parentCompareGroupID = null;
        if (this.refProp2 != null) {
            parentCompareGroupID = ((IFieldHandle)this.refProp1).getCompareGroupID();
            this.baseDataFilterControlType = ((IFieldHandle)this.refProp1).getFilterControlType();
        } else if (this.refProp1 != null) {
            if (this.refProp1 instanceof DateTimeProp || this.refProp1 instanceof ComboProp || this.refProp1 instanceof BooleanProp || this.refProp1 instanceof TimeProp) {
                parentCompareGroupID = ((IFieldHandle)this.refProp1).getCompareGroupID();
                this.baseDataFilterControlType = ((IFieldHandle)this.refProp1).getFilterControlType();
            } else {
                parentCompareGroupID = ((IFieldHandle)this.srcFieldProp).getCompareGroupID();
                this.baseDataFilterControlType = ((IFieldHandle)this.srcFieldProp).getFilterControlType();
            }
        }
        this.defaultCompareTypeId = defCompareTypeId;
        this.defaultMultiCompareTypeId = defMultiCompareTypeId;
        this.setCompareGroupID1(((IFieldHandle)this.fieldProp).getCompareGroupID());
        if (parentCompareGroupID != null) {
            for (CompareType compareType : FilterMetadata.get().getCompareTypes(parentCompareGroupID)) {
                if (compareType.isNeedInput() || !StringUtils.isNotBlank((CharSequence)compareType.getClassName()) || this.compareTypes.contains(compareType) || "ISNULL".equals(compareType.getValue()) || "NOTISNULL".equals(compareType.getValue())) continue;
                this.compareTypes.add(compareType);
            }
        }
        this.comboItems = new ArrayList<ValueMapItem>();
        this.comboItems.addAll(this.buildComboItems());
    }

    public FilterField(LocaleString caption, String fieldName, String entityKey, String compareGroupID, int fieldType) {
        this.caption = caption;
        this.fieldName = fieldName;
        this.entityKey = entityKey;
        this.compareGroupID = compareGroupID;
        this.fieldType = fieldType;
    }

    public MainEntityType getMainType() {
        return this.mainType;
    }

    public void setMainType(MainEntityType mainType) {
        this.mainType = mainType;
    }

    @SimplePropertyAttribute
    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public String getSubEntityName() {
        return this.subEntityName;
    }

    void setSubEntityName(String subEntityName) {
        this.subEntityName = subEntityName;
    }

    @SimplePropertyAttribute
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFullFieldName() {
        return this.fullFieldName;
    }

    public void setFullFieldName(String fullFieldName) {
        this.fullFieldName = fullFieldName;
    }

    public LocaleString getCaption() {
        return this.caption;
    }

    public void setCaption(LocaleString caption) {
        this.caption = caption;
    }

    public IDataEntityProperty getFieldProp() {
        return this.fieldProp;
    }

    public IDataEntityProperty getSrcFieldProp() {
        return this.srcFieldProp;
    }

    public String getSrcFieldKey() {
        return this.srcFieldKey;
    }

    public IDataEntityProperty getRefProp1() {
        return this.refProp1;
    }

    public String getRefPropKey1() {
        return this.refPropKey1;
    }

    public IDataEntityProperty getRefProp2() {
        return this.refProp2;
    }

    public JoinProperty getJoinProperty() {
        return this.joinProperty;
    }

    void setJoinProperty(JoinProperty joinProperty) {
        this.joinProperty = joinProperty;
    }

    public String getRefPropKey2() {
        return this.refPropKey2;
    }

    public String getRefPropKey() {
        return this.refPropKey;
    }

    public void setRefPropKey(String refPropKey) {
        this.refPropKey = refPropKey;
    }

    public String getRefEntityId() {
        return this.refEntityId;
    }

    public void setRefEntityId(String refEntityId) {
        this.refEntityId = refEntityId;
    }

    @SimplePropertyAttribute
    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int fieldType) {
        this.fieldType = fieldType;
    }

    @SimplePropertyAttribute
    public String getDefaultCompareTypeId() {
        return this.defaultCompareTypeId;
    }

    public void setDefaultCompareTypeId(String defaultCompareID) {
        this.defaultCompareTypeId = defaultCompareID;
    }

    @SimplePropertyAttribute
    public String getDefaultMultiCompareTypeId() {
        return this.defaultMultiCompareTypeId;
    }

    public void setDefaultMultiCompareTypeId(String defaultCompareID) {
        this.defaultMultiCompareTypeId = defaultCompareID;
    }

    public String getCompareGroupID() {
        return this.compareGroupID;
    }

    public void setCompareGroupID(String compareGroupID) {
        this.setCompareGroupID1(compareGroupID);
    }

    private void setCompareGroupID1(String compareGroupID) {
        this.compareGroupID = this.srcFieldProp instanceof ISimpleProperty && ((ISimpleProperty)this.srcFieldProp).isEncrypt() ? "0" : (this.isEncryptField() ? (this.getSrcFieldProp() instanceof ComboProp ? "10" : "0") : compareGroupID);
        this.compareTypes = new ArrayList<CompareType>();
        CharSequence[] groupIds = StringUtils.split((String)this.compareGroupID, (String)",");
        if (this.srcFieldProp instanceof IBasedataField) {
            Collections.sort(Arrays.asList(groupIds), (u1, u2) -> {
                if ("1".equals(u1)) {
                    return -1;
                }
                return u1.compareTo((String)u2);
            });
        }
        List<CompareType> list = FilterMetadata.get().getCompareTypes(String.join((CharSequence)",", groupIds));
        if (this.isEncryptField()) {
            if ("0".equals(this.compareGroupID)) {
                list.remove(1);
            } else if ("10".equals(this.compareGroupID)) {
                list.remove(1);
            }
        }
        this.compareTypes.addAll(list);
    }

    public CompareType getDefaultCompareType() {
        return this.getCompareType(this.defaultCompareTypeId);
    }

    public CompareType getDefaultMultiCompareType() {
        return this.getCompareType(this.defaultMultiCompareTypeId);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=CompareType.class)
    public List<CompareType> getCompareTypes() {
        if (this.compareTypes == null) {
            this.compareTypes = new ArrayList<CompareType>();
            this.compareTypes.addAll(FilterMetadata.get().getCompareTypes(this.compareGroupID));
        }
        return this.compareTypes;
    }

    public void setCompareTypes(List<CompareType> compareTypes) {
        this.compareTypes = compareTypes;
    }

    public CompareType getCompareType(String compareTypeId) {
        for (CompareType compareType : this.getCompareTypes()) {
            if (!compareType.getId().equalsIgnoreCase(compareTypeId)) continue;
            return compareType;
        }
        return null;
    }

    public List<ValueMapItem> getComboItems() {
        return this.comboItems;
    }

    public void setComboItems(List<ValueMapItem> comboItems) {
        this.comboItems = comboItems;
    }

    public String getBaseDataFilterControlType() {
        return this.baseDataFilterControlType;
    }

    void setLastBasedataProp(IDataEntityProperty lastBasedataProp) {
        this.lastBasedataProp = lastBasedataProp;
    }

    public boolean isMulBasedata() {
        return this.isMulBasedata;
    }

    void setMulBasedata(boolean mulBasedata) {
        this.isMulBasedata = mulBasedata;
    }

    public String getFilterControlType() {
        return ((IFieldHandle)this.fieldProp).getFilterControlType();
    }

    public Map<String, Object> createFilterColumn() {
        return this.createFilterColumn(true);
    }

    public void addCustomCompareType(CompareType compareType) {
        this.addCustomCompareTypes(Collections.singletonList(compareType));
    }

    public void addCustomCompareTypes(List<CompareType> compareTypes) {
        this.customCompareTypes.addAll(compareTypes);
    }

    public List<CompareType> getCustomCompareTypes() {
        IDataEntityProperty fieldProp2 = this.getLatestParent();
        if (fieldProp2 instanceof ICompareTypeConfig && ((ICompareTypeConfig)fieldProp2).getCompareTypeConfig() != null) {
            for (CompareTypeField compareTypeField : ((ICompareTypeConfig)fieldProp2).getCompareTypeConfig().getCompareTypeFields()) {
                this.customCompareTypes.add(compareTypeField.createCompareType());
            }
        }
        return this.customCompareTypes;
    }

    public List<CompareType> getAllCompareTypes() {
        ArrayList<CompareType> result = new ArrayList<CompareType>();
        List<CompareType> customCompareTypes = this.getCustomCompareTypes();
        result.addAll(customCompareTypes);
        result.addAll(this.getCompareTypes());
        return result;
    }

    public Map<String, Object> createFilterColumn(boolean isNeedCompareTypeField) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryEntity", this.entityKey);
        map.put("fieldName", this.fieldName);
        map.put("fieldCaption", this.caption.toString());
        map.put("fieldType", this.fieldType);
        String type = this.getFilterControlType();
        if ("text".equals(type) && (this.getFieldProp() == null || !(this.getFieldProp().getParent() instanceof EntryType)) && StringUtils.isNotEmpty((CharSequence)this.baseDataFilterControlType)) {
            type = this.baseDataFilterControlType;
        }
        if (StringUtils.isNotBlank((CharSequence)this.refEntityId)) {
            map.put("entityId", this.refEntityId);
        }
        if (this.refEntityId == null && "text".equals(this.getFilterControlType()) && this.getSrcFieldProp() instanceof FlexProp || this.refEntityId == null && this.getSrcFieldProp() instanceof TextProp || StringUtils.isNotBlank((CharSequence)this.refEntityId) && StringUtils.isNotEmpty((CharSequence)this.baseDataFilterControlType) && this.getFieldProp() != null && this.getFieldProp().getParent() instanceof EntryType && this.getFieldProp() instanceof TextProp) {
            map.put("entityId", "bos_multitext");
        }
        map.put("type", type);
        if ("enum".equals(type)) {
            map.put("items", this.comboItems);
        }
        map.put("compareGroupID", this.compareGroupID);
        if (this.getLatestParent() instanceof IBasedataField && this.getFieldProp() instanceof PKFieldProp) {
            map.put("type", "basedata");
            ArrayList<CompareType> compareTypeList = new ArrayList<CompareType>(this.compareTypes.size() + 2);
            compareTypeList.addAll(this.getCompareTypes());
            for (CompareType compareType : FilterMetadata.get().getCompareTypes("2")) {
                if (compareType.isNeedInput() || !StringUtils.isNotBlank((CharSequence)compareType.getClassName()) || compareTypeList.contains(compareType)) continue;
                compareTypeList.add(compareType);
            }
            ColumnParam param = new ColumnParam(true);
            param.setFilterField(this);
            param.setCompareTypes(compareTypeList);
            param.setCompareTypeDtos(FilterUtil.getCompareTypeDtos(compareTypeList));
            ((IFieldHandle)this.getLatestParent()).afterCreateFilterColumn(map, param);
        } else {
            List<CompareType> myCompareTypes = new ArrayList<CompareType>();
            myCompareTypes.addAll(this.getCustomCompareTypes());
            myCompareTypes.addAll(this.getCompareTypes());
            myCompareTypes = EntityTypeUtil.setCompareTypes(myCompareTypes, isNeedCompareTypeField, true, !(this.getLatestParent() instanceof IBasedataField));
            map.put("compareTypes", FilterUtil.getCompareTypeDtos(myCompareTypes));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterField) {
            FilterField state = (FilterField)obj;
            return state.getFieldName().equals(this.fieldName);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.fieldName.hashCode();
    }

    public String toString() {
        return this.fieldName;
    }

    private String buildFullFieldName() {
        ArrayList<String> propNames = new ArrayList<String>();
        String srcPropFullName = FilterField.buildPropORMFullNameByName(this.srcFieldProp instanceof MulBasedataProp && this.refProp1 != null && !FBASEDATAID.equals(this.refProp1.getName()) ? this.srcFieldProp.getName() + FBASEDATAID2 : this.srcFieldProp.getName(), this.srcFieldProp.getParent());
        propNames.add(srcPropFullName);
        if (this.refProp1 != null) {
            String refProp1FullName = FilterField.buildPropORMFullNameByName(this.refProp1 instanceof MulBasedataProp ? this.refProp1.getName() + FBASEDATAID2 : this.refProp1.getName(), this.refProp1.getParent());
            propNames.add(refProp1FullName);
            if (this.refProp2 != null) {
                String refProp2FullName = FilterField.buildPropORMFullNameByName(this.refProp2 instanceof MulBasedataProp ? this.refProp2.getName() + FBASEDATAID2 : this.refProp2.getName(), this.refProp2.getParent());
                propNames.add(refProp2FullName);
            }
        }
        return StringUtils.join((Object[])propNames.toArray(), (String)".");
    }

    public static String buildPropORMFullName(IDataEntityProperty prop) {
        return FilterField.buildPropORMFullNameByName(prop.getName(), prop.getParent());
    }

    public static String buildPropORMFullNameByName(String name, IDataEntityType iDataEntityType) {
        StringBuilder fullPropName = new StringBuilder();
        String name2 = iDataEntityType.getName();
        if (iDataEntityType instanceof SubEntryType) {
            fullPropName.append(iDataEntityType.getParent().getName());
            fullPropName.append(".");
            fullPropName.append(name2);
            fullPropName.append(".");
            fullPropName.append(name);
        } else if (iDataEntityType instanceof EntryType || name.startsWith(name2 + "__")) {
            fullPropName.append(name2);
            fullPropName.append(".");
            fullPropName.append(name);
        } else {
            fullPropName.append(name);
        }
        return fullPropName.toString();
    }

    public String getFullFieldCaption() {
        return this.getFullFieldCaption1();
    }

    private String getFullFieldCaption1() {
        ArrayList<String> propCaptions = new ArrayList<String>();
        EntityType entityType = (EntityType)this.srcFieldProp.getParent();
        if (entityType instanceof EntryType) {
            if (entityType.getDisplayName() != null) {
                propCaptions.add(entityType.getDisplayName().toString());
            } else {
                propCaptions.add(entityType.getName());
            }
        }
        if (((DynamicProperty)this.srcFieldProp).getDisplayName() != null) {
            propCaptions.add(((DynamicProperty)this.srcFieldProp).getDisplayName().toString());
        } else {
            propCaptions.add(this.srcFieldProp.getName());
        }
        if (this.refProp1 != null) {
            if (((DynamicProperty)this.refProp1).getDisplayName() != null) {
                propCaptions.add(((DynamicProperty)this.refProp1).getDisplayName().toString());
            } else {
                propCaptions.add(this.refProp1.getName());
            }
        }
        if (this.refProp2 != null) {
            if (((DynamicProperty)this.refProp2).getDisplayName() != null) {
                propCaptions.add(((DynamicProperty)this.refProp2).getDisplayName().toString());
            } else {
                propCaptions.add(this.refProp2.getName());
            }
        }
        return StringUtils.join((Object[])propCaptions.toArray(), (String)".");
    }

    private int buildFieldType() {
        int dbType = -9;
        if (this.srcFieldProp instanceof IFieldHandle) {
            dbType = ((IFieldHandle)this.srcFieldProp).getDbType();
        }
        if (this.refProp1 != null && this.refProp1 instanceof IFieldHandle) {
            dbType = ((IFieldHandle)this.refProp1).getDbType();
        }
        if (this.refProp2 != null && this.refProp2 instanceof IFieldHandle) {
            dbType = ((IFieldHandle)this.refProp2).getDbType();
        }
        return dbType;
    }

    private List<ValueMapItem> buildComboItems() {
        ArrayList<ValueMapItem> list = new ArrayList<ValueMapItem>();
        if (this.fieldProp instanceof ComboProp) {
            list.addAll(((ComboProp)this.fieldProp).getComboItems());
        } else if (this.fieldProp instanceof BooleanProp) {
            ValueMapItem comboItem1 = new ValueMapItem();
            comboItem1.setValue("1");
            comboItem1.setName(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"FilterField_0", (String)"bos-entity-metadata", (Object[])new Object[0])));
            ValueMapItem comboItem2 = new ValueMapItem();
            comboItem2.setValue("0");
            comboItem2.setName(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"FilterField_1", (String)"bos-entity-metadata", (Object[])new Object[0])));
            list.add(comboItem1);
            list.add(comboItem2);
        }
        return list;
    }

    public Object getValueFast(DynamicObject dynamicObject) {
        Object value = null;
        if (this.srcFieldProp != null) {
            value = this.srcFieldProp.getValueFast((Object)dynamicObject);
        }
        if (this.refProp1 != null) {
            value = this.refProp1.getValueFast((Object)((DynamicObject)value));
        }
        if (this.refProp2 != null) {
            value = this.refProp2.getValueFast((Object)((DynamicObject)value));
        }
        return value;
    }

    public boolean isFieldPropAliasEmpty() {
        if (this.srcFieldProp.getParent() instanceof EntryType && StringUtils.isEmpty((CharSequence)this.srcFieldProp.getParent().getAlias()) || this.srcFieldProp.getParent() != null && this.srcFieldProp.getParent().getParent() != null && this.srcFieldProp.getParent().getParent() instanceof EntryType && StringUtils.isEmpty((CharSequence)this.srcFieldProp.getParent().getParent().getAlias())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.getSrcFieldProp().getAlias())) {
            return true;
        }
        if (this.getRefProp1() != null && StringUtils.isBlank((CharSequence)this.getRefProp1().getAlias())) {
            return true;
        }
        return this.getRefProp2() != null && StringUtils.isBlank((CharSequence)this.getRefProp2().getAlias());
    }

    public IDataEntityProperty getLatestParent() {
        if (this.lastBasedataProp != null) {
            return this.lastBasedataProp;
        }
        if (this.getRefProp2() != null) {
            return this.getRefProp1();
        }
        return this.getSrcFieldProp();
    }

    public FilterField convertToId() {
        FilterField filterField;
        if (this.getSrcFieldProp() instanceof IBasedataField && !(this.getFieldProp() instanceof ComboProp) && !(this.getFieldProp() instanceof BooleanProp) && !(this.getFieldProp() instanceof DateTimeProp)) {
            filterField = this.getRefProp2() != null ? this.convert3LevelFieldToId() : this.convert2LevelFieldToId();
            if (this.getMainType() instanceof QueryEntityType) {
                IDataEntityType parentType;
                String[] split = StringUtils.split((String)this.getFieldName(), (String)".");
                int indexOfSrcFieldName = 0;
                for (String s : split) {
                    if (s.equals(this.getSrcFieldProp().getName())) break;
                    indexOfSrcFieldName += s.length() + 1;
                }
                String firstFieldName = this.getFieldName().substring(0, indexOfSrcFieldName);
                if (StringUtils.isNotEmpty((CharSequence)firstFieldName) && !filterField.getFieldName().startsWith(firstFieldName)) {
                    filterField.setFieldName(firstFieldName + filterField.getFieldName());
                }
                if ((parentType = this.getSrcFieldProp().getParent()) instanceof EntryType) {
                    boolean isJoinPro;
                    boolean bl = isJoinPro = parentType.getParent() != null && this.mainType.findProperty(parentType.getParent().getName()) instanceof JoinProperty;
                    if (isJoinPro) {
                        firstFieldName = this.mainType.findProperty(parentType.getParent().getName()).getName() + ".";
                        filterField.setFullFieldName(firstFieldName + filterField.getFullFieldName());
                    }
                } else {
                    filterField.setFullFieldName(firstFieldName + filterField.getFullFieldName());
                }
            }
        } else {
            filterField = this.getSrcFieldProp() instanceof IRefBillField && !(this.getFieldProp() instanceof ComboProp) && !(this.getFieldProp() instanceof BooleanProp) && !(this.getFieldProp() instanceof DateTimeProp) ? (this.getRefProp2() != null ? this.convert3LevelFieldToId() : this.convert2LevelFieldToId()) : this;
        }
        return filterField;
    }

    private FilterField convert2LevelFieldToId() {
        FilterField filterField;
        if (this.getSrcFieldProp() instanceof DynamicComplexProperty) {
            DynamicObjectType dataEntityType = ((DynamicComplexProperty)this.getSrcFieldProp()).getDynamicComplexPropertyType();
            if (this.getSrcFieldProp() instanceof IFieldHandle) {
                return ((IFieldHandle)this.getSrcFieldProp()).createFilterField(this.getMainType(), String.format("%s.%s", this.getSrcFieldProp().getName(), dataEntityType.getPrimaryKey().getName()));
            }
            filterField = new FilterField(this.getMainType(), this.getSrcFieldProp(), (IDataEntityProperty)dataEntityType.getPrimaryKey(), null, dataEntityType.getName());
        } else {
            DynamicObjectType dataEntityType = ((DynamicCollectionProperty)this.getSrcFieldProp()).getDynamicCollectionItemPropertyType();
            BasedataProp fbasedataprop = (BasedataProp)dataEntityType.getProperty(FBASEDATAID);
            if (this.getSrcFieldProp() instanceof IFieldHandle) {
                return ((IFieldHandle)this.getSrcFieldProp()).createFilterField(this.getMainType(), String.format("%s.fbasedataid.%s", this.getSrcFieldProp().getName(), fbasedataprop.getComplexType().getPrimaryKey().getName()));
            }
            filterField = new FilterField(this.getMainType(), this.getSrcFieldProp(), (IDataEntityProperty)fbasedataprop, (IDataEntityProperty)fbasedataprop.getComplexType().getPrimaryKey(), fbasedataprop.getComplexType().getName());
        }
        filterField.setLastBasedataProp(this.getLatestParent());
        filterField.setMulBasedata(this.isMulBasedata());
        return filterField;
    }

    private FilterField convert3LevelFieldToId() {
        FilterField filterField;
        if (this.getRefProp1() instanceof DynamicComplexProperty) {
            Object[] key = this.fieldName.split("\\.");
            DynamicObjectType dataEntityType = ((DynamicComplexProperty)this.getRefProp1()).getDynamicComplexPropertyType();
            if (this.srcFieldProp instanceof MaterielProp && key.length >= 4) {
                key[key.length - 1] = dataEntityType.getPrimaryKey().getName();
                filterField = ((IFieldHandle)this.srcFieldProp).createFilterField(this.getMainType(), StringUtils.join((Object[])key, (String)"."));
            } else {
                if (this.getSrcFieldProp() instanceof IFieldHandle) {
                    String propName = String.format("%s.%s.%s", this.getSrcFieldProp().getName(), this.getRefProp1().getName(), dataEntityType.getPrimaryKey().getName());
                    if (this.getSrcFieldProp() instanceof MulBasedataProp) {
                        propName = String.format("%s.fbasedataid.%s.%s", this.getSrcFieldProp().getName(), this.getRefProp1().getName(), dataEntityType.getPrimaryKey().getName());
                    }
                    return ((IFieldHandle)this.getSrcFieldProp()).createFilterField(this.getMainType(), propName);
                }
                filterField = new FilterField(this.getMainType(), this.getSrcFieldProp(), this.getRefProp1(), (IDataEntityProperty)dataEntityType.getPrimaryKey(), dataEntityType.getName());
            }
        } else {
            DynamicObjectType dataEntityType = ((DynamicCollectionProperty)this.getRefProp1()).getDynamicCollectionItemPropertyType();
            BasedataProp fbasedataprop = (BasedataProp)dataEntityType.getProperty(FBASEDATAID);
            String propName = String.format("%s.%s.fbasedataid.%s", this.getSrcFieldProp().getName(), this.getRefProp1().getName(), fbasedataprop.getComplexType().getPrimaryKey().getName());
            if (this.getSrcFieldProp() instanceof MulBasedataProp) {
                propName = String.format("%s.fbasedataid.%s.fbasedataid.%s", this.getSrcFieldProp().getName(), this.getRefProp1().getName(), fbasedataprop.getComplexType().getPrimaryKey().getName());
            }
            if (this.getSrcFieldProp() instanceof IFieldHandle) {
                return ((IFieldHandle)this.getSrcFieldProp()).createFilterField(this.getMainType(), propName);
            }
            filterField = new FilterField(this.getMainType(), this.getSrcFieldProp(), this.getRefProp1(), (IDataEntityProperty)fbasedataprop.getComplexType().getPrimaryKey(), fbasedataprop.getComplexType().getName());
        }
        filterField.setLastBasedataProp(this.getLatestParent());
        filterField.setMulBasedata(this.isMulBasedata());
        return filterField;
    }

    public boolean isDesensitizeField() {
        IDataEntityProperty prop = PrivacyCenterTools.isDesensitized(this, "LIST");
        return prop != null;
    }

    public boolean isDesenAndNoSearch() {
        IDataEntityProperty prop = PrivacyCenterTools.isDesensitized(this, "LIST");
        if (prop != null) {
            boolean isSupportSearch = PrivacyDataCenterManager.getPermissionService().isSupportSearch();
            if (!isSupportSearch) {
                return true;
            }
            String strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)prop, (String)"LIST", null);
            if (StringUtils.isNotBlank((CharSequence)strategy)) {
                if ("CLICKVIEW".equals(strategy) || "PLAINTEXT".equals(strategy)) {
                    return false;
                }
                this.log.debug("\u8131\u654f\u5b57\u6bb5\u652f\u6301\u67e5\u8be2\u672a\u5f00\u542f\u6216\u8131\u654f\u7b56\u7565\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u8131\u654f\u5b57\u6bb5\uff1a{}", (Object)this.getCaption());
                return true;
            }
        }
        return false;
    }

    public boolean isEncryptField() {
        boolean isEncryptFields = false;
        IDataEntityProperty thisFieldProp = this.getSrcFieldProp();
        if (thisFieldProp != null && thisFieldProp.getParent() != null) {
            isEncryptFields = PrivacyCenterUtils.isEncryptField((IDataEntityProperty)thisFieldProp);
        }
        if (!isEncryptFields && this.getRefProp1() != null) {
            isEncryptFields = PrivacyCenterUtils.isEncryptField((IDataEntityProperty)this.getRefProp1());
        }
        if (!isEncryptFields && this.getRefProp2() != null) {
            isEncryptFields = PrivacyCenterUtils.isEncryptField((IDataEntityProperty)this.getRefProp2());
        }
        return isEncryptFields;
    }

    public boolean isVirtualFilterField() {
        return false;
    }

    private static /* synthetic */ boolean lambda$innerCreate$0(MainEntityType mainType, IDataEntityProperty property, DynamicProperty finalLastBasedataProp, CompareType p) {
        return mainType instanceof QueryEntityType && property instanceof JoinProperty && finalLastBasedataProp instanceof MulBasedataProp && ("<>".equals(p.getOperate()) || "NOT LIKE".equals(p.getOperate()) || "Not IN".equals(p.getOperate())) && !"NOTISNULL".equals(p.getValue());
    }

    static class QueryEntitySrcResult {
        private IDataEntityProperty dataEntityProperty;
        private MainEntityType mainType;
        private String joinPropertyName;

        QueryEntitySrcResult(IDataEntityProperty dataEntityProperty, MainEntityType mainType) {
            this.dataEntityProperty = dataEntityProperty;
            this.mainType = mainType;
        }

        IDataEntityProperty getDataEntityProperty() {
            return this.dataEntityProperty;
        }

        MainEntityType getMainType() {
            return this.mainType;
        }

        public String getJoinPropertyName() {
            return this.joinPropertyName;
        }

        public void setJoinPropertyName(String joinPropertyName) {
            this.joinPropertyName = joinPropertyName;
        }
    }
}

