/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.QFilterDto;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FilterParameter
implements ISupportInitialize,
Serializable {
    private static final long serialVersionUID = -4767110126621610758L;
    private List<String> selectFields = new ArrayList<String>();
    private List<String> selectFieldsWithNotCompare = new ArrayList<String>();
    private String selectEntity;
    private String orderBy;
    private List<SqlParameter> param = new ArrayList<SqlParameter>();
    private String qFilterString;
    private List<QFilterDto> filters = new ArrayList<QFilterDto>();
    private List<QFilter> qFilters = new ArrayList<QFilter>();
    private Map<String, String> convertFieldsMap = new HashMap<String, String>(16);

    public FilterParameter() {
    }

    public FilterParameter(QFilter qFilter, String orderBy) {
        this.orderBy = orderBy;
        if (qFilter != null) {
            this.qFilters.add(qFilter);
        }
    }

    public FilterParameter(List<String> selectFields, QFilter qFilter, String orderBy) {
        this.selectFields = selectFields;
        this.orderBy = orderBy;
        if (qFilter != null) {
            this.qFilters.add(qFilter);
        }
    }

    public FilterParameter(List<QFilter> qFilters, String orderBy) {
        this.orderBy = orderBy;
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                if (qFilter == null) continue;
                this.qFilters.add(qFilter);
            }
        }
    }

    public FilterParameter(List<String> selectFields, List<QFilter> qFilters, String orderBy) {
        this.selectFields = selectFields;
        this.orderBy = orderBy;
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                if (qFilter == null) continue;
                this.qFilters.add(qFilter);
            }
        }
    }

    public Map<String, String> getConvertFieldsMap() {
        return this.convertFieldsMap;
    }

    public void setConvertFieldsMap(Map<String, String> convertFieldsMap) {
        this.convertFieldsMap = convertFieldsMap;
    }

    @KSMethod
    @Deprecated
    public QFilter getOrgQFilter() {
        if (StringUtils.isNotBlank((CharSequence)this.qFilterString)) {
            return QFilter.fromSerializedString((String)this.qFilterString);
        }
        return null;
    }

    @Deprecated
    @CollectionPropertyAttribute(collectionItemPropertyType=QFilterDto.class)
    public List<QFilterDto> getFilters() {
        this.beginSerializedString();
        return this.filters;
    }

    @Deprecated
    public void setFilters(List<QFilterDto> filters) {
        this.filters = filters;
    }

    @JsonIgnore
    @KSMethod
    public void setQFilters(List<QFilter> qFilters) {
        this.qFilters.clear();
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                if (qFilter == null) continue;
                this.qFilters.add(qFilter);
            }
        }
    }

    @JsonIgnore
    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    @SimplePropertyAttribute
    @Deprecated
    public String getQFilter() {
        return this.qFilterString;
    }

    @Deprecated
    public void setQFilter(String qFilter) {
        if (StringUtils.isNotBlank((CharSequence)qFilter)) {
            this.qFilters.add(QFilter.fromSerializedString((String)qFilter));
        }
    }

    @KSMethod
    public void setFilter(QFilter qFilter) {
        if (qFilter != null) {
            this.qFilters.add(qFilter);
        }
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=SqlParameter.class)
    @KSMethod
    public List<SqlParameter> getParam() {
        return this.param;
    }

    @KSMethod
    public void setParam(List<SqlParameter> param) {
        this.param = param;
    }

    public void mergeFilter(FilterParameter filter) {
    }

    @SimplePropertyAttribute
    public List<String> getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(List<String> selectFields) {
        this.selectFields = selectFields;
    }

    @SimplePropertyAttribute
    public List<String> getSelectFieldsWithNotCompare() {
        return this.selectFieldsWithNotCompare;
    }

    public void setSelectFieldsWithNotCompare(List<String> selectFieldsWithNotCompare) {
        this.selectFieldsWithNotCompare = selectFieldsWithNotCompare;
    }

    @SimplePropertyAttribute
    public String getSelectEntity() {
        return this.selectEntity;
    }

    public void setSelectEntity(String selectEntity) {
        this.selectEntity = selectEntity;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getOrderBy() {
        return this.orderBy;
    }

    @KSMethod
    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    private void beginSerializedString() {
        this.filters.clear();
        for (QFilter qFilter : this.qFilters) {
            if (qFilter == null) continue;
            this.filters.add(new QFilterDto(qFilter.toSerializedString()));
        }
    }

    public void beginInit() {
        this.qFilters.clear();
    }

    public void endInit() {
        for (QFilterDto qFilterDto : this.filters) {
            this.qFilters.add(QFilter.fromSerializedString((String)qFilterDto.getFilter()));
        }
    }

    public boolean isInitialized() {
        return false;
    }
}

