/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.ConditionVariableFactory;
import kd.bos.entity.filter.FieldName;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterResult;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.IConditionVariableAnalysis;
import kd.bos.entity.filter.JavaTypeParseChecker;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.service.IUserService;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.service.TransType;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class FilterRow {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static final String BETWEEN = "BETWEEN";
    private static final String NOT_IN = "NOT IN";
    private static final String FORMAT = "%s %s ?";
    private static final String FORMAT1 = "%s %s %s";
    private FilterObject filterObject;
    private FilterField fieldField;
    private String leftBracket;
    private CompareType compareType;
    private List<String> valueList;
    private String rightBracket;
    private LogicOperate logic;
    private int rowIndex;
    private String ormFieldName;
    protected MainEntityType dataType;
    private boolean isNeedParse = true;

    public FilterRow(MainEntityType dataType, FilterObject filterObject, FilterField fieldField, String leftBracket, CompareType compareType, List<String> valueList, String rightBracket, LogicOperate logic) {
        this.dataType = dataType;
        this.filterObject = filterObject;
        this.fieldField = fieldField;
        this.leftBracket = leftBracket;
        this.compareType = compareType;
        this.valueList = valueList;
        this.rightBracket = rightBracket;
        this.logic = logic;
    }

    public void setNeedParse(boolean isNeedParse) {
        this.isNeedParse = isNeedParse;
    }

    public String getORMFieldName() {
        if (StringUtils.isBlank((CharSequence)this.ormFieldName)) {
            FieldName fieldName;
            this.ormFieldName = StringUtils.isNotBlank((CharSequence)this.getFilterField().getFullFieldName()) ? this.getFilterField().getFullFieldName() : ((fieldName = EntityTypeUtil.getORMFieldName(this.getFilterField().getFieldName(), this.dataType)) != null ? fieldName.getFieldName() : this.getFilterField().getFieldName());
        }
        return this.ormFieldName;
    }

    public MainEntityType getDataType() {
        return this.dataType;
    }

    public void setDataType(MainEntityType dataType) {
        this.dataType = dataType;
    }

    public FilterField getFilterField() {
        return this.fieldField;
    }

    public void setFilterField(FilterField fieldField) {
        this.fieldField = fieldField;
    }

    @SimplePropertyAttribute
    public String getLeftBracket() {
        return this.leftBracket;
    }

    public void setLeftBracket(String leftBracket) {
        this.leftBracket = leftBracket;
    }

    @ComplexPropertyAttribute
    public CompareType getCompareType() {
        return this.compareType;
    }

    public void setCompareType(CompareType compareType) {
        this.compareType = compareType;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=String.class)
    public List<String> getValue() {
        return this.valueList;
    }

    public void setValue(List<String> valueList) {
        this.valueList = valueList;
    }

    @SimplePropertyAttribute
    public String getRightBracket() {
        return this.rightBracket;
    }

    public void setRightBracket(String rightBracket) {
        this.rightBracket = rightBracket;
    }

    @ComplexPropertyAttribute
    public LogicOperate getLogic() {
        return this.logic;
    }

    public void setLogic(LogicOperate logic) {
        this.logic = logic;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    @SdkInternal
    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    private void addSqlParameter(String field, int sqlType, String value) {
        SqlParameter sqlParam = sqlType == 5 ? new SqlParameter(field, sqlType, (Object)Short.parseShort(value)) : (sqlType == -6 ? new SqlParameter(field, sqlType, (Object)Byte.parseByte(value)) : (sqlType == 4 ? new SqlParameter(field, sqlType, (Object)Integer.parseInt(value)) : (sqlType == -5 ? new SqlParameter(field, sqlType, (Object)Long.parseLong(value)) : (sqlType == 7 ? new SqlParameter(field, sqlType, (Object)Float.valueOf(Float.parseFloat(value))) : (sqlType == 6 || sqlType == 8 ? new SqlParameter(field, sqlType, (Object)Double.parseDouble(value)) : (sqlType == 3 || sqlType == 2 ? new SqlParameter(field, sqlType, (Object)BigDecimal.valueOf(Double.parseDouble(value))) : (sqlType == -7 ? new SqlParameter(field, sqlType, (Object)Boolean.parseBoolean(value)) : new SqlParameter(field, sqlType, (Object)value))))))));
        this.filterObject.getParam().add(sqlParam);
    }

    private String getKSQlFormat(Date dateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/M/d H:m:s");
        return "{ts'" + simpleDateFormat.format(dateTime) + "'}";
    }

    private String getUnaryString(String field, String operater, Date dateTime, int sqlType) {
        this.addSqlParameter(field, sqlType, this.getKSQlFormat(dateTime));
        return field + operater + "?";
    }

    Date toSystemDate(Date datetime) {
        return datetime;
    }

    FilterResult getBetweenTimeString(String ormFieldName, String fieldName, Date minDateTime, Date maxDateTime, int sqlType) {
        if (this.isCheckInput() && minDateTime.after(maxDateTime)) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u5f00\u59cb\u65f6\u95f4%2$s\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4%3$s", (String)"FilterRow_17", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getFilterField().getCaption(), minDateTime, maxDateTime)});
        }
        QFilter qFilter1 = new QFilter(ormFieldName, ">=", (Object)minDateTime);
        QFilter qFilter2 = new QFilter(ormFieldName, "<", (Object)maxDateTime);
        QFilter qFilter = qFilter1.and(qFilter2);
        this.addSqlParameter(fieldName, sqlType, this.getKSQlFormat(minDateTime));
        this.addSqlParameter(fieldName, sqlType, this.getKSQlFormat(maxDateTime));
        String filter = "(" + fieldName + ">=? and " + fieldName + "<?)";
        return new FilterResult(new String[]{filter, filter}, qFilter);
    }

    FilterResult getCompareDateTimeString(String ormFieldName, String fieldName, String operator1, int sqlType, Date ... datetimes) {
        if (BETWEEN.equalsIgnoreCase(operator1)) {
            return this.getBetweenTimeString(ormFieldName, fieldName, datetimes[0], datetimes[1], sqlType);
        }
        throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u5b9e\u73b0\u7684\u64cd\u4f5c\u7b26", (String)"FilterRow_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
    }

    private Date parseDate(String value) {
        try {
            return KDDateFormatUtils.getDateFormat((TimeZone)KDDateUtils.getSysTimeZone()).parse(value);
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)"FilterRow_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), value)});
        }
    }

    private Date parseDateTime(String value, boolean isLongDateToShotDate, TransType transType) {
        if (isLongDateToShotDate) {
            return KDDateUtils.parseDate((String)value);
        }
        if (transType == TransType.USERTIMEZONE) {
            return KDDateUtils.parseDateTime((String)value);
        }
        return KDDateUtils.parseToSystemTimeZoneDateTime((String)value);
    }

    private FilterResult getDateTimeFilterString(String ormFieldName, String fieldName, int addTimeUnit, int dateType, boolean isLongDateToShotDate, TransType transType) {
        if ("between".equalsIgnoreCase(this.getCompareType().getOperate())) {
            return this.doBetweenDateTimeParse(ormFieldName, fieldName, addTimeUnit, dateType, isLongDateToShotDate, transType);
        }
        return this.doDateTimeParse(ormFieldName, fieldName, addTimeUnit, dateType, isLongDateToShotDate, transType);
    }

    private FilterResult doDateTimeParse(String ormFieldName, String fieldName, int addTimeUnit, int dateType, boolean isLongDateToShotDate, TransType transType) {
        Date maxDateTime;
        Date dateTime;
        if (dateType == 91) {
            Date date = this.parseDate(this.getValue().get(0));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            dateTime = date;
            ((Calendar)calendar).add(5, 1);
            maxDateTime = calendar.getTime();
        } else {
            dateTime = this.parseDateTime(this.getValue().get(0), isLongDateToShotDate, transType);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTime);
            if (isLongDateToShotDate) {
                ((Calendar)calendar).add(5, 1);
            } else {
                ((Calendar)calendar).add(addTimeUnit, 1);
            }
            maxDateTime = calendar.getTime();
        }
        if (this.getCompareType().getOperate().trim().equals("=")) {
            return this.getCompareDateTimeString(ormFieldName, fieldName, BETWEEN, dateType, dateTime, this.toSystemDate(maxDateTime));
        }
        if (this.getCompareType().getOperate().trim().equals("<=") || this.getCompareType().getOperate().trim().equals(">")) {
            String operate = this.getCompareType().getOperate().trim().equals("<=") ? "<" : ">=";
            String filter = this.getUnaryString(fieldName, operate, this.toSystemDate(maxDateTime), dateType);
            QFilter qFilter = new QFilter(ormFieldName, operate, (Object)this.toSystemDate(maxDateTime));
            return new FilterResult(new String[]{filter, filter}, qFilter);
        }
        if (this.getCompareType().getOperate().trim().equals("<>")) {
            String c1 = this.getUnaryString(fieldName, "<", this.toSystemDate(dateTime), dateType);
            String c2 = this.getUnaryString(fieldName, ">=", this.toSystemDate(maxDateTime), dateType);
            String filter = String.format("(%s OR %s)", c1, c2);
            QFilter qFilter1 = new QFilter(ormFieldName, "<", (Object)this.toSystemDate(dateTime));
            QFilter qFilter2 = new QFilter(ormFieldName, ">=", (Object)this.toSystemDate(maxDateTime));
            return new FilterResult(new String[]{filter, filter}, qFilter1.or(qFilter2));
        }
        String filter = this.getUnaryString(fieldName, this.getCompareType().getOperate(), this.toSystemDate(dateTime), dateType);
        QFilter qFilter = new QFilter(ormFieldName, this.getCompareType().getOperate(), (Object)this.toSystemDate(dateTime));
        return new FilterResult(new String[]{filter, filter}, qFilter);
    }

    private FilterResult doBetweenDateTimeParse(String ormFieldName, String fieldName, int addTimeUnit, int dateType, boolean isLongDateToShotDate, TransType transType) {
        Date dateTime2;
        Date dateTime1;
        if (dateType == 91) {
            dateTime1 = this.parseDate(this.getValue().get(0));
            dateTime2 = this.parseDate(this.getValue().get(1));
        } else {
            dateTime1 = this.parseDateTime(this.getValue().get(0), isLongDateToShotDate, transType);
            dateTime2 = this.parseDateTime(this.getValue().get(1), isLongDateToShotDate, transType);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime2);
        calendar.add(addTimeUnit, 1);
        return this.getCompareDateTimeString(ormFieldName, fieldName, BETWEEN, dateType, dateTime1, calendar.getTime());
    }

    private void checkIsEmtry() {
        if (this.getValue().get(0).trim().length() == 0) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u672a\u8f93\u5165\u6bd4\u8f83\u503c", (String)"FilterRow_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldField.getCaption())});
        }
    }

    private boolean isNumeric(String value, boolean bThrowErr) {
        boolean isOk;
        block2: {
            isOk = true;
            try {
                new BigDecimal(value);
            }
            catch (Exception e) {
                isOk = false;
                if (!bThrowErr) break block2;
                throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"FilterRow_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldField.getCaption())});
            }
        }
        return isOk;
    }

    private boolean isUnit(String value, boolean bThrowErr) {
        Pattern pattern = Pattern.compile("^[1-9]\\d*$");
        Matcher matcher = pattern.matcher(value.trim());
        boolean isOk = matcher.matches();
        if (bThrowErr && !isOk) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u6b63\u6574\u6570\u3002", (String)"FilterRow_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldField.getCaption())});
        }
        return isOk;
    }

    public boolean isInt(String value, boolean bThrowErr) {
        Pattern pattern = Pattern.compile("^[+-]?\\d*$");
        Matcher matcher = pattern.matcher(value.trim());
        boolean isOk = matcher.matches();
        if (bThrowErr && !isOk) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u6b63\u6574\u6570\u3002", (String)"FilterRow_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldField.getCaption())});
        }
        return isOk;
    }

    private boolean isNumberField(int fieldType) {
        return fieldType == -7 || fieldType == -5 || fieldType == 3 || fieldType == 6 || fieldType == 4 || fieldType == 2 || fieldType == 7 || fieldType == 5 || fieldType == -6 || fieldType == 8;
    }

    private boolean isCheckInput() {
        return this.filterObject.isCheckInput();
    }

    private String[] checkInputValue() {
        String[] result = new String[2];
        String value = "";
        String valueDesc = "";
        if (!this.getValue().isEmpty()) {
            value = this.getValue().get(0);
        }
        valueDesc = value;
        if (StringUtils.isBlank((CharSequence)value) || !this.isCheckInput()) {
            result[0] = value;
            result[1] = valueDesc;
            return result;
        }
        String strtmp = "";
        String operateStr = this.getCompareType().getOperate().trim();
        int fieldType = this.getFilterField().getFieldType();
        if (operateStr.equals("=") || operateStr.equals("==") || operateStr.equals("!=") || operateStr.equals("<=") || operateStr.equals(">=") || operateStr.equals(">") || operateStr.equals("<") || operateStr.equals("<>") || operateStr.equals("LIKE") || operateStr.equals("lIKE") || operateStr.equals("like") || operateStr.equalsIgnoreCase("NOT LIKE")) {
            strtmp = this.checkIsNumber(value, fieldType);
        } else if (operateStr.equalsIgnoreCase("IN") || operateStr.equalsIgnoreCase(NOT_IN)) {
            String marks = "";
            FilterMetadata filterMetadata = this.filterObject.getFilterMetaData();
            if (filterMetadata != null && StringUtils.isEmpty((CharSequence)(marks = filterMetadata.getMarks()))) {
                marks = "'";
            }
            if (this.isNumberField(fieldType)) {
                ArrayList<String> svalueList = new ArrayList<String>(10);
                for (String sValue : this.getValue()) {
                    svalueList.add(this.checkIsNumber(value, fieldType));
                }
                strtmp = String.join((CharSequence)",", svalueList);
            } else {
                strtmp = String.join((CharSequence)(marks + "," + marks), this.getValue());
            }
            strtmp = "(" + strtmp + ")";
        } else if (operateStr.equalsIgnoreCase(BETWEEN)) {
            String value1 = this.getValue().get(0);
            String value2 = this.getValue().get(1);
            if (value1.trim().length() == 0 || value2.trim().length() == 0) {
                throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u8f93\u5165\u6bd4\u8f83\u503c\u4e0d\u5b8c\u6574", (String)"FilterRow_6", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldField.getCaption())});
            }
            strtmp = value1 + " AND " + value2;
        } else if (operateStr.equalsIgnoreCase("StatusAssistantEqualto")) {
            this.checkIsEmtry();
            if (value.equalsIgnoreCase("True")) {
                value = "1";
                valueDesc = ResManager.loadKDString((String)"\u662f", (String)"FilterRow_7", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]);
            } else if (value.equalsIgnoreCase("false")) {
                value = "0";
                valueDesc = ResManager.loadKDString((String)"\u5426", (String)"FilterRow_8", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]);
            }
            this.isInt(value, true);
            strtmp = value.trim();
        }
        result[0] = strtmp;
        result[1] = valueDesc;
        return result;
    }

    private String checkIsNumber(String value, int fieldType) {
        String strtmp;
        if (fieldType == 3 || fieldType == 6 || fieldType == 2 || fieldType == 7) {
            this.checkIsEmtry();
            this.isNumeric(value, true);
            strtmp = value.trim();
        } else if (fieldType == -5 || fieldType == 4 || fieldType == 5) {
            this.checkIsEmtry();
            this.isInt(value, true);
            strtmp = value.trim();
        } else if (fieldType == -6) {
            this.checkIsEmtry();
            this.isUnit(value, true);
            strtmp = value.trim();
        } else if (fieldType == 91 || fieldType == 92 || fieldType == 93 || fieldType == -7) {
            this.checkIsEmtry();
            strtmp = value.trim();
        } else {
            strtmp = value;
        }
        return strtmp;
    }

    private QFilter getQFilterBySqlTypes(String sFilter, String operater, int fieldType, List<String> values) {
        boolean notInOperate;
        QFilter qFilter = null;
        boolean bl = notInOperate = !"IN".equalsIgnoreCase(operater) && !"Not IN".equalsIgnoreCase(operater) && !values.isEmpty();
        if (fieldType == 5) {
            qFilter = this.buildQFilter(sFilter, operater, this.convertByType(values, Short::parseShort), notInOperate);
        } else if (fieldType == -6) {
            qFilter = this.buildQFilter(sFilter, operater, this.convertByType(values, Byte::parseByte), notInOperate);
        } else if (fieldType == 4) {
            qFilter = this.buildQFilter(sFilter, operater, this.convertByType(values, Integer::parseInt), notInOperate);
        } else if (fieldType == -5) {
            qFilter = this.buildQFilter(sFilter, operater, this.convertByType(values, Long::parseLong), notInOperate);
        } else if (fieldType == 7) {
            qFilter = this.buildQFilter(sFilter, operater, this.convertByType(values, Float::parseFloat), notInOperate);
        } else if (fieldType == 6 || fieldType == 8 || fieldType == 3 || fieldType == 2) {
            qFilter = this.buildQFilter(sFilter, operater, this.convertByType(values, BigDecimal::new), notInOperate);
        } else if (fieldType == -7) {
            qFilter = this.buildQFilter(sFilter, operater, this.convertByType(values, Boolean::parseBoolean), notInOperate);
        } else if (fieldType == 91 || fieldType == 92 || fieldType == 93) {
            FilterResult dateFilterResult = this.getDateFilterResult(this.getFilterField().getFieldName(), this.getFilterField().getFieldType());
            qFilter = dateFilterResult.getQFilter();
        } else {
            qFilter = this.buildQFilter(sFilter, operater, values, notInOperate);
        }
        return qFilter;
    }

    @NotNull
    private <R> List<R> convertByType(List<String> values, Function<String, R> function) {
        ArrayList<R> shorts = new ArrayList<R>(10);
        for (String value : values) {
            shorts.add(function.apply(value));
        }
        return shorts;
    }

    private QFilter buildQFilter(String sFilter, String operater, List<?> values, boolean notInOperate) {
        QFilter qFilter = notInOperate ? new QFilter(sFilter, operater, values.get(0)) : (NOT_IN.equalsIgnoreCase(this.getCompareType().getOperate()) ? (this.getFilterField().isMulBasedata() ? this.buildMulBaseDataNotQFilter(sFilter, "not in", values) : QFilter.notInContainsEmpty((String)sFilter, values)) : new QFilter(sFilter, operater, values));
        return qFilter;
    }

    private QFilter getQFilterBySqlTypes(String sFilter, String operater, int fieldType, String value) {
        QFilter qFilter = null;
        if (!this.isCheckInput()) {
            return qFilter;
        }
        if (fieldType == 5) {
            qFilter = new QFilter(sFilter, operater, (Object)JavaTypeParseChecker.parseShort(value));
        } else if (fieldType == -6) {
            qFilter = new QFilter(sFilter, operater, (Object)JavaTypeParseChecker.parseByte(value));
        } else if (fieldType == 4) {
            qFilter = new QFilter(sFilter, operater, (Object)JavaTypeParseChecker.parseInt(value));
        } else if (fieldType == -5) {
            qFilter = new QFilter(sFilter, operater, (Object)JavaTypeParseChecker.parseLong(value));
            if (this.getFilterField().getLatestParent() instanceof IBasedataField && this.getFilterField().getFieldProp() instanceof LongProp && "<>".equals(operater)) {
                qFilter = FilterUtil.decorateZero(qFilter);
            }
        } else {
            qFilter = fieldType == 7 ? new QFilter(sFilter, operater, (Object)JavaTypeParseChecker.parseBigDecimal(value)) : (fieldType == 6 || fieldType == 8 ? new QFilter(sFilter, operater, (Object)JavaTypeParseChecker.parseBigDecimal(value)) : (fieldType == 3 || fieldType == 2 ? new QFilter(sFilter, operater, (Object)JavaTypeParseChecker.parseBigDecimal(value)) : (fieldType == -7 ? new QFilter(sFilter, operater, (Object)JavaTypeParseChecker.parseBoolean(value)) : this.parseNotNumber(sFilter, operater, value))));
        }
        return qFilter;
    }

    private QFilter buildMulBaseDataNotQFilter(String property, String cp, Object value) {
        QFilter filter = cp.equals("not like") ? new QFilter(property, cp, value, (QFilterHint)QFilterHint.NOT_CONTAINS) : new QFilter(property, cp, value);
        int currentDot = property.indexOf(".");
        while (currentDot != -1) {
            filter.or(QFilter.notExists((String)property.substring(0, currentDot)));
            currentDot = property.indexOf(".", currentDot + 1);
        }
        return filter;
    }

    private QFilter parseNotNumber(String sFilter, String operater, String value) {
        boolean isMultiSelectBaseData = this.getFilterField().isMulBasedata();
        QFilter qFilter = "<>".equalsIgnoreCase(this.getCompareType().getOperate()) ? (isMultiSelectBaseData ? this.buildMulBaseDataNotQFilter(sFilter, "!=", value) : QFilter.notEqualsContainsEmpty((String)this.getORMFieldName(), (String)value)) : ("NOT LIKE".equalsIgnoreCase(this.getCompareType().getOperate()) ? (isMultiSelectBaseData ? this.buildMulBaseDataNotQFilter(sFilter, "not like", value) : QFilter.notLikeContainsEmpty((String)sFilter, (String)value)) : ("LIKE".equals(operater) ? new QFilter(sFilter, operater, (Object)value, (QFilterHint)QFilterHint.CONTAINS) : ("lIKE".equals(operater) ? new QFilter(sFilter, operater, (Object)value, (QFilterHint)QFilterHint.STARTWITH) : ("like".equals(operater) ? new QFilter(sFilter, operater, (Object)value, (QFilterHint)QFilterHint.ENDWITH) : new QFilter(sFilter, operater, (Object)value)))));
        return qFilter;
    }

    private FilterResult getJavaTypeFilterResult() {
        QFilter qFilter = null;
        String[] strSql = new String[]{"", ""};
        String fieldName = this.getFilterField().getFieldName();
        String fieldCaption = this.getFilterField().getCaption().toString();
        String sFilter = fieldName;
        String strFilterDesc = fieldCaption;
        String[] values = this.checkInputValue();
        String value = values[0];
        String valueDesc = this.getValueDesc();
        if (StringUtils.isBlank((CharSequence)value)) {
            return new FilterResult(strSql, (QFilter)null);
        }
        int fieldType = this.getFilterField().getFieldType();
        if (this.isNumberField(fieldType) && this.getCompareType().getOperate().equals("StatusAssistantEqualto")) {
            if ("1".equals(value)) {
                qFilter = this.getQFilterBySqlTypes(this.getORMFieldName(), "=", fieldType, value);
                this.addSqlParameter(fieldName, fieldType, value);
                sFilter = String.format(FORMAT, fieldName, "=");
                strFilterDesc = String.format(FORMAT1, fieldCaption, "=", "True");
            } else if ("0".equals(value)) {
                qFilter = QFilter.isNull((String)this.getORMFieldName());
                sFilter = String.format("%s %s", fieldName, " is null ");
                strFilterDesc = String.format(FORMAT1, fieldCaption, "=", "False");
            }
        } else if (fieldType == 91 || fieldType == 92 || fieldType == 93) {
            FilterResult filterResult1 = this.getDateFilterResult(fieldName, fieldType);
            sFilter = filterResult1.getFilterGroup()[0];
            strFilterDesc = String.format(FORMAT1, fieldCaption, this.getCompareType().getName(), this.getValueDesc());
            qFilter = filterResult1.getQFilter();
        } else {
            if ("IN".equalsIgnoreCase(this.getCompareType().getOperate()) || NOT_IN.equalsIgnoreCase(this.getCompareType().getOperate())) {
                qFilter = this.getQFilterBySqlTypes(this.getORMFieldName(), this.getCompareType().getOperate(), fieldType, this.getValue());
                sFilter = String.format(FORMAT1, fieldName, this.getCompareType().getOperate(), value);
            } else {
                qFilter = this.getQFilterBySqlTypes(this.getORMFieldName(), this.getCompareType().getOperate(), fieldType, value);
                this.addSqlParameter(fieldName, fieldType, value);
                sFilter = String.format(FORMAT, fieldName, this.getCompareType().getOperate());
            }
            strFilterDesc = String.format(FORMAT1, fieldCaption, this.getCompareType().getName(), valueDesc);
            if ("''".equals(value)) {
                if ("=".equals(this.getCompareType().getOperate())) {
                    sFilter = String.format("(%s OR %s IS NULL)", sFilter, this.getFilterField().getFieldName());
                    strFilterDesc = String.format(ResManager.loadKDString((String)"%s\u4e3a\u7a7a\u503c", (String)"FilterRow_9", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getFilterField().getCaption());
                } else if ("<>".equals(this.getCompareType().getOperate())) {
                    sFilter = String.format("( ISNULL(%s,' ')<>' ')", this.getFilterField().getFieldName());
                    strFilterDesc = String.format(ResManager.loadKDString((String)"%s\u4e0d\u4e3a\u7a7a\u503c", (String)"FilterRow_10", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getFilterField().getCaption());
                }
            }
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        return new FilterResult(new String[]{sFilter, strFilterDesc}, qFilter, qFilters);
    }

    private FilterResult getDateFilterResult(String fieldName, int fieldType) {
        boolean isLongDateToShotDate = this.fieldField.getFieldProp() instanceof DateTimeProp && ((DateTimeProp)this.fieldField.getFieldProp()).getRegionType() == 1;
        TransType transType = TransType.USERTIMEZONE;
        if (this.fieldField.getFieldProp() instanceof DateTimeProp) {
            transType = TransType.get((int)((DateTimeProp)this.fieldField.getFieldProp()).getTimeZoneTransType());
        }
        FilterResult filterResult1 = fieldType == 92 || fieldType == 93 ? this.getDateTimeFilterString(this.getORMFieldName(), fieldName, isLongDateToShotDate ? 5 : 13, isLongDateToShotDate ? 91 : 92, isLongDateToShotDate, transType) : this.getDateTimeFilterString(this.getORMFieldName(), fieldName, 5, 91, isLongDateToShotDate, transType);
        return filterResult1;
    }

    private FilterResult getComboxFilterResult() {
        String value = String.format("('%s')", String.join((CharSequence)"','", this.getValue()));
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"FilterRow_11", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldField.getCaption())});
        }
        QFilter qFilter = null;
        int fieldType = this.getFilterField().getFieldType();
        String fieldName = this.getFilterField().getFieldName();
        String fieldCaption = this.getFilterField().getCaption().toString();
        if (this.isNumberField(fieldType) && StringUtils.isEmpty((CharSequence)value)) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"FilterRow_11", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldField.getCaption())});
        }
        if (this.getCompareType().isFieldCompare()) {
            Iterator<String> fieldKey = this.getValue().get(0);
            FilterField filterField = null;
            if (this.filterObject.getCompareFilterFields().isEmpty()) {
                filterField = FilterField.create(this.dataType, (String)((Object)fieldKey));
            } else {
                for (String compareFieldKey : this.filterObject.getCompareFilterFields().keySet()) {
                    if (!compareFieldKey.equals(fieldKey)) continue;
                    filterField = this.filterObject.getCompareFilterFields().get(compareFieldKey);
                    break;
                }
            }
            if (filterField == null) {
                throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"%s\u6bd4\u8f83\u5b57\u6bb5\u4e0d\u5b58\u5728", (String)"FilterRow_12", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), fieldKey)});
            }
            String fullFieldKey = filterField.getFullFieldName();
            String exp = String.format(FORMAT1, this.getORMFieldName(), this.getCompareType().getOperate(), fullFieldKey);
            qFilter = QFilter.of((String)exp, (Object[])new Object[0]);
        } else {
            if (this.getFilterField().getFieldProp() instanceof MulComboProp) {
                for (String valueStr : this.valueList) {
                    QFilter thisQFilter = new QFilter(this.getORMFieldName(), this.getCompareType().getOperate(), (Object)("%," + valueStr + ",%"));
                    qFilter = qFilter == null ? thisQFilter : qFilter.and(thisQFilter);
                }
            } else {
                qFilter = this.getQFilterBySqlTypes(this.getORMFieldName(), this.getCompareType().getOperate(), fieldType, this.getValue());
            }
            for (String val : this.getValue()) {
                this.addSqlParameter(fieldName, fieldType, val);
            }
        }
        String strFilterDesc = String.format(FORMAT1, fieldCaption, this.getCompareType().getName(), this.getValueDesc());
        String sFilter = this.getCompareType().getOperate().equals("StatusEqualto") ? fieldName + " = ? " : (this.getCompareType().getOperate().equals("StatusUnequalto") ? fieldName + " <> ? " : String.format(FORMAT, fieldName, this.getCompareType().getOperate()));
        String[] filterGroup = new String[]{sFilter, strFilterDesc};
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        return new FilterResult(new String[]{sFilter, strFilterDesc}, qFilter, qFilters);
    }

    private String getValueDesc() {
        String itemCaption;
        if (this.getCompareType().isFieldCompare()) {
            Map<String, FilterField> compareFilterFields;
            String valueDesc = null;
            Map<String, FilterField> map = compareFilterFields = this.filterObject.getCompareFilterFields().size() == 0 ? this.filterObject.getAllFilterFields() : this.filterObject.getCompareFilterFields();
            if (compareFilterFields.containsKey(this.getValue().get(0))) {
                valueDesc = (String)compareFilterFields.get(this.getValue().get(0)).getCaption().getDefaultItem();
            }
            if (valueDesc == null) {
                String fieldKey = this.getValue().get(0);
                FilterField filterField = FilterField.create(this.dataType, fieldKey);
                valueDesc = filterField != null ? (String)filterField.getCaption().getDefaultItem() : fieldKey;
            }
            itemCaption = valueDesc;
        } else if (this.fieldField.isVirtualFilterField()) {
            if ("IN".equalsIgnoreCase(this.getCompareType().getOperate()) || NOT_IN.equalsIgnoreCase(this.getCompareType().getOperate())) {
                StringBuilder sb = new StringBuilder();
                this.getValue().forEach(item -> sb.append((String)item).append(';'));
                itemCaption = sb.substring(0, sb.length() - 1);
            } else {
                itemCaption = this.getValue().get(0);
            }
        } else {
            List<DynamicProperty> props = this.findPropertys(this.dataType, this.getFilterField().getFieldName());
            DynamicProperty fieldProp = props.get(props.size() - 1);
            if (fieldProp instanceof ComboProp) {
                StringBuilder sb = new StringBuilder();
                this.getValue().forEach(item -> sb.append(((ComboProp)fieldProp).getItemByName((String)item)).append(';'));
                itemCaption = sb.toString().substring(0, sb.length() - 1);
            } else if ("IN".equalsIgnoreCase(this.getCompareType().getOperate()) || NOT_IN.equalsIgnoreCase(this.getCompareType().getOperate())) {
                StringBuilder sb = new StringBuilder();
                if (fieldProp instanceof BooleanProp) {
                    this.getValue().forEach(item -> sb.append("1".equals(item) ? ResManager.loadKDString((String)"\u662f", (String)"FilterRow_7", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FilterRow_8", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])).append(';'));
                } else {
                    this.getValue().forEach(item -> sb.append((String)item).append(';'));
                }
                itemCaption = sb.toString().substring(0, sb.length() - 1);
            } else if (BETWEEN.equalsIgnoreCase(this.getCompareType().getOperate())) {
                StringBuilder sb = new StringBuilder();
                this.getValue().forEach(item -> sb.append((String)item).append(' '));
                itemCaption = sb.toString().substring(0, sb.length() - 1);
            } else {
                itemCaption = this.getValue().get(0);
                if (fieldProp instanceof BooleanProp) {
                    itemCaption = "1".equals(itemCaption) ? ResManager.loadKDString((String)"\u662f", (String)"FilterRow_7", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FilterRow_8", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]);
                }
            }
        }
        return itemCaption;
    }

    private List<DynamicProperty> findPropertys(MainEntityType mainType, String var) {
        ArrayList<DynamicProperty> props = new ArrayList<DynamicProperty>();
        String[] keys = var.split("\\.");
        MainEntityType parentType = mainType;
        StringBuilder strDebug = new StringBuilder();
        DynamicProperty parentProp = null;
        for (int i = 0; i < keys.length; ++i) {
            DynamicProperty prop = parentType instanceof EntityType ? (DynamicProperty)((EntityType)parentType).findProperty(keys[i]) : parentType.getProperty(keys[i]);
            if (prop == null && "id".equalsIgnoreCase(keys[i])) {
                prop = (DynamicProperty)parentType.getPrimaryKey();
            }
            if (prop == null && parentProp instanceof MulBasedataProp) {
                BasedataProp basedataProp = (BasedataProp)parentType.getProperty("fbasedataid");
                BasedataEntityType basedataEntityType = (BasedataEntityType)basedataProp.getComplexType();
                prop = (DynamicProperty)basedataEntityType.findProperty(keys[i]);
            }
            if (prop == null) {
                strDebug.append("prop isnull:").append(keys[i]).append(',');
                break;
            }
            parentProp = prop;
            props.add(prop);
            strDebug.append("prop add:").append(keys[i]).append('-').append(prop.getName()).append(",");
            if (prop instanceof EntryProp) {
                parentType = (DynamicObjectType)((EntryProp)prop).getItemType();
                continue;
            }
            if (prop instanceof BasedataProp) {
                parentType = (DynamicObjectType)((BasedataProp)prop).getComplexType();
                continue;
            }
            if (prop instanceof RefBillProp) {
                parentType = (DynamicObjectType)((RefBillProp)prop).getComplexType();
                continue;
            }
            if (!(prop instanceof MulBasedataProp)) break;
            parentType = ((MulBasedataProp)prop).getDynamicCollectionItemPropertyType();
        }
        if (props.size() < keys.length) {
            StringBuilder message = new StringBuilder();
            message.append(", mainType.name =");
            message.append(mainType.getName());
            message.append(", parentType.name =");
            message.append(parentType.getName());
            message.append(", mainType.props=");
            message.append(mainType.getProperties().toString());
            message.append(", parentType.props=");
            message.append(parentType.getProperties().toString());
            throw new KDBizException(BosErrorCode.variableNameNotFound, new Object[]{String.format(ResManager.loadKDString((String)"\u53d8\u91cf%s\u89e3\u6790\u5931\u8d25\uff0c\u5728\u5355\u636e\u4e0a\u627e\u4e0d\u5230", (String)"FilterRow_13", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), var) + message});
        }
        return props;
    }

    private FilterResult getConstFilterResult(IUserService userService) {
        String value = "";
        if (!this.getValue().isEmpty()) {
            value = this.getValue().get(0);
        }
        String compareValue = this.compareType.getValue().toUpperCase();
        if (this.compareType.isNeedInput() && StringUtils.isNotBlank((CharSequence)value) && ("NDAYSBEFORE".equalsIgnoreCase(compareValue) || "BEFORENDAYS".equalsIgnoreCase(compareValue))) {
            int parseInt = JavaTypeParseChecker.parseInt(this.getValue().get(0));
            if (this.getFilterField().getFieldType() == 91 && parseInt > 15000) {
                throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u8f93\u5165\u5185\u5bb9\u4e0d\u57280\u523015000\u4e4b\u95f4", (String)"FilterRow_14", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
            }
            return this.getConstFilterResult(userService, parseInt);
        }
        return this.getConstFilterResult(userService, 0);
    }

    private FilterResult getConstFilterResult(IUserService userService, int constantEnum) {
        if (StringUtils.isNotBlank((CharSequence)this.compareType.getClassName())) {
            ConditionVariableContext ctx = new ConditionVariableContext(this.filterObject, this);
            ctx.setUserService(userService);
            ctx.setParam(true);
            ctx.setConstantValue(constantEnum);
            ctx.setInteService(this.filterObject.getInteService());
            if (this.getCompareType().isNeedInput() && !this.getValue().isEmpty()) {
                ctx.setInputValue(this.getValue().get(0));
                if (this.getCompareType().isNumber() && !this.getValue().get(0).equals(this.getCompareType().getId())) {
                    ctx.setInputNumber(JavaTypeParseChecker.parseInt(this.getValue().get(0)));
                }
            }
            IConditionVariableAnalysis analysis = ConditionVariableFactory.getSingleInstance().getOrRegisterVariableInstance(this.compareType.getClassName());
            analysis.getVariableFilter(ctx);
            this.filterObject.getParam().addAll(ctx.getParam());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(ctx.getQFilter());
            return new FilterResult(new String[]{ctx.getFilter(), this.getCompareType().isNeedInput() ? String.format("%1$s %2$s %3$s", this.getFilterField().getCaption().toString(), this.getCompareType().getName(), this.getValueDesc()) : String.format(ResManager.loadKDString((String)"%1$s \u4e3a %2$s", (String)"FilterRow_18", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getFilterField().getCaption().toString(), this.getCompareType().getName())}, ctx.getQFilter(), qFilters);
        }
        throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u53d8\u91cf\u7684\u503c:%s", (String)"FilterRow_16", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.compareType.getValue().toUpperCase())});
    }

    private boolean isCompareConstValue() {
        if (!this.getCompareType().isNeedInput()) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCompareType().getClassName())) {
            return true;
        }
        String compareValue = this.getCompareType().getValue();
        return "TODAYBEFORE".equalsIgnoreCase(compareValue) || "TODAYAFTER".equalsIgnoreCase(compareValue);
    }

    public FilterResult getFilterResult() {
        FilterResult filterResult = new FilterResult(new String[]{"", ""}, (QFilter)null);
        if (!this.isNeedParse) {
            return filterResult;
        }
        if (!this.isCompareConstValue()) {
            switch (this.getCompareType().getInputCtlType()) {
                case 0: {
                    filterResult = this.getJavaTypeFilterResult();
                    filterResult.setEmpty(false);
                    break;
                }
                case 1: {
                    filterResult = this.getComboxFilterResult();
                    filterResult.setEmpty(false);
                    break;
                }
            }
        } else if (!this.getCompareType().isFieldCompare()) {
            filterResult = this.getConstFilterResult(this.filterObject.getUserService());
            filterResult.setEmpty(false);
        }
        return filterResult;
    }
}

