/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter.constants;

import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.IConditionVariableAnalysis;
import kd.bos.entity.filter.constants.DateTimeAnalysisUtils;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.service.KDDateUtils;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;

abstract class DateRangeAnalysis
implements IConditionVariableAnalysis {
    private String startDateCompareType = ">=";
    private String finishDateCompareType = "<";
    private int constantValue;
    private boolean isShortDate;
    DayOfWeek firstDayOfweek = DayOfWeek.MONDAY;
    private List<String> valueList;

    DateRangeAnalysis() {
    }

    abstract Date getStartDate();

    abstract Date getFinishDate();

    int getConstantValue() {
        return this.constantValue;
    }

    String getStartDateStr() {
        if (CollectionUtils.isNotEmpty(this.valueList)) {
            return this.valueList.get(0);
        }
        return null;
    }

    String getEndDateStr() {
        if (CollectionUtils.isNotEmpty(this.valueList)) {
            if (this.valueList.size() == 1) {
                return this.valueList.get(0);
            }
            if (this.valueList.size() > 1) {
                return this.valueList.get(1);
            }
        }
        return null;
    }

    Date getBaseToday() {
        if (!this.isShortDate) {
            return KDDateUtils.userTimeZoneToSystemTimeZoneToday();
        }
        return KDDateUtils.today();
    }

    TimeZone getUserTimeZone() {
        if (!this.isShortDate) {
            return KDDateUtils.getUserTimeZone();
        }
        return KDDateUtils.getSysTimeZone();
    }

    boolean isShortDate() {
        return this.isShortDate;
    }

    Date addDays(int diff) {
        return DateUtils.addDays((Date)this.getBaseToday(), (int)diff);
    }

    Date getTheMonthWithoutOffsetStart(int diff) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.getBaseToday());
        ((Calendar)calendar).add(2, diff);
        return calendar.getTime();
    }

    @Override
    public void getVariableFilter(ConditionVariableContext ctx) {
        this.initLocaleContextVariable(ctx);
        DateTimeAnalysisUtils dta = new DateTimeAnalysisUtils(ctx.isParam());
        DateRange dateRange = this.getDateRange();
        if (ctx.isParam()) {
            if (dateRange.getStartDate() != null) {
                SqlParameter sqlParam1 = new SqlParameter(ctx.getFieldName(), ctx.getColType(), (Object)dateRange.getStartDate());
                ctx.getParam().add(sqlParam1);
            }
            if (dateRange.getFinishDate() != null) {
                SqlParameter sqlParam2 = new SqlParameter(ctx.getFieldName(), ctx.getColType(), (Object)dateRange.getFinishDate());
                ctx.getParam().add(sqlParam2);
            }
        }
        if (dateRange.getStartDate() != null && dateRange.getFinishDate() == null) {
            ctx.setFilter(dta.getUnaryString(ctx.getFieldName(), this.startDateCompareType, dateRange.getStartDate()));
            ctx.setQFilter(dta.getUnaryQFilter(ctx.getFieldName(), this.startDateCompareType, dateRange.getStartDate()));
        } else if (dateRange.getStartDate() == null && dateRange.getFinishDate() != null) {
            ctx.setFilter(dta.getUnaryString(ctx.getFieldName(), this.finishDateCompareType, dateRange.getFinishDate()));
            ctx.setQFilter(dta.getUnaryQFilter(ctx.getFieldName(), this.finishDateCompareType, dateRange.getFinishDate()));
        } else {
            ctx.setFilter(dta.getCompareDateTimeString(ctx.getFieldName(), ctx.getOperater(), dateRange.getStartDate(), dateRange.getFinishDate()));
            ctx.setQFilter(dta.getCompareDateTimeQFilter(ctx.getFieldName(), ctx.getOperater(), dateRange.getStartDate(), dateRange.getFinishDate()));
        }
    }

    private void initLocaleContextVariable(ConditionVariableContext ctx) {
        Object firstDayOfWeek;
        IDataEntityProperty srcFieldProp = ctx.getFilterRow().getFilterField().getSrcFieldProp();
        this.isShortDate = srcFieldProp instanceof DateTimeProp && ((DateTimeProp)srcFieldProp).getRegionType() == 1 || srcFieldProp instanceof DateProp;
        this.constantValue = ctx.getConstantValue();
        this.valueList = ctx.getFilterRow().getValue();
        HashMap calendarFormat = (HashMap)ctx.getInteService().getUserFormat(Long.valueOf(RequestContext.getOrCreate().getCurrUserId())).get("calendarFormat");
        if (calendarFormat != null && (firstDayOfWeek = calendarFormat.get("firstDayOfWeek")) != null) {
            int firstDayOfWeekInt = Integer.parseInt(firstDayOfWeek.toString());
            if (firstDayOfWeekInt == 0) {
                this.firstDayOfweek = DayOfWeek.SUNDAY;
            } else if (firstDayOfWeekInt >= 1 && firstDayOfWeekInt <= 6) {
                this.firstDayOfweek = DayOfWeek.of(firstDayOfWeekInt);
            }
        }
    }

    @Override
    public void getScriptFilter(ConditionVariableContext ctx) {
        this.initLocaleContextVariable(ctx);
        DateRange dateRange = this.getDateRange();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (dateRange.getStartDate() != null && dateRange.getFinishDate() == null) {
            String time = formatter.format(dateRange.getStartDate());
            String script = String.format("(%s %s DATE('%s'))", ctx.getFieldName(), this.startDateCompareType, time);
            ctx.setScript(script);
        } else if (dateRange.getStartDate() == null && dateRange.getFinishDate() != null) {
            String time = formatter.format(dateRange.getFinishDate());
            String script = String.format("(%s %s DATE('%s'))", ctx.getFieldName(), this.finishDateCompareType, time);
            ctx.setScript(script);
        } else {
            String time1 = formatter.format(dateRange.getStartDate());
            String time2 = formatter.format(dateRange.getFinishDate());
            String script = String.format("(%s %s DATE('%s') and %s %s DATE('%s'))", ctx.getFieldName(), this.startDateCompareType, time1, ctx.getFieldName(), this.finishDateCompareType, time2);
            ctx.setScript(script);
        }
    }

    private DateRange getDateRange() {
        Date date2;
        Date date1;
        Date startDate = this.getStartDate();
        Date finishDate = this.getFinishDate();
        if (startDate != null && finishDate != null && startDate.after(finishDate)) {
            date1 = finishDate;
            date2 = startDate;
        } else {
            date1 = startDate;
            date2 = finishDate;
        }
        return new DateRange(date1, date2);
    }

    static class DateRange {
        Date startDate;
        Date finishDate;

        public DateRange(Date startDate, Date finishDate) {
            this.startDate = startDate;
            this.finishDate = finishDate;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getFinishDate() {
            return this.finishDate;
        }

        public void setFinishDate(Date finishDate) {
            this.finishDate = finishDate;
        }
    }
}

