/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter.constants;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang.NotImplementedException;

class DateTimeAnalysisUtils {
    private boolean isParam;

    DateTimeAnalysisUtils(boolean isParam) {
        this.isParam = isParam;
    }

    String getUnaryString(String field, String operater, Date dateTime) {
        if (this.isParam) {
            return field + operater + "?";
        }
        return field + operater + this.getKSQlFormat(dateTime);
    }

    QFilter getUnaryQFilter(String field, String operater, Date dateTime) {
        return new QFilter(field, operater, (Object)dateTime);
    }

    String getBetweenTimeString(String field, Date minDateTime, Date maxDateTime) {
        if (this.isParam) {
            return "(" + field + ">=? and " + field + "<?)";
        }
        return "(" + field + ">=" + this.getKSQlFormat(minDateTime) + " and " + field + "<" + this.getKSQlFormat(maxDateTime) + ")";
    }

    QFilter getBetweenTimeQFilter(String field, Date minDateTime, Date maxDateTime) {
        return new QFilter(field, ">=", (Object)minDateTime).and(new QFilter(field, "<", (Object)maxDateTime));
    }

    String getNULLString(String field, boolean isNull) {
        return isNull ? "(" + field + "={ts''})" : "(" + field + "!={ts''})";
    }

    QFilter getNULLQFilter(String field, boolean isNull) {
        return isNull ? new QFilter(field, "=", (Object)"{ts''}") : new QFilter(field, "!=", (Object)"{ts''}");
    }

    String getCompareDateTimeString(String field, String operator1, Date minDateTime, Date maxDateTime) {
        switch (operator1.toUpperCase(Locale.ENGLISH)) {
            case "BETWEEN": {
                return this.getBetweenTimeString(field, minDateTime, maxDateTime);
            }
            case "=": {
                return this.getNULLString(field, true);
            }
            case "<>": {
                return this.getNULLString(field, false);
            }
        }
        throw new NotImplementedException();
    }

    QFilter getCompareDateTimeQFilter(String field, String operator1, Date minDateTime, Date maxDateTime) {
        switch (operator1.toUpperCase(Locale.ENGLISH)) {
            case "BETWEEN": {
                return this.getBetweenTimeQFilter(field, minDateTime, maxDateTime);
            }
            case "=": {
                return this.getNULLQFilter(field, true);
            }
            case "<>": {
                return this.getNULLQFilter(field, false);
            }
        }
        throw new NotImplementedException();
    }

    private String getKSQlFormat(Date dateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d H:m:s");
        return "{ts'" + simpleDateFormat.format(dateTime) + "'}";
    }
}

