/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.flex;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.service.ITimeService;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FlexBDValueCondition {
    LocaleString description;
    FilterCondition filterCondition;
    String expression;

    public FilterCondition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(FilterCondition filterCondition) {
        this.filterCondition = filterCondition;
    }

    public LocaleString getDescription() {
        return this.description;
    }

    public void setDescription(LocaleString description) {
        this.description = description;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String buildFullFormula(MainEntityType mainType) {
        String gridFormula = "";
        String handFormula = this.getExpression();
        if (this.filterCondition != null && this.filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, this.filterCondition);
            filterBuilder.setTimeService((ITimeService)new TimeService());
            String[] filterScripts = filterBuilder.buildFilterScript();
            gridFormula = filterScripts[0];
        }
        String fullFormula = this.joinFilter(gridFormula, handFormula);
        return fullFormula;
    }

    private String joinFilter(String filter1, String filter2) {
        if (StringUtils.isBlank((CharSequence)filter1)) {
            return filter2;
        }
        if (StringUtils.isBlank((CharSequence)filter2)) {
            return filter1;
        }
        return String.format("(%s) and (%s)", filter1, filter2);
    }
}

