/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.format;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.CurrencyPrefixType;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormat;
import kd.bos.exception.KDBizException;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class CurrencyFormat
extends NumberFormat {
    public static final String fixCurrencySymbol = "\u00a5";

    @Override
    public Format getCurrencyFormat(String pattern, String currencySymbols, int minimumFractionDigits) {
        DecimalFormat format = null;
        String runPattern = StringUtils.isBlank((CharSequence)pattern) ? "0" : pattern;
        try {
            format = new DecimalFormat(runPattern);
        }
        catch (IllegalArgumentException e) {
            throw new KDBizException(this.buildIllegalPatternMsg(runPattern));
        }
        format.setRoundingMode(RoundingMode.HALF_UP);
        format.setPositivePrefix(currencySymbols);
        format.setNegativePrefix(currencySymbols + "-");
        format.setMinimumFractionDigits(minimumFractionDigits);
        return format;
    }

    @Override
    public Format getCurrencyFormat(String pattern, String currencySymbols, int maximumFractionDigits, int minimumFractionDigits) {
        DecimalFormat format = null;
        String runPattern = StringUtils.isBlank((CharSequence)pattern) ? "0" : pattern;
        try {
            format = new DecimalFormat(runPattern);
        }
        catch (IllegalArgumentException e) {
            throw new KDBizException(this.buildIllegalPatternMsg(runPattern));
        }
        format.setRoundingMode(RoundingMode.HALF_UP);
        format.setPositivePrefix(currencySymbols);
        format.setNegativePrefix(currencySymbols + "-");
        format.setMaximumFractionDigits(maximumFractionDigits);
        format.setMinimumFractionDigits(minimumFractionDigits);
        return format;
    }

    @Override
    <T> Format newFormat(T t) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getCurrencyInstance();
        CurrencyFormatObject cfo = (CurrencyFormatObject)t;
        df.setRoundingMode(RoundingMode.HALF_UP);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator(cfo.getNumSeparator() == 'b' ? (char)' ' : (char)cfo.getNumSeparator());
        symbols.setMonetaryDecimalSeparator(cfo.getDecimalPoint());
        int groupSepIndex = 3;
        if (!cfo.isGroupingUsed()) {
            df.setGroupingUsed(false);
        } else if (StringUtils.isNotBlank((CharSequence)cfo.getNumGroupFormat())) {
            groupSepIndex = cfo.getNumGroupFormat().lastIndexOf(44);
            if (groupSepIndex == -1) {
                df.setGroupingUsed(false);
            } else {
                int size = cfo.getNumGroupFormat().length() - groupSepIndex - 1;
                df.setGroupingSize(size);
            }
        } else {
            df.setGroupingSize(groupSepIndex);
        }
        if (cfo.getMaximumFractionDigits() > -1) {
            df.setMaximumFractionDigits(cfo.getMaximumFractionDigits());
        } else {
            df.setMaximumFractionDigits(cfo.getMinimumFractionDigits());
        }
        df.setMinimumFractionDigits(cfo.getMinimumFractionDigits());
        df.setDecimalFormatSymbols(symbols);
        this.setPositive(df, cfo);
        this.setNegative(df, cfo);
        return df;
    }

    @Override
    public Format getFormat(FormatObject formatObject) {
        if (formatObject == null) {
            return null;
        }
        CurrencyFormatObject cfo = formatObject.getCurrencyFormat();
        if (cfo == null) {
            return null;
        }
        return super.getFormat(cfo);
    }

    public String[] getSymbolPositive(CurrencyFormatObject cfo) {
        String positive = cfo.getCurrPosFormat();
        String symbol = cfo.getCurrencySymbols();
        return this.resolveFormatString(positive, symbol);
    }

    public String[] getSymbolNegtive(CurrencyFormatObject cfo) {
        String negtive = cfo.getNegativeFormat();
        String symbol = cfo.getCurrencySymbols();
        return this.resolveFormatString(negtive, symbol);
    }

    private String[] resolveFormatString(String formatString, String symbol) {
        String[] symbols;
        String[] result = new String[]{"", ""};
        if (StringUtils.isNotBlank((CharSequence)formatString) && (symbols = (formatString = formatString.replace(fixCurrencySymbol, symbol)).split(",")).length > 0) {
            result[0] = symbols[0];
            if (symbols.length > 1) {
                result[1] = symbols[1];
            }
        }
        return result;
    }

    protected void setPositive(DecimalFormat df, CurrencyFormatObject cfo) {
        String prefixType = cfo.getCnyShowPrefix();
        String positive = cfo.getCurrPosFormat();
        String number = cfo.getCurrencyNumber();
        String symbol = cfo.getCurrencySymbols();
        if (StringUtils.isBlank((CharSequence)positive)) {
            return;
        }
        String newSymbol = this.getNewSymbol(symbol, number, prefixType);
        if (",".equals(positive = StringUtils.replace((String)positive, (String)fixCurrencySymbol, (String)newSymbol))) {
            df.setPositivePrefix("");
            df.setPositiveSuffix("");
        } else {
            String[] symbols = positive.split(",");
            if (symbols.length > 0) {
                df.setPositivePrefix(symbols[0]);
                df.setPositiveSuffix(symbols.length == 1 ? "" : symbols[1]);
            }
        }
    }

    protected void setNegative(DecimalFormat df, CurrencyFormatObject cfo) {
        String prefixType = cfo.getCnyShowPrefix();
        String negative = cfo.getNegativeFormat();
        String number = cfo.getCurrencyNumber();
        String symbol = cfo.getCurrencySymbols();
        if (StringUtils.isBlank((CharSequence)negative)) {
            return;
        }
        String newSymbol = this.getNewSymbol(symbol, number, prefixType);
        if (",".equals(negative = StringUtils.replace((String)negative, (String)fixCurrencySymbol, (String)newSymbol))) {
            df.setPositivePrefix("");
            df.setPositiveSuffix("");
        } else {
            String[] symbols = negative.split(",");
            if (symbols.length > 0) {
                df.setNegativePrefix(symbols[0]);
                df.setNegativeSuffix(symbols.length == 1 ? "" : symbols[1]);
            }
        }
    }

    private String getNewSymbol(String symbol, String number, String prefixType) {
        if (prefixType.equals(CurrencyPrefixType.CurrencySymbol.getValue())) {
            return symbol;
        }
        if (prefixType.equals(CurrencyPrefixType.CurrencyNumber.getValue())) {
            return number;
        }
        return "";
    }
}

