/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.MapExecuteContext;
import kd.bos.formula.excel.VerifyVisitor;
import kd.bos.formula.excel.Visitor;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BOSExpression {
    private String expression;
    private Expr expr;
    private Set<String> vars = new HashSet<String>();
    private Set<String> funcs = new HashSet<String>();
    private boolean error;
    private String errMessage;

    public BOSExpression(String expression) {
        this.expression = expression;
        if (StringUtils.isBlank((CharSequence)this.expression)) {
            return;
        }
        try {
            this.expr = FormulaEngine.parseFormula((String)this.expression);
            VerifyVisitor varVisitor = new VerifyVisitor((ExecuteContext)new MapExecuteContext());
            this.expr.accept((Visitor)varVisitor);
            this.vars.addAll(varVisitor.getInvalidSymboList());
            UDFunctionVisitor funVisitor = new UDFunctionVisitor();
            this.expr.accept((Visitor)funVisitor);
            this.funcs.addAll(funVisitor.getFuncNames());
        }
        catch (Throwable exp) {
            this.error = true;
            this.errMessage = exp.getMessage();
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public Set<String> getVars() {
        return this.vars;
    }

    public Set<String> getFuncs() {
        return this.funcs;
    }

    public boolean isError() {
        return this.error;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    public String toString() {
        return this.error ? this.errMessage : this.expression;
    }
}

