/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kd.bos.consts.BOSExtPackage;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.operate.OpDefinitionSource;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BillFuncTypesLoader {
    private static final String FUNC_PATH = "/BillFuncTypes_";
    private static final String FUNC_END_SUFFIX = ".xml";
    private static final Map<String, FunctionTypes> BIZ_CLOUD_FUNCTION_CACHE = new HashMap<String, FunctionTypes>();

    public static synchronized FunctionTypes loadBizCloudFuncTypes() {
        FunctionTypes functionTypes = new FunctionTypes();
        for (String cloudNumber : BOSExtPackage.getExtPackageNumbers()) {
            FunctionTypes appFunctionTypes = BillFuncTypesLoader.loadFunctionBy(cloudNumber, true);
            if (appFunctionTypes == null) continue;
            for (FunctionType type : appFunctionTypes.getFunctionTypes()) {
                type.setSrcType(OpDefinitionSource.XML);
                type.setSrcApp(cloudNumber);
            }
            functionTypes.getFunctionGroups().addAll(appFunctionTypes.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(appFunctionTypes.getFunctionTypes());
        }
        return functionTypes;
    }

    public static synchronized FunctionTypes loadBizCloudFuncTypesNoCache() {
        FunctionTypes functionTypes = new FunctionTypes();
        for (String cloudNumber : BOSExtPackage.getExtPackageNumbers()) {
            FunctionTypes appFunctionTypes = BillFuncTypesLoader.loadFunctionBy(cloudNumber, false);
            if (appFunctionTypes == null) continue;
            functionTypes.getFunctionGroups().addAll(appFunctionTypes.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(appFunctionTypes.getFunctionTypes());
        }
        return functionTypes;
    }

    private static FunctionTypes loadFunctionBy(String cloudNumber, boolean enableCache) {
        FunctionTypes functionTypes = BIZ_CLOUD_FUNCTION_CACHE.get(cloudNumber);
        if (enableCache && null != functionTypes) {
            return functionTypes;
        }
        String functionFile = FUNC_PATH + cloudNumber.toLowerCase() + FUNC_END_SUFFIX;
        URL url = FunctionTypes.class.getResource(functionFile);
        functionTypes = FunctionTypes.get(url, false);
        BIZ_CLOUD_FUNCTION_CACHE.put(cloudNumber, functionTypes);
        return functionTypes;
    }
}

