/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.operate.OpDefinitionSource;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.LocalMemroyCacheUtil;

class ExtFuncTypesLoader {
    private static final Log log = LogFactory.getLog(ExtFuncTypesLoader.class);
    private static final String CACHEKEY_EXT_BILL_FUNCTION = "bos_ext_billfunction_fromdb";
    private static final String FUNCTYPE_BILL = "bill";
    private static final String FUNCTYPE_COMMON = "common";

    ExtFuncTypesLoader() {
    }

    public static void clearCache() {
        LocalMemroyCacheUtil.clear(CACHEKEY_EXT_BILL_FUNCTION);
    }

    public static FunctionTypes loadExtCommonFuncTypes() {
        try {
            LocaleCacheExtFunctionTypes localeCacheExtFunctionTypes = ExtFuncTypesLoader.loadLocaleCacheExtFunctionTypes();
            return localeCacheExtFunctionTypes.getExtCommonFuncTypes();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            return new FunctionTypes();
        }
    }

    public static FunctionTypes loadExtBillFuncTypes() {
        try {
            LocaleCacheExtFunctionTypes localeCacheExtFunctionTypes = ExtFuncTypesLoader.loadLocaleCacheExtFunctionTypes();
            return localeCacheExtFunctionTypes.getExtBillFuncTypes();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            return new FunctionTypes();
        }
    }

    private static LocaleCacheExtFunctionTypes loadLocaleCacheExtFunctionTypes() {
        LocaleCacheExtFunctionTypes localeCacheExtFunctionTypes = (LocaleCacheExtFunctionTypes)LocalMemroyCacheUtil.get(CACHEKEY_EXT_BILL_FUNCTION);
        if (localeCacheExtFunctionTypes != null && !localeCacheExtFunctionTypes.isTimeOut()) {
            return localeCacheExtFunctionTypes;
        }
        String accountId = RequestContext.get().getAccountId();
        if (StringUtils.isBlank((CharSequence)accountId)) {
            return new LocaleCacheExtFunctionTypes();
        }
        try (TXHandle h = TX.notSupported();){
            localeCacheExtFunctionTypes = ExtFuncTypesLoader.loadFuncTypesFromDB();
        }
        LocalMemroyCacheUtil.put(CACHEKEY_EXT_BILL_FUNCTION, localeCacheExtFunctionTypes);
        return localeCacheExtFunctionTypes;
    }

    private static LocaleCacheExtFunctionTypes loadFuncTypesFromDB() {
        String enableGroupId = "extfunctions";
        String disableGroupId = "extfunctions_disable";
        FunctionGroup enableGroup = new FunctionGroup();
        enableGroup.setId(enableGroupId);
        enableGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u6269\u5c55\u51fd\u6570", (String)"ExtFuncTypesLoader_01", (String)"bos-entity-metadata", (Object[])new Object[0])));
        enableGroup.setVisible(true);
        enableGroup.setSeq(999);
        FunctionGroup disableGroup = new FunctionGroup();
        disableGroup.setId(disableGroupId);
        disableGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u6269\u5c55\u51fd\u6570(\u5df2\u5e9f\u5f03)", (String)"ExtFuncTypesLoader_02", (String)"bos-entity-metadata", (Object[])new Object[0])));
        disableGroup.setVisible(false);
        disableGroup.setSeq(1000);
        FunctionTypes commonFuncTypes = new FunctionTypes();
        commonFuncTypes.getFunctionGroups().add(enableGroup);
        commonFuncTypes.getFunctionGroups().add(disableGroup);
        FunctionTypes billFuncTypes = new FunctionTypes();
        billFuncTypes.getFunctionGroups().add(enableGroup);
        billFuncTypes.getFunctionGroups().add(disableGroup);
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet(ExtFuncTypesLoader.class.getName(), "bos_devp_billfunction", "id, number, name, classname, desc, defformula, returntype, functype, formid, showseq, enable, sysdisable", new QFilter[0], null, 1000);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String number = row.getString("number");
                String name = row.getString("name");
                String runclass = row.getString("classname");
                if (StringUtils.isBlank((CharSequence)runclass)) {
                    log.info("FunctionType run class is empty: name =" + name + ", number" + number);
                    continue;
                }
                FunctionType functionType = new FunctionType();
                functionType.setId(number);
                functionType.setName(new LocaleString(name));
                functionType.setRunClass(runclass);
                functionType.setDesc(new LocaleString(row.getString("desc")));
                functionType.setDef(row.getString("defformula"));
                functionType.setReturnType(row.getString("returntype"));
                functionType.setSeq(row.getInteger("showseq"));
                functionType.setSettingFormId(row.getString("formid"));
                String enable = row.getString("enable");
                boolean sysdisable = row.getBoolean("sysdisable");
                if (StringUtils.equals((CharSequence)enable, (CharSequence)"1") && !sysdisable) {
                    functionType.setGroupId(enableGroupId);
                } else {
                    functionType.setGroupId(disableGroupId);
                    log.info("FunctionType run class is empty: name =" + name + ", number" + number + ", enable =" + enable + ", disable" + sysdisable);
                }
                functionType.setSrcApp("custom");
                functionType.setSrcType(OpDefinitionSource.DM_EXT);
                String funcType = row.getString("functype");
                if (StringUtils.isNotBlank((CharSequence)funcType) && StringUtils.equalsIgnoreCase((CharSequence)funcType, (CharSequence)FUNCTYPE_COMMON)) {
                    commonFuncTypes.getFunctionTypes().add(functionType);
                    billFuncTypes.getFunctionTypes().add(functionType);
                    continue;
                }
                billFuncTypes.getFunctionTypes().add(functionType);
            }
        }
        return new LocaleCacheExtFunctionTypes(commonFuncTypes, billFuncTypes);
    }

    static class LocaleCacheExtFunctionTypes {
        private static final long TIMEOUT_SPAN = 600000L;
        private long timeout;
        private FunctionTypes extCommonFuncTypes;
        private FunctionTypes extBillFuncTypes;

        public LocaleCacheExtFunctionTypes() {
            this.extCommonFuncTypes = new FunctionTypes();
            this.extBillFuncTypes = new FunctionTypes();
            this.timeout = System.currentTimeMillis() + 600000L;
        }

        public LocaleCacheExtFunctionTypes(FunctionTypes extCommonFuncTypes, FunctionTypes extBillFuncTypes) {
            this.extCommonFuncTypes = extCommonFuncTypes;
            this.extBillFuncTypes = extBillFuncTypes;
            this.timeout = System.currentTimeMillis() + 600000L;
        }

        public boolean isTimeOut() {
            return this.extCommonFuncTypes == null || this.extBillFuncTypes == null || Long.compare(System.currentTimeMillis(), this.timeout) >= 0;
        }

        public FunctionTypes getExtCommonFuncTypes() {
            return this.extCommonFuncTypes;
        }

        public FunctionTypes getExtBillFuncTypes() {
            return this.extBillFuncTypes;
        }
    }
}

