/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.function.BillFuncTypesLoader;
import kd.bos.entity.function.ExtFuncTypesLoader;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.operate.OpDefinitionSource;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.utils.LocaleBuildUtils;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

@SdkPublic
public class FunctionTypes {
    public static final String FUNCTION_TYPES_ID = "269QKQ0MGDHP";
    public static final String FuncFile_BOS_Common = "/BOS_CommonFunctionTypes.xml";
    public static final String FuncFile_BOS_Bill = "/BOS_BillFunctionTypes.xml";
    private static FunctionTypes sysCommonFunctionTypes = null;
    private static FunctionTypes sysBillFunctionTypes = null;
    private static FunctionTypes allBillFunctionTypes = null;
    private static Set<String> loadedAccounts = new HashSet<String>(20);
    private static List<IDataEntityType> dts = new ArrayList<IDataEntityType>();
    private List<FunctionGroup> functionGroups = new ArrayList<FunctionGroup>();
    private List<FunctionType> functionTypesList = new ArrayList<FunctionType>();
    private List<String> loadedLangs = new ArrayList<String>(3);

    private static synchronized FunctionTypes getBosCommonFunctionTypes(boolean enableCache) {
        Lang lang = Lang.get();
        if (enableCache && null != sysCommonFunctionTypes) {
            if (sysCommonFunctionTypes.isLoaded(lang)) {
                return sysCommonFunctionTypes;
            }
            FunctionTypes.fillLocale(FuncFile_BOS_Common, sysCommonFunctionTypes, lang);
            return sysCommonFunctionTypes;
        }
        sysCommonFunctionTypes = FunctionTypes.loadDefaultFunctionTypes(FuncFile_BOS_Common);
        if (!sysCommonFunctionTypes.isLoaded(lang)) {
            FunctionTypes.fillLocale(FuncFile_BOS_Common, sysCommonFunctionTypes, Lang.get());
        }
        for (FunctionType bosFunc : sysCommonFunctionTypes.getFunctionTypes()) {
            bosFunc.setSrcType(OpDefinitionSource.XML);
            bosFunc.setSrcApp("bos");
        }
        return sysCommonFunctionTypes;
    }

    private static synchronized FunctionTypes getBosBillFunctionTypes(boolean enableCache) {
        Lang lang = Lang.get();
        if (enableCache && null != sysBillFunctionTypes) {
            if (sysBillFunctionTypes.isLoaded(lang)) {
                return sysBillFunctionTypes;
            }
            FunctionTypes.fillLocale(FuncFile_BOS_Bill, sysBillFunctionTypes, lang);
            return sysBillFunctionTypes;
        }
        sysBillFunctionTypes = FunctionTypes.loadDefaultFunctionTypes(FuncFile_BOS_Bill);
        if (!sysBillFunctionTypes.isLoaded(lang)) {
            FunctionTypes.fillLocale(FuncFile_BOS_Bill, sysBillFunctionTypes, Lang.get());
        }
        for (FunctionType bosFunc : sysBillFunctionTypes.getFunctionTypes()) {
            bosFunc.setSrcType(OpDefinitionSource.XML);
            bosFunc.setSrcApp("bos");
        }
        return sysBillFunctionTypes;
    }

    private static void fillWithDefault(LocaleString localeStr) {
        Lang[] supportLanguages;
        if (null == localeStr) {
            return;
        }
        String defaultLocale = Lang.defaultLang().toString();
        String defaultValue = (String)localeStr.getItem(defaultLocale);
        for (Lang lang : supportLanguages = Lang.values()) {
            localeStr.put(lang.toString(), (Object)defaultValue);
        }
    }

    private static FunctionTypes loadFunctionTypesBy(URL url) {
        Document doc;
        if (null == url) {
            return new FunctionTypes();
        }
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        String defaultLocale = Lang.defaultLang().toString();
        ser.getBinder().setLCId(defaultLocale);
        try {
            doc = LocaleBuildUtils.getSaxReader().read(url);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        String fileName = url.getFile() == null ? "" : url.getFile();
        LocaleBuildUtils.replaceLocaleVars(fileName, doc, defaultLocale);
        FunctionTypes functionTypes = (FunctionTypes)ser.deserialize(doc, null);
        for (FunctionGroup functionGroup : functionTypes.getFunctionGroups()) {
            FunctionTypes.fillWithDefault(functionGroup.getName());
        }
        for (FunctionType functionType : functionTypes.getFunctionTypes()) {
            FunctionTypes.fillWithDefault(functionType.getName());
            FunctionTypes.fillWithDefault(functionType.getDesc());
        }
        functionTypes.setLoaded(Lang.defaultLang());
        return functionTypes;
    }

    private static FunctionTypes loadDefaultFunctionTypes(String fileName) {
        return FunctionTypes.loadLocaleFunctionTypes(fileName, Lang.zh_CN);
    }

    private static FunctionTypes loadLocaleFunctionTypes(String fileName, Lang lang) {
        Document doc;
        URL url = FunctionTypes.class.getResource(fileName);
        if (url == null) {
            return new FunctionTypes();
        }
        String langStr = lang.toString();
        try {
            doc = LocaleBuildUtils.getSaxReader().read(url);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        LocaleBuildUtils.replaceLocaleVars(fileName, doc, langStr);
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        ser.getBinder().setLCId(langStr);
        FunctionTypes functionTypes = (FunctionTypes)ser.deserialize(doc, null);
        functionTypes.setLoaded(lang);
        return functionTypes;
    }

    private static void fillLocale(String fileName, FunctionTypes functionTypes, Lang lang) {
        if (functionTypes == null || functionTypes.isLoaded(lang)) {
            return;
        }
        HashMap<String, FunctionGroup> groupMap = new HashMap<String, FunctionGroup>(functionTypes.getFunctionGroups().size());
        HashMap<String, FunctionType> functionTypeMap = new HashMap<String, FunctionType>(functionTypes.getFunctionTypes().size());
        for (FunctionGroup group : functionTypes.getFunctionGroups()) {
            groupMap.put(group.getId(), group);
        }
        for (FunctionType type : functionTypes.getFunctionTypes()) {
            functionTypeMap.put(type.getId(), type);
        }
        FunctionTypes locale = FunctionTypes.loadLocaleFunctionTypes(fileName, lang);
        for (FunctionGroup group : locale.getFunctionGroups()) {
            String localeV = (String)group.getName().getItem(lang.toString());
            if (groupMap.get(group.getId()) == null || group.getName() == null || !StringUtils.isNotBlank((CharSequence)localeV)) continue;
            ((FunctionGroup)groupMap.get(group.getId())).getName().setItem(lang.toString(), (Object)localeV);
        }
        for (FunctionType type : locale.getFunctionTypes()) {
            String localeName = (String)type.getName().getItem(lang.toString());
            String localeDesc = (String)type.getDesc().getItem(lang.toString());
            if (functionTypeMap.get(type.getId()) != null && type.getName() != null && StringUtils.isNotBlank((CharSequence)localeName)) {
                ((FunctionType)functionTypeMap.get(type.getId())).getName().setItem(lang.toString(), (Object)localeName);
            }
            if (functionTypeMap.get(type.getId()) == null || type.getDesc() == null || !StringUtils.isNotBlank((CharSequence)localeDesc)) continue;
            ((FunctionType)functionTypeMap.get(type.getId())).getDesc().setItem(lang.toString(), (Object)localeDesc);
        }
        functionTypes.setLoaded(lang);
    }

    public static synchronized void clearCache() {
        allBillFunctionTypes = null;
        loadedAccounts.clear();
        sysCommonFunctionTypes = null;
        sysBillFunctionTypes = null;
        ExtFuncTypesLoader.clearCache();
    }

    public static synchronized FunctionTypes get() {
        FunctionTypes source;
        if (allBillFunctionTypes != null) {
            if (Lang.get() == Lang.zh_CN || allBillFunctionTypes.isLoaded(Lang.get())) {
                source = allBillFunctionTypes;
            } else if (loadedAccounts.contains(FunctionTypes.getLoadedCacheKey())) {
                source = allBillFunctionTypes;
            } else {
                FunctionTypes.mergeLocale(allBillFunctionTypes, Lang.get());
                loadedAccounts.add(FunctionTypes.getLoadedCacheKey());
                source = allBillFunctionTypes;
            }
        } else {
            allBillFunctionTypes = FunctionTypes.initAllBillFunctionTypes();
            loadedAccounts.add(FunctionTypes.getLoadedCacheKey());
            source = allBillFunctionTypes;
        }
        FunctionTypes functionTypes = new FunctionTypes();
        functionTypes.getFunctionGroups().addAll(source.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(source.getFunctionTypes());
        FunctionTypes extBillFuncTypes = ExtFuncTypesLoader.loadExtBillFuncTypes();
        functionTypes.getFunctionGroups().addAll(extBillFuncTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(extBillFuncTypes.getFunctionTypes());
        return functionTypes;
    }

    private static void mergeLocale(FunctionTypes main, Lang lang) {
        if (main.getFunctionTypes().isEmpty()) {
            return;
        }
        String langStr = lang.toString();
        FunctionTypes localeObj = FunctionTypes.initAllBillFunctionTypes();
        if (!localeObj.isLoaded(lang)) {
            return;
        }
        HashMap<String, FunctionType> mainTypes = new HashMap<String, FunctionType>(10);
        HashMap<String, FunctionGroup> mainGroups = new HashMap<String, FunctionGroup>(10);
        for (FunctionType type : main.getFunctionTypes()) {
            mainTypes.put(type.getId(), type);
        }
        for (FunctionGroup group : main.getFunctionGroups()) {
            mainGroups.put(group.getId(), group);
        }
        for (FunctionGroup localeGrp : localeObj.getFunctionGroups()) {
            String groupId;
            FunctionGroup mainGrp;
            if (localeGrp.getName() == null || StringUtils.isBlank((CharSequence)((CharSequence)localeGrp.getName().getItem(langStr))) || (mainGrp = (FunctionGroup)mainGroups.get(groupId = localeGrp.getId())) == null) continue;
            if (mainGrp.getName() == null) {
                mainGrp.setName(new LocaleString(groupId));
            }
            mainGrp.getName().setItem(langStr, localeGrp.getName().getItem(langStr));
        }
        for (FunctionType localeType : localeObj.getFunctionTypes()) {
            String typeId = localeType.getId();
            FunctionType mainType = (FunctionType)mainTypes.get(typeId);
            if (mainType == null) continue;
            if (mainType.getName() == null) {
                mainType.setName(new LocaleString(typeId));
            }
            if (mainType.getDesc() == null) {
                mainType.setDesc(new LocaleString(typeId));
            }
            if (localeType.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)localeType.getName().getItem(langStr)))) {
                mainType.getName().setItem(langStr, localeType.getName().getItem(langStr));
            }
            if (localeType.getDesc() == null || !StringUtils.isNotBlank((CharSequence)((CharSequence)localeType.getDesc().getItem(langStr)))) continue;
            mainType.getDesc().setItem(langStr, localeType.getDesc().getItem(langStr));
        }
    }

    private static String getLoadedCacheKey() {
        RequestContext rc = RequestContext.get();
        String accountId = rc == null ? "" : rc.getAccountId();
        String lang = Lang.get().toString();
        return accountId + "_" + lang;
    }

    private static FunctionTypes initAllBillFunctionTypes() {
        FunctionType first;
        LocaleString localeName;
        FunctionTypes functionTypes = new FunctionTypes();
        FunctionTypes sysCommonFunctionTypes = FunctionTypes.getBosCommonFunctionTypes(true);
        functionTypes.getFunctionGroups().addAll(sysCommonFunctionTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(sysCommonFunctionTypes.getFunctionTypes());
        FunctionTypes sysBillFunctionTypes = FunctionTypes.getBosBillFunctionTypes(true);
        functionTypes.getFunctionGroups().addAll(sysBillFunctionTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(sysBillFunctionTypes.getFunctionTypes());
        FunctionTypes bizBillFuncTypes = BillFuncTypesLoader.loadBizCloudFuncTypes();
        functionTypes.getFunctionGroups().addAll(bizBillFuncTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(bizBillFuncTypes.getFunctionTypes());
        String sql = "select flocaleid,fdata from t_meta_formdesign_l where fid = '269QKQ0MGDHP'";
        ArrayList xmlList = new ArrayList();
        DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            while (rs.next()) {
                String localeId = rs.getString("flocaleid");
                if (!StringUtils.equals((CharSequence)Lang.get().toString(), (CharSequence)localeId)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("lcid", rs.getString("flocaleid"));
                map.put("xml", rs.getString("fdata"));
                xmlList.add(map);
            }
            return xmlList;
        });
        if (xmlList.size() > 0) {
            DcxmlSerializer ser = new DcxmlSerializer(dts);
            ser.setBinder((DcBinder)new LocaleFunctionBinder(false, dts));
            for (Map map : xmlList) {
                ser.getBinder().setLCId((String)map.get("lcid"));
                ser.deserializeFromString((String)map.get("xml"), (Object)functionTypes);
            }
        }
        functionTypes.setLoaded(Lang.zh_CN);
        if (Lang.zh_CN != Lang.get() && !functionTypes.getFunctionTypes().isEmpty() && (localeName = (first = functionTypes.getFunctionTypes().get(0)).getName()) != null && !StringUtils.equals((CharSequence)((CharSequence)localeName.getItem(Lang.zh_CN.toString())), (CharSequence)((CharSequence)localeName.getItem(Lang.get().toString())))) {
            functionTypes.setLoaded(Lang.get());
        }
        return functionTypes;
    }

    public static synchronized FunctionTypes getFromXml() {
        FunctionTypes functionTypes = new FunctionTypes();
        FunctionTypes sysCommonFunctionTypes = FunctionTypes.getBosCommonFunctionTypes(false);
        functionTypes.getFunctionGroups().addAll(sysCommonFunctionTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(sysCommonFunctionTypes.getFunctionTypes());
        FunctionTypes sysBillFunctionTypes = FunctionTypes.getBosBillFunctionTypes(false);
        functionTypes.getFunctionGroups().addAll(sysBillFunctionTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(sysBillFunctionTypes.getFunctionTypes());
        FunctionTypes bizBillFuncTypes = BillFuncTypesLoader.loadBizCloudFuncTypesNoCache();
        functionTypes.getFunctionGroups().addAll(bizBillFuncTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(bizBillFuncTypes.getFunctionTypes());
        return functionTypes;
    }

    public static synchronized FunctionTypes getCommonFuncs() {
        FunctionTypes functionTypes = new FunctionTypes();
        FunctionTypes sysCommonFunctionTypes = FunctionTypes.getBosCommonFunctionTypes(true);
        functionTypes.getFunctionGroups().addAll(sysCommonFunctionTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(sysCommonFunctionTypes.getFunctionTypes());
        FunctionTypes extCommonFuncTypes = ExtFuncTypesLoader.loadExtCommonFuncTypes();
        functionTypes.getFunctionGroups().addAll(extCommonFuncTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(extCommonFuncTypes.getFunctionTypes());
        return functionTypes;
    }

    public static synchronized FunctionTypes get(URL xmlUrl, boolean needIncludeBosFunctions) {
        FunctionTypes functionTypes = new FunctionTypes();
        if (needIncludeBosFunctions) {
            FunctionTypes sysCommonFunctionTypes = FunctionTypes.getBosCommonFunctionTypes(true);
            functionTypes.getFunctionGroups().addAll(sysCommonFunctionTypes.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(sysCommonFunctionTypes.getFunctionTypes());
        }
        if (null == xmlUrl) {
            return functionTypes;
        }
        try {
            FunctionTypes customFunctionTypes = FunctionTypes.loadFunctionTypesBy(xmlUrl);
            functionTypes.getFunctionGroups().addAll(customFunctionTypes.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(customFunctionTypes.getFunctionTypes());
        }
        catch (Throwable exp) {
            throw new KDException(exp, BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5e76\u89e3\u6790\u8d44\u6e90\u6587\u4ef6\u51fa\u9519\uff1a%s", (String)"FunctionTypes_1", (String)"bos-entity-metadata", (Object[])new Object[0]), xmlUrl.getFile())});
        }
        return functionTypes;
    }

    public static FunctionTypes get(String xml) {
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        FunctionTypes functionTypes = (FunctionTypes)ser.deserializeFromString(xml, null);
        return functionTypes;
    }

    public static String serializeToXML(FunctionTypes functionTypes) {
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        String xml = ser.serializeToString((Object)functionTypes, null);
        return xml;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=FunctionGroup.class)
    public List<FunctionGroup> getFunctionGroups() {
        return this.functionGroups;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=FunctionType.class)
    public List<FunctionType> getFunctionTypes() {
        return this.functionTypesList;
    }

    public boolean isLoaded(Lang lang) {
        if (lang == null) {
            return true;
        }
        return this.loadedLangs.contains(lang.toString());
    }

    public void setLoaded(Lang lang) {
        if (lang != null && !this.loadedLangs.contains(lang.toString())) {
            this.loadedLangs.add(lang.toString());
        }
    }

    static {
        dts.add(OrmUtils.getDataEntityType(FunctionTypes.class));
        dts.add(OrmUtils.getDataEntityType(FunctionGroup.class));
        dts.add(OrmUtils.getDataEntityType(FunctionType.class));
    }

    private static class LocaleFunctionBinder
    extends ListDcxmlBinder {
        private String zhLang = Lang.zh_CN.toString();

        public LocaleFunctionBinder(boolean ignoreCase, Iterable<IDataEntityType> dts) {
            super(ignoreCase, dts);
        }

        public boolean readSimpleProperty(ISimpleProperty property, Element propElement, Object entity) {
            Object localeString;
            boolean ignore = false;
            if ((entity instanceof FunctionGroup || entity instanceof FunctionType) && property.getPropertyType() == LocaleString.class && (localeString = property.getValue(entity)) instanceof LocaleString && ((LocaleString)localeString).getItem(this.zhLang) != null && !StringUtils.equals((CharSequence)((CharSequence)((LocaleString)localeString).getItem(this.zhLang)), (CharSequence)((CharSequence)((LocaleString)localeString).getItem(this.getLCId())))) {
                ignore = true;
            }
            if (ignore) {
                return true;
            }
            return super.readSimpleProperty(property, propElement, entity);
        }
    }
}

