/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IJoinProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class JoinProperty
extends BasedataProp
implements IJoinProperty {
    private static final long serialVersionUID = -7657554590135555781L;
    private IDataEntityProperty fkProperty;
    private IDataEntityProperty joinProperty_j;

    public JoinProperty() {
    }

    public JoinProperty(IDataEntityProperty fkProperty, IDataEntityProperty joinProperty) {
        this.joinProperty_j = joinProperty;
        this.fkProperty = fkProperty;
    }

    public IDataEntityProperty getJoinProperty() {
        return this.joinProperty_j;
    }

    public IDataEntityProperty getFKProperty() {
        return this.fkProperty;
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    public List<FilterField> createFilterFields(MainEntityType mainType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        MainEntityType bdType = (MainEntityType)this.getComplexType();
        if (bdType == null) {
            return filterFields;
        }
        for (IDataEntityProperty fieldProp : bdType.getAllFields().values()) {
            String joinPropEntityName = bdType.getName();
            FilterField filterField = null;
            if (fieldProp instanceof FieldProp) {
                List<FilterField> fieldPropFilterFields = ((FieldProp)fieldProp).createFilterFields(mainType);
                if (CollectionUtils.isEmpty(fieldPropFilterFields)) continue;
                filterField = fieldPropFilterFields.get(0);
                this.setNameAndCaption(filterField, joinPropEntityName);
                filterFields.add(filterField);
                continue;
            }
            if (!(fieldProp instanceof BasedataProp) || fieldProp instanceof FlexProp) continue;
            List<FilterField> basePropFilterFields = ((BasedataProp)fieldProp).createFilterFields(mainType);
            Iterator<FilterField> iterator = basePropFilterFields.iterator();
            while (iterator.hasNext()) {
                FilterField basePropFilterField;
                filterField = basePropFilterField = iterator.next();
                this.setNameAndCaption(filterField, joinPropEntityName);
                filterFields.add(filterField);
            }
        }
        return filterFields;
    }

    private void setNameAndCaption(FilterField filterField, String joinPropEntityName) {
        if (filterField != null) {
            filterField.setFieldName(joinPropEntityName + "." + filterField.getFieldName());
            filterField.setFullFieldName(joinPropEntityName + "." + filterField.getFullFieldName());
            filterField.setCaption(new LocaleString(this.getFullFieldCaption(filterField)));
        }
    }

    private String getFullFieldCaption(FilterField filterField) {
        ArrayList<String> propCaptions = new ArrayList<String>();
        EntityType entityType = (EntityType)filterField.getSrcFieldProp().getParent();
        if (entityType instanceof EntryType) {
            EntityType entryParentType = (EntityType)entityType.getParent();
            if (entryParentType != null) {
                if (entryParentType.getDisplayName() != null) {
                    propCaptions.add(entryParentType.getDisplayName().toString());
                } else {
                    propCaptions.add(entryParentType.getName());
                }
            }
            if (entityType.getDisplayName() != null) {
                propCaptions.add(entityType.getDisplayName().toString());
            } else {
                propCaptions.add(entityType.getName());
            }
        } else if (entityType.getDisplayName() != null) {
            propCaptions.add(entityType.getDisplayName().toString());
        } else {
            propCaptions.add(entityType.getName());
        }
        if (((DynamicProperty)filterField.getSrcFieldProp()).getDisplayName() != null) {
            propCaptions.add(((DynamicProperty)filterField.getSrcFieldProp()).getDisplayName().toString());
        } else {
            propCaptions.add(filterField.getSrcFieldProp().getName());
        }
        if (filterField.getRefProp1() != null) {
            if (((DynamicProperty)filterField.getRefProp1()).getDisplayName() != null) {
                propCaptions.add(((DynamicProperty)filterField.getRefProp1()).getDisplayName().toString());
            } else {
                propCaptions.add(filterField.getRefProp1().getName());
            }
        }
        if (filterField.getRefProp2() != null) {
            if (((DynamicProperty)filterField.getRefProp1()).getDisplayName() != null) {
                propCaptions.add(((DynamicProperty)filterField.getRefProp1()).getDisplayName().toString());
            } else {
                propCaptions.add(filterField.getRefProp1().getName());
            }
        }
        return StringUtils.join((Object[])propCaptions.toArray(), (String)".");
    }
}

