/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.list.column.DecimalColumnDesc;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.utils.ExRateConfigUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ExchangeRateColumnDesc
extends DecimalColumnDesc {
    public ExchangeRateColumnDesc(String key, DecimalProp decProp, IDataEntityProperty fieldProp) {
        super(key, decProp, fieldProp);
    }

    @Override
    protected int getFieldPrecision(DynamicObject dr) {
        boolean isOpen = ExRateConfigUtil.isEnableExRatePrecisionControl();
        if (!isOpen) {
            ExchangeRateProp exchangeRateProp = (ExchangeRateProp)this.getSrcFieldProp();
            return exchangeRateProp.getScale();
        }
        ExchangeRateProp prop = (ExchangeRateProp)this.getSrcFieldProp();
        CurrencyProp oriProp = null;
        CurrencyProp tarProp = null;
        for (IDataEntityProperty dataEntityProperty : dr.getDataEntityType().getProperties()) {
            if (dataEntityProperty.getName().equals(prop.getOriginalCurrencyFieldKey())) {
                oriProp = (CurrencyProp)dataEntityProperty;
            }
            if (!dataEntityProperty.getName().equals(prop.getTargetCurrencyFieldKey())) continue;
            tarProp = (CurrencyProp)dataEntityProperty;
        }
        if (oriProp == null || tarProp == null) {
            for (IDataEntityProperty dataEntityProperty : dr.getDataEntityType().getProperties()) {
                if (dataEntityProperty.getName().equals(prop.getParent().getName() + "." + prop.getOriginalCurrencyFieldKey())) {
                    oriProp = (CurrencyProp)dataEntityProperty;
                }
                if (!dataEntityProperty.getName().equals(prop.getParent().getName() + "." + prop.getTargetCurrencyFieldKey())) continue;
                tarProp = (CurrencyProp)dataEntityProperty;
            }
        }
        DynamicObject originalCurrencyDy = oriProp != null ? (DynamicObject)oriProp.getValueFast(dr) : null;
        DynamicObject targetCurrencyDy = tarProp != null ? (DynamicObject)tarProp.getValueFast(dr) : null;
        Long originalCurrencyId = originalCurrencyDy != null ? (Long)originalCurrencyDy.getPkValue() : null;
        Long targetCurrencyId = targetCurrencyDy != null ? (Long)targetCurrencyDy.getPkValue() : null;
        BigDecimal exRate = (BigDecimal)this.getFieldProp().getValueFast((Object)dr);
        int currencyScale = originalCurrencyId != null && targetCurrencyId != null ? ExRateConfigUtil.getExchangeRatePrecision(originalCurrencyId, targetCurrencyId) : prop.getScale();
        if (currencyScale == 0) {
            currencyScale = prop.getScale();
        }
        if (exRate != null) {
            currencyScale = Math.max(exRate.stripTrailingZeros().scale(), currencyScale);
        }
        return currencyScale;
    }
}

