/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.bizrule;

import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.config.EnvConfigurationUtil;
import kd.bos.consts.BOSExtPackage;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.OpDefinitionSource;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.entity.pureplatform.PurePlatformBlackList;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.utils.LocalMemroyCacheUtil;
import kd.bos.utils.LocaleBuildUtils;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

@SdkPublic
public class OpBizRuleTypeLoader {
    private static final Log LOG = LogFactory.getLog(OpBizRuleTypeLoader.class);
    private static final String DM_NAME = "DM_Name_";
    private static final String DM_DESC = "DM_Desc_";
    private static final String OPBIZRULE_TYPE = "OpBizRuleType";
    private static final String OPBIZ_RREFIX = "OpBizRule_";
    private static final String OPBIZ_ENDSUFFIX = ".xml";
    private static final String EXT_OP_RULE_TYPES_FROM_DB = "extOpRuleTypesFromDB";
    private static List<IDataEntityType> dts = new ArrayList<IDataEntityType>();
    private static Map<String, Map<String, String>> cacheOpTasks;
    private static OpBizRuleTypes cacheOpBizRuleTypes;
    private static Map<String, OpBizRuleTypes> allOriAppOpRuleTypes;
    private static final String SQL_EXT_OPSERVICE = "select a.fid, a.fnumber, a.fapplicationrange, a.fformid, a.fisv, a.fclass, a.fopwhitelist, a.fopblacklist, a.fisdesign, b.fname, b.fdesc, d.fnumber as appnumber, B.FLocaleId from t_dm_opservice a left join t_dm_opservice_L b on B.FId=A.FId LEFT JOIN t_dm_opserviceapp c ON c.FId=A.FId LEFT JOIN t_meta_bizapp d ON d.FId=c.FBasedataId  where a.fenable = ?";

    public static void resetCache() {
        cacheOpBizRuleTypes = null;
        cacheOpTasks.clear();
        LocalMemroyCacheUtil.clear(EXT_OP_RULE_TYPES_FROM_DB);
    }

    public static OpBizRuleTypes load() {
        if (cacheOpBizRuleTypes == null || cacheOpBizRuleTypes.isCacheOverTime()) {
            cacheOpBizRuleTypes = OpBizRuleTypeLoader.loadFromXml();
        }
        if (!cacheOpBizRuleTypes.isLoaded(Lang.get())) {
            OpBizRuleTypeLoader.fillLoacle(cacheOpBizRuleTypes, Lang.get());
        }
        OpBizRuleTypes opBizRuleTypes = new OpBizRuleTypes();
        opBizRuleTypes.getRuleTypes().addAll(cacheOpBizRuleTypes.getRuleTypes());
        opBizRuleTypes.getRuleTypes().addAll(OpBizRuleTypeLoader.loadEXTFromDB().getRuleTypes());
        if (EnvConfigurationUtil.isPurePlatform()) {
            for (int i = opBizRuleTypes.getRuleTypes().size() - 1; i >= 0; --i) {
                OpBizRuleType opBizRuleType = opBizRuleTypes.getRuleTypes().get(i);
                if (!PurePlatformBlackList.getOpBizRuleBlackList().contains(opBizRuleType.getId())) continue;
                opBizRuleTypes.getRuleTypes().remove(i);
            }
        }
        return opBizRuleTypes;
    }

    private static OpBizRuleTypes loadEXTFromDB() {
        OpBizRuleTypes opBizRuleTypes = (OpBizRuleTypes)LocalMemroyCacheUtil.get(EXT_OP_RULE_TYPES_FROM_DB);
        if (null != opBizRuleTypes && !opBizRuleTypes.isCacheOverTime()) {
            return opBizRuleTypes;
        }
        SqlParameter enable = new SqlParameter(1, (Object)"1");
        Object[] parameters = new SqlParameter[]{enable};
        List opBizRuleTypeList = new ArrayList();
        try {
            opBizRuleTypeList = (List)DB.query((DBRoute)DBRoute.meta, (String)SQL_EXT_OPSERVICE, (Object[])parameters, rs -> {
                HashMap<String, OpBizRuleType> map = new HashMap<String, OpBizRuleType>(32);
                while (rs.next()) {
                    OpBizRuleType opBizRuleType;
                    String fid = rs.getString("fid");
                    String lang = rs.getString("FLocaleId");
                    if (!map.containsKey(fid)) {
                        opBizRuleType = new OpBizRuleType();
                        opBizRuleType.setId(rs.getString("fnumber"));
                        opBizRuleType.setSettingFormId(rs.getString("fformid"));
                        opBizRuleType.setRunClass(rs.getString("fclass"));
                        String fname = rs.getString("fname");
                        LocaleString name = new LocaleString(lang, fname);
                        opBizRuleType.setName(name);
                        String fdesc = rs.getString("fdesc");
                        LocaleString desc = new LocaleString(lang, fdesc);
                        opBizRuleType.setDesc(desc);
                        opBizRuleType.setAppliedRange(rs.getInt("fapplicationrange"));
                        opBizRuleType.setAppliedAppNumbers(rs.getString("appnumber"));
                        opBizRuleType.setOpWhiteList(rs.getString("fopwhitelist"));
                        opBizRuleType.setOpBlackList(rs.getString("fopblacklist"));
                        opBizRuleType.setDesignForbid(!rs.getBoolean("fisdesign"));
                        opBizRuleType.setSrcApp(opBizRuleType.getAppliedAppNumbers());
                        opBizRuleType.setSrcType(OpDefinitionSource.DM_EXT);
                        map.put(fid, opBizRuleType);
                        continue;
                    }
                    opBizRuleType = (OpBizRuleType)map.get(fid);
                    int fapplicationrange = rs.getInt("fapplicationrange");
                    switch (fapplicationrange) {
                        case 1: {
                            String appNumbers = opBizRuleType.getAppliedAppNumbers() + "," + rs.getString("appnumber");
                            opBizRuleType.setAppliedAppNumbers(appNumbers);
                        }
                    }
                    String fname = rs.getString("fname");
                    LocaleString name = opBizRuleType.getName();
                    if (name == null) {
                        name = new LocaleString();
                        opBizRuleType.setName(name);
                    }
                    name.put(lang, (Object)fname);
                    String fdesc = rs.getString("fdesc");
                    LocaleString desc = opBizRuleType.getDesc();
                    if (desc == null) {
                        desc = new LocaleString();
                        opBizRuleType.setDesc(desc);
                    }
                    desc.put(lang, (Object)fdesc);
                }
                ArrayList list = new ArrayList(map.size());
                list.addAll(map.values());
                return list;
            });
        }
        catch (Exception e) {
            LOG.error("OpBizRuleType loadEXTFromDB error:", (Throwable)e);
        }
        opBizRuleTypes = new OpBizRuleTypes();
        opBizRuleTypes.getRuleTypes().addAll(opBizRuleTypeList);
        LocalMemroyCacheUtil.put(EXT_OP_RULE_TYPES_FROM_DB, opBizRuleTypes);
        return opBizRuleTypes;
    }

    public static OpBizRuleTypes load(String[] appNumbers) {
        OpBizRuleTypes types = OpBizRuleTypeLoader.load();
        types.getRuleTypes().removeIf(type -> type.getAppliedAppNumbers() != null && !OpBizRuleTypeLoader.isAppNumber(appNumbers, type.getAppliedAppNumbers().split(",")));
        return types;
    }

    public static synchronized Map<String, String> loadOperationTask() {
        String dbid = CacheKeyUtil.getAcctId();
        Map tasks = cacheOpTasks.get(dbid);
        if (tasks == null) {
            Object[] sqlParas = new SqlParameter[]{};
            tasks = (Map)DB.query((DBRoute)DBRoute.meta, (String)"select TOP 10 FKEY, FCLASS from T_BAS_OperationTaskDef", (Object[])sqlParas, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    while (rs.next()) {
                        String key = rs.getString("FKEY");
                        String className = rs.getString("FCLASS");
                        map.put(key, className);
                    }
                    return map;
                }
            });
            cacheOpTasks.put(dbid, tasks);
        }
        return tasks;
    }

    private static OpBizRuleTypes get(String fileName, URL xmlUrl, Lang lang) {
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        ser.getBinder().setLCId(lang.toString());
        OpBizRuleTypes types = new OpBizRuleTypes();
        if (xmlUrl != null) {
            try {
                SAXReader reader = LocaleBuildUtils.getSaxReader();
                Document document = reader.read(xmlUrl);
                LocaleBuildUtils.replaceLocaleVars(fileName, document, lang.toString());
                OpBizRuleTypes t = (OpBizRuleTypes)ser.deserialize(document, null);
                types.getRuleTypes().addAll(t.getRuleTypes());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return types;
    }

    private static synchronized OpBizRuleTypes loadFromXml() {
        OpBizRuleTypes types = OpBizRuleTypeLoader.loadFromXmlOri();
        OpBizRuleTypeLoader.fillLoacle(types, Lang.get());
        return types;
    }

    private static void fillLoacle(OpBizRuleTypes types, Lang lang) {
        String currentLang = lang.toString();
        HashMap<String, OpBizRuleType> dict = new HashMap<String, OpBizRuleType>(10);
        for (OpBizRuleType it : types.getRuleTypes()) {
            dict.put(it.getId(), it);
        }
        for (String cloudNumber : BOSExtPackage.getExtPackageNumbers()) {
            OpBizRuleTypes locale = OpBizRuleTypeLoader.loadFromXmlOri(cloudNumber, lang);
            if (locale == null || locale.getRuleTypes().isEmpty()) continue;
            for (OpBizRuleType rule : locale.getRuleTypes()) {
                OpBizRuleType target = (OpBizRuleType)dict.get(rule.getId());
                if (target == null) continue;
                if (rule.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)rule.getName().getItem(currentLang)))) {
                    target.getName().setItem(currentLang, rule.getName().getItem(currentLang));
                }
                if (rule.getDesc() == null || !StringUtils.isNotBlank((CharSequence)((CharSequence)rule.getDesc().getItem(currentLang)))) continue;
                target.getDesc().setItem(currentLang, rule.getDesc().getItem(currentLang));
            }
        }
        if (!Boolean.getBoolean("sys.domainmodel.oldlocale.disable")) {
            for (OpBizRuleType type : types.getRuleTypes()) {
                LocaleString res_Desc;
                LocaleString desc;
                LocaleString res_name;
                LocaleString name = type.getName();
                if (name != null && StringUtils.equals((CharSequence)((CharSequence)name.getItem(currentLang)), (CharSequence)((CharSequence)name.getItem(Lang.zh_CN.toString()))) && StringUtils.isNotBlank((CharSequence)((CharSequence)(res_name = ResManager.getLocaleString((String)" ", (String)(DM_NAME + type.getId()), (String)OPBIZRULE_TYPE)).getItem(currentLang)))) {
                    type.getName().setItem(currentLang, res_name.getItem(currentLang));
                }
                if ((desc = type.getDesc()) == null || !StringUtils.equals((CharSequence)((CharSequence)desc.get((Object)currentLang)), (CharSequence)((CharSequence)desc.getItem(Lang.zh_CN.toString()))) || !StringUtils.isNotBlank((CharSequence)((CharSequence)(res_Desc = ResManager.getLocaleString((String)" ", (String)(DM_DESC + type.getId()), (String)OPBIZRULE_TYPE)).getItem(currentLang)))) continue;
                type.getDesc().setItem(currentLang, res_Desc.getItem(currentLang));
            }
        }
        types.setLoaded(lang);
    }

    public static OpBizRuleTypes loadFromXmlOri() {
        OpBizRuleTypes opBizRuleTypes = new OpBizRuleTypes();
        ArrayList<String> notExistCloudNumbers = new ArrayList<String>(200);
        ArrayList<String> existCloudNumbers = new ArrayList<String>(100);
        ArrayList<String> typeNames = new ArrayList<String>(10);
        for (String cloudNumber : BOSExtPackage.getExtPackageNumbers()) {
            String resName = OPBIZ_RREFIX + cloudNumber.toLowerCase() + OPBIZ_ENDSUFFIX;
            OpBizRuleTypes targetData = allOriAppOpRuleTypes.get(resName);
            if (targetData != null) {
                targetData = targetData.copy();
            } else {
                URL url = OpBizRuleTypes.class.getClassLoader().getResource(resName);
                if (url != null) {
                    targetData = OpBizRuleTypeLoader.get(resName, url, Lang.zh_CN);
                    for (OpBizRuleType it : targetData.getRuleTypes()) {
                        it.setSrcType(OpDefinitionSource.XML);
                        it.setSrcApp(cloudNumber);
                    }
                    allOriAppOpRuleTypes.put(resName, targetData);
                    targetData = targetData.copy();
                }
            }
            if (targetData != null) {
                opBizRuleTypes.getRuleTypes().addAll(targetData.getRuleTypes());
                typeNames.clear();
                for (OpBizRuleType ruleType : targetData.getRuleTypes()) {
                    typeNames.add(ruleType.getId());
                }
                existCloudNumbers.add(String.format("%s:[%s]", cloudNumber, StringUtils.join((Object[])typeNames.toArray(), (String)",")));
                continue;
            }
            notExistCloudNumbers.add(cloudNumber);
        }
        LOG.info(String.format("\u64cd\u4f5c\u670d\u52a1\u8bfb\u53d6\u5b8c\u6bd5: [%s]; \u65e0\u64cd\u4f5c\u670d\u52a1\u7684\u5e94\u7528: [%s]", StringUtils.join((Object[])existCloudNumbers.toArray(), (String)","), StringUtils.join((Object[])notExistCloudNumbers.toArray(), (String)",")));
        opBizRuleTypes.setLoaded(Lang.zh_CN);
        return opBizRuleTypes;
    }

    private static OpBizRuleTypes loadFromXmlOri(String cloudNumber, Lang lang) {
        OpBizRuleTypes opBizRuleTypes = new OpBizRuleTypes();
        String resName = OPBIZ_RREFIX + cloudNumber.toLowerCase() + OPBIZ_ENDSUFFIX;
        URL url = OpBizRuleTypes.class.getClassLoader().getResource(resName);
        if (url != null) {
            opBizRuleTypes = OpBizRuleTypeLoader.get(resName, url, lang);
        }
        return opBizRuleTypes;
    }

    private static boolean isAppNumber(String[] appNumbers, String[] currentAppNumbers) {
        for (String appNumber : appNumbers) {
            for (String currentAppNumber : currentAppNumbers) {
                if (!appNumber.equals(currentAppNumber)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        allOriAppOpRuleTypes = new ConcurrentHashMap<String, OpBizRuleTypes>(20);
        dts.add(OrmUtils.getDataEntityType(OpBizRuleTypes.class));
        dts.add(OrmUtils.getDataEntityType(OpBizRuleType.class));
        cacheOpTasks = new HashMap<String, Map<String, String>>();
    }
}

