/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.param;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.ParamCell;
import kd.bos.entity.param.ParamKey;
import kd.bos.entity.param.ParamRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.facade.ISysParamServiceFacade;
import kd.bos.param.facade.SysParamServiceFactory;

public class ParamConvert {
    public static final String PARAM_DATA = "data";
    public static final String PARAM_LOCKFIELDS = "lockfields";
    public static final String PARAM_SYNCPARAMS = "syncparams";
    public static final String PARAM_CONFIG = "paramconfig";

    public static List<String> getParamItems(String formId) {
        ArrayList<String> entityItems = new ArrayList<String>(20);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return entityItems;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType(formId);
        Map<String, IDataEntityProperty> fields = entityType.getAllFields();
        for (IDataEntityProperty prop : fields.values()) {
            entityItems.add(prop.getName());
        }
        return entityItems;
    }

    public static Map<ParamKey, ParamRow> getParamRows(List<Map<String, Object>> orgParams, List<String> paramItems) {
        HashMap<ParamKey, ParamRow> rows = new HashMap<ParamKey, ParamRow>();
        if (orgParams.isEmpty()) {
            return rows;
        }
        DynamicObject paramData = null;
        for (Map<String, Object> orgParam : orgParams) {
            Object object;
            if (ObjectUtils.isEmpty(orgParam)) continue;
            if (orgParam.get(PARAM_DATA) != null) {
                paramData = (DynamicObject)orgParam.get(PARAM_DATA);
            }
            Map lockFields = StringUtils.isBlank((Object)(object = orgParam.get(PARAM_LOCKFIELDS))) ? null : (Map)SerializationUtils.fromJsonString((String)object.toString(), Map.class);
            for (String item : paramItems) {
                Object orgIdObject = orgParam.get("orgId");
                ParamKey key = null;
                if (orgIdObject instanceof BigDecimal) {
                    BigDecimal orgId = (BigDecimal)orgIdObject;
                    key = new ParamKey(item, orgId.longValue());
                } else {
                    key = new ParamKey(item, ((Long)orgIdObject).longValue());
                }
                try {
                    ParamRow row = new ParamRow(key, paramData == null || paramData.get(item) == null ? null : paramData.get(item), lockFields != null && lockFields.get(item) != null && (Boolean)lockFields.get(item) != false);
                    rows.put(key, row);
                }
                catch (Exception e) {
                    throw new KDException(new ErrorCode("", String.format(ResManager.loadKDString((String)"%s\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u7cfb\u7edf\u53c2\u6570\u4e0d\u652f\u6301\u653e\u7f6e\u5355\u636e\u4f53\u5bfc\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ParamConvert_0", (String)"bos-entity-metadata", (Object[])new Object[0]), e.getMessage())), new Object[0]);
                }
            }
        }
        return rows;
    }

    public static Map<ParamKey, ParamRow> getParamFormatRows(List<Map<String, Object>> orgParams, List<String> paramItems) {
        HashMap<ParamKey, ParamRow> rows = new HashMap<ParamKey, ParamRow>();
        if (orgParams.isEmpty()) {
            return rows;
        }
        Map paramData = null;
        for (Map<String, Object> orgParam : orgParams) {
            Object orgIdObj;
            String syncParamStr;
            Map configMap;
            if (orgParam.get(PARAM_DATA) != null) {
                paramData = (Map)orgParam.get(PARAM_DATA);
            }
            Object object = orgParam.get(PARAM_LOCKFIELDS);
            Object paramConfigObj = orgParam.get(PARAM_CONFIG);
            Map lockFields = StringUtils.isBlank((Object)object) ? null : (Map)SerializationUtils.fromJsonString((String)object.toString(), Map.class);
            Map syncParams = new HashMap(16);
            Map map = configMap = StringUtils.isBlank((Object)paramConfigObj) ? null : (Map)SerializationUtils.fromJsonString((String)paramConfigObj.toString(), Map.class);
            if (!CollectionUtils.isEmpty(configMap) && StringUtils.isNotEmpty((CharSequence)(syncParamStr = (String)configMap.get(PARAM_SYNCPARAMS)))) {
                syncParams = (Map)SerializationUtils.fromJsonString((String)syncParamStr, Map.class);
            }
            if ((orgIdObj = orgParam.get("orgId")) == null) continue;
            for (String item : paramItems) {
                ParamKey key = new ParamKey(item, Long.parseLong(orgIdObj.toString()));
                ParamRow row = new ParamRow(key, paramData == null || paramData.get(item) == null ? null : paramData.get(item), lockFields != null && lockFields.get(item) != null && (Boolean)lockFields.get(item) != false, syncParams != null && syncParams.get(item) != null && (Boolean)syncParams.get(item) != false);
                rows.put(key, row);
            }
        }
        return rows;
    }

    @Deprecated
    public static ParamCell getParamValue(Map<ParamKey, ParamRow> rows, long orgId, String param, List<Map<String, Object>> orgs) {
        List<Object> orgList = new ArrayList(10);
        ISysParamServiceFacade facade = SysParamServiceFactory.getFacade();
        orgList = null == facade || facade.getNoOrgFlag() != false ? Stream.of(Long.valueOf(0L)).collect(Collectors.toList()) : ParamConvert.getOrgList(orgId, orgs);
        int lockPos = ParamConvert.getLockPos(param, orgList, rows);
        ParamKey currentOrgkey = new ParamKey(param, orgId);
        ParamRow currentOrgParamRow = rows.get(currentOrgkey);
        for (int currentPos = lockPos < 0 ? 0 : lockPos; currentPos < orgList.size(); ++currentPos) {
            ParamKey key = new ParamKey(param, ((Long)orgList.get(currentPos)).longValue());
            ParamRow row = rows.get(key);
            Object paramValue = null;
            if (row == null || row.getValue() == null) continue;
            paramValue = row.getValue();
            if (lockPos >= 0) {
                if (currentOrgParamRow != null && StringUtils.isNotBlank((Object)currentOrgParamRow.getValue())) {
                    paramValue = currentOrgParamRow.getValue();
                }
            } else if (currentOrgParamRow != null) {
                paramValue = currentOrgParamRow.getValue();
            }
            return new ParamCell(key, paramValue, lockPos >= 0, currentPos == 0, lockPos == 0);
        }
        return null;
    }

    public static Tuple<String, Object> getParamValuePlus(Map<ParamKey, ParamRow> rows, long orgId, String param, List<Long> orgList) {
        ParamKey currentOrgKey = new ParamKey(param, orgId);
        ParamRow currentOrgParamRow = rows.get(currentOrgKey);
        if (currentOrgParamRow != null && StringUtils.isNotBlank((Object)currentOrgParamRow.getValue())) {
            return Tuple.create((Object)currentOrgKey.getParam(), (Object)currentOrgParamRow.getValue());
        }
        ISysParamServiceFacade facade = SysParamServiceFactory.getFacade();
        if (null == facade || facade.getNoOrgFlag().booleanValue()) {
            orgList = Stream.of(Long.valueOf(0L)).collect(Collectors.toList());
        }
        int lockPos = ParamConvert.getLockPos(param, orgList, rows);
        for (int currentPos = Math.max(lockPos, 0); currentPos < orgList.size(); ++currentPos) {
            ParamKey key = new ParamKey(param, orgList.get(currentPos).longValue());
            ParamRow row = rows.get(key);
            if (row == null || row.getValue() == null) continue;
            Object paramValue = row.getValue();
            if (lockPos >= 0) {
                if (currentOrgParamRow != null && StringUtils.isNotBlank((Object)currentOrgParamRow.getValue())) {
                    paramValue = currentOrgParamRow.getValue();
                }
            } else if (currentOrgParamRow != null) {
                paramValue = currentOrgParamRow.getValue();
            }
            return Tuple.create((Object)key.getParam(), (Object)paramValue);
        }
        return null;
    }

    public static int getLockPos(String param, List<Long> orgList, Map<ParamKey, ParamRow> rows) {
        int i;
        long currentId = 0L;
        for (i = orgList.size() - 1; i >= 0; --i) {
            currentId = orgList.get(i);
            ParamKey key = new ParamKey(param, currentId);
            ParamRow row = rows.get(key);
            if (row == null || !row.isLock()) continue;
            return i;
        }
        return i;
    }

    public static void updateLock(String param, long orgId, boolean isLock, Map<ParamKey, ParamRow> rows) {
        ParamKey key = new ParamKey(param, orgId);
        ParamRow row = rows.get(key);
        if (row == null) {
            row = new ParamRow(key, null, isLock);
            rows.put(key, row);
        } else {
            row.setLock(isLock);
        }
    }

    private static long getParentOrgId(long orgId, List<Map<String, Object>> orgs) {
        for (Map<String, Object> org : orgs) {
            if (Long.parseLong(org.get("id").toString()) != orgId || org.get("id").equals(org.get("parentid"))) continue;
            return Long.parseLong(org.get("parentid").toString());
        }
        return 0L;
    }

    private static List<Long> getOrgList(long orgId, List<Map<String, Object>> orgs) {
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        long currentOrgId = orgId;
        while (currentOrgId != 0L) {
            orgList.add(currentOrgId);
            currentOrgId = ParamConvert.getParentOrgId(currentOrgId, orgs);
        }
        return orgList;
    }
}

