/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.privacy;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.entity.privacy.PrivacyScheme;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.orm.query.QFilter;

public class PrivacySchemeUtil {
    public static PrivacyScheme create(String entityNumber, String fieldKey) {
        PrivacyScheme ps = new PrivacyScheme();
        ps.setSchemeId(DB.genGlobalLongId());
        ps.setEntityNumber(entityNumber);
        ps.setFieldKey(fieldKey);
        return ps;
    }

    public static PrivacyScheme load(String entityNumber, String fieldKey) {
        IDataEntityType type = OrmUtils.getDataEntityType(PrivacyScheme.class);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        QFilter[] filters = new QFilter[]{new QFilter("EntityNumber", "=", (Object)entityNumber)};
        Object[] privacySchemes = (PrivacyScheme[])cacheManager.getCachePks(filters);
        if (privacySchemes == null) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            params.add(new SqlParameter("EntityNumber", 12, (Object)entityNumber));
            ReadWhere rw = new ReadWhere(" EntityNumber = ? ", params);
            IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
            Object[] datas = dataManager.read(rw);
            privacySchemes = new PrivacyScheme[datas.length];
            for (int i = 0; i < privacySchemes.length; ++i) {
                PrivacyScheme ps = (PrivacyScheme)datas[i];
                privacySchemes[i] = ps;
            }
            cacheManager.put(datas);
            cacheManager.putCachePks(filters, privacySchemes);
        }
        for (int i = 0; i < privacySchemes.length; ++i) {
            PrivacyScheme ps = privacySchemes[i];
            if (!ps.getFieldKey().equals(fieldKey)) continue;
            return ps;
        }
        return null;
    }

    public static PrivacyScheme load(long schemeId) {
        IDataEntityType type = OrmUtils.getDataEntityType(PrivacyScheme.class);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        Object[] pkArray = new Long[]{schemeId};
        Map cacheMap = cacheManager.get(pkArray);
        PrivacyScheme dataEntity = (PrivacyScheme)cacheMap.get(schemeId);
        if (dataEntity != null) {
            return dataEntity;
        }
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        PrivacyScheme privacyScheme = (PrivacyScheme)dataManager.read((Object)schemeId);
        Object[] privacySchemes = new PrivacyScheme[]{privacyScheme};
        cacheManager.put(privacySchemes);
        return privacyScheme;
    }

    private static String queryPrivacyScheme(long schemeId) {
        String sql = "select FNAME from T_BAS_PRIVACYSCHEME_L where FID = ? and FLOCALEID = ?";
        SqlParameter[] parameters = new SqlParameter[]{Long.valueOf(schemeId), RequestContext.get().getLang().toString()};
        String name = null;
        return name;
    }

    private static PrivacyScheme[] queryPrivacySchemes(String entityNumber) {
        IDataEntityType type = OrmUtils.getDataEntityType(PrivacyScheme.class);
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter("EntityNumber", 12, (Object)entityNumber));
        ReadWhere rw = new ReadWhere(" EntityNumber = ? ", params);
        Object[] datas = dataManager.read(rw);
        PrivacyScheme[] privacySchemes = new PrivacyScheme[datas.length];
        for (int i = 0; i < privacySchemes.length; ++i) {
            privacySchemes[i] = (PrivacyScheme)datas[i];
        }
        return privacySchemes;
    }
}

